/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkupKind;

public class MarkupContent
extends JSONBase {
    MarkupContent(JSONObject jsonData) {
        super(jsonData);
    }

    public MarkupKind getKind() {
        return MarkupKind.get(this.jsonData.getString("kind"));
    }

    public MarkupContent setKind(MarkupKind kind) {
        this.jsonData.put("kind", kind.getStringValue());
        return this;
    }

    public String getValue() {
        return this.jsonData.getString("value");
    }

    public MarkupContent setValue(String value) {
        this.jsonData.put("value", value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkupContent other = (MarkupContent)obj;
        if (this.getKind() != other.getKind()) {
            return false;
        }
        return Objects.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + Objects.hashCode((Object)this.getKind());
        hash = 13 * hash + Objects.hashCode(this.getValue());
        return hash;
    }

    public static MarkupContent create(MarkupKind kind, String value) {
        JSONObject json = new JSONObject();
        json.put("kind", kind.getStringValue());
        json.put("value", value);
        return new MarkupContent(json);
    }
}

