/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.ClientCapabilities;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressParams;
import org.graalvm.tools.lsp.server.types.WorkspaceFolder;

public class InitializeParams
extends WorkDoneProgressParams {
    InitializeParams(JSONObject jsonData) {
        super(jsonData);
    }

    public Integer getProcessId() {
        Object obj = this.jsonData.get("processId");
        return JSONObject.NULL.equals(obj) ? null : (Integer)obj;
    }

    public InitializeParams setProcessId(Integer processId) {
        this.jsonData.put("processId", processId == null ? JSONObject.NULL : processId);
        return this;
    }

    public ClientInfoParams getClientInfo() {
        return this.jsonData.has("clientInfo") ? new ClientInfoParams(this.jsonData.optJSONObject("clientInfo")) : null;
    }

    public InitializeParams setClientInfo(ClientInfoParams clientInfo) {
        this.jsonData.putOpt("clientInfo", clientInfo != null ? clientInfo.jsonData : null);
        return this;
    }

    @Deprecated
    public String getRootPath() {
        Object obj = this.jsonData.opt("rootPath");
        return JSONObject.NULL.equals(obj) ? null : (String)obj;
    }

    public InitializeParams setRootPath(String rootPath) {
        this.jsonData.put("rootPath", rootPath == null ? JSONObject.NULL : rootPath);
        return this;
    }

    @Deprecated
    public String getRootUri() {
        Object obj = this.jsonData.get("rootUri");
        return JSONObject.NULL.equals(obj) ? null : (String)obj;
    }

    public InitializeParams setRootUri(String rootUri) {
        this.jsonData.put("rootUri", rootUri == null ? JSONObject.NULL : rootUri);
        return this;
    }

    public ClientCapabilities getCapabilities() {
        return new ClientCapabilities(this.jsonData.getJSONObject("capabilities"));
    }

    public InitializeParams setCapabilities(ClientCapabilities capabilities) {
        this.jsonData.put("capabilities", capabilities.jsonData);
        return this;
    }

    public Object getInitializationOptions() {
        return this.jsonData.opt("initializationOptions");
    }

    public InitializeParams setInitializationOptions(Object initializationOptions) {
        this.jsonData.putOpt("initializationOptions", initializationOptions);
        return this;
    }

    public String getTrace() {
        return this.jsonData.optString("trace", null);
    }

    public InitializeParams setTrace(String trace) {
        this.jsonData.putOpt("trace", trace);
        return this;
    }

    public List<WorkspaceFolder> getWorkspaceFolders() {
        JSONArray json = this.jsonData.optJSONArray("workspaceFolders");
        if (json == null) {
            return null;
        }
        ArrayList<WorkspaceFolder> list = new ArrayList<WorkspaceFolder>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new WorkspaceFolder(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public InitializeParams setWorkspaceFolders(List<WorkspaceFolder> workspaceFolders) {
        if (workspaceFolders != null) {
            JSONArray json = new JSONArray();
            for (WorkspaceFolder workspaceFolder : workspaceFolders) {
                json.put(workspaceFolder.jsonData);
            }
            this.jsonData.put("workspaceFolders", json);
        } else {
            this.jsonData.put("workspaceFolders", JSONObject.NULL);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializeParams other = (InitializeParams)obj;
        if (!Objects.equals(this.getProcessId(), other.getProcessId())) {
            return false;
        }
        if (!Objects.equals(this.getClientInfo(), other.getClientInfo())) {
            return false;
        }
        if (!Objects.equals(this.getRootPath(), other.getRootPath())) {
            return false;
        }
        if (!Objects.equals(this.getRootUri(), other.getRootUri())) {
            return false;
        }
        if (!Objects.equals(this.getCapabilities(), other.getCapabilities())) {
            return false;
        }
        if (!Objects.equals(this.getInitializationOptions(), other.getInitializationOptions())) {
            return false;
        }
        if (!Objects.equals(this.getTrace(), other.getTrace())) {
            return false;
        }
        if (!Objects.equals(this.getWorkspaceFolders(), other.getWorkspaceFolders())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        if (this.getProcessId() != null) {
            hash = 59 * hash + Integer.hashCode(this.getProcessId());
        }
        if (this.getClientInfo() != null) {
            hash = 59 * hash + Objects.hashCode(this.getClientInfo());
        }
        if (this.getRootPath() != null) {
            hash = 59 * hash + Objects.hashCode(this.getRootPath());
        }
        if (this.getRootUri() != null) {
            hash = 59 * hash + Objects.hashCode(this.getRootUri());
        }
        hash = 59 * hash + Objects.hashCode(this.getCapabilities());
        if (this.getInitializationOptions() != null) {
            hash = 59 * hash + Objects.hashCode(this.getInitializationOptions());
        }
        if (this.getTrace() != null) {
            hash = 59 * hash + Objects.hashCode(this.getTrace());
        }
        if (this.getWorkspaceFolders() != null) {
            hash = 59 * hash + Objects.hashCode(this.getWorkspaceFolders());
        }
        if (this.getWorkDoneToken() != null) {
            hash = 59 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        return hash;
    }

    public static InitializeParams create(Integer processId, String rootUri, ClientCapabilities capabilities, List<WorkspaceFolder> workspaceFolders) {
        JSONObject json = new JSONObject();
        json.put("processId", processId == null ? JSONObject.NULL : processId);
        json.put("rootUri", rootUri == null ? JSONObject.NULL : rootUri);
        json.put("capabilities", capabilities.jsonData);
        if (workspaceFolders != null) {
            JSONArray workspaceFoldersJsonArr = new JSONArray();
            for (WorkspaceFolder workspaceFolder : workspaceFolders) {
                workspaceFoldersJsonArr.put(workspaceFolder.jsonData);
            }
            json.put("workspaceFolders", workspaceFoldersJsonArr);
        } else {
            json.put("workspaceFolders", JSONObject.NULL);
        }
        return new InitializeParams(json);
    }

    public static class ClientInfoParams
    extends JSONBase {
        ClientInfoParams(JSONObject jsonData) {
            super(jsonData);
        }

        public String getName() {
            return this.jsonData.getString("name");
        }

        public ClientInfoParams setName(String name) {
            this.jsonData.put("name", name);
            return this;
        }

        public String getVersion() {
            return this.jsonData.optString("version", null);
        }

        public ClientInfoParams setVersion(String version) {
            this.jsonData.putOpt("version", version);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientInfoParams other = (ClientInfoParams)obj;
            if (!Objects.equals(this.getName(), other.getName())) {
                return false;
            }
            return Objects.equals(this.getVersion(), other.getVersion());
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + Objects.hashCode(this.getName());
            if (this.getVersion() != null) {
                hash = 89 * hash + Objects.hashCode(this.getVersion());
            }
            return hash;
        }
    }
}

