/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class FoldingRange
extends JSONBase {
    FoldingRange(JSONObject jsonData) {
        super(jsonData);
    }

    public int getStartLine() {
        return this.jsonData.getInt("startLine");
    }

    public FoldingRange setStartLine(int startLine) {
        this.jsonData.put("startLine", startLine);
        return this;
    }

    public Integer getStartCharacter() {
        return this.jsonData.has("startCharacter") ? Integer.valueOf(this.jsonData.getInt("startCharacter")) : null;
    }

    public FoldingRange setStartCharacter(Integer startCharacter) {
        this.jsonData.putOpt("startCharacter", startCharacter);
        return this;
    }

    public int getEndLine() {
        return this.jsonData.getInt("endLine");
    }

    public FoldingRange setEndLine(int endLine) {
        this.jsonData.put("endLine", endLine);
        return this;
    }

    public Integer getEndCharacter() {
        return this.jsonData.has("endCharacter") ? Integer.valueOf(this.jsonData.getInt("endCharacter")) : null;
    }

    public FoldingRange setEndCharacter(Integer endCharacter) {
        this.jsonData.putOpt("endCharacter", endCharacter);
        return this;
    }

    public String getKind() {
        return this.jsonData.optString("kind", null);
    }

    public FoldingRange setKind(String kind) {
        this.jsonData.putOpt("kind", kind);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FoldingRange other = (FoldingRange)obj;
        if (this.getStartLine() != other.getStartLine()) {
            return false;
        }
        if (!Objects.equals(this.getStartCharacter(), other.getStartCharacter())) {
            return false;
        }
        if (this.getEndLine() != other.getEndLine()) {
            return false;
        }
        if (!Objects.equals(this.getEndCharacter(), other.getEndCharacter())) {
            return false;
        }
        return Objects.equals(this.getKind(), other.getKind());
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Integer.hashCode(this.getStartLine());
        if (this.getStartCharacter() != null) {
            hash = 43 * hash + Integer.hashCode(this.getStartCharacter());
        }
        hash = 43 * hash + Integer.hashCode(this.getEndLine());
        if (this.getEndCharacter() != null) {
            hash = 43 * hash + Integer.hashCode(this.getEndCharacter());
        }
        if (this.getKind() != null) {
            hash = 43 * hash + Objects.hashCode(this.getKind());
        }
        return hash;
    }

    public static FoldingRange create(int startLine, int endLine, Integer startCharacter, Integer endCharacter, String kind) {
        JSONObject json = new JSONObject();
        json.put("startLine", startLine);
        if (startCharacter != null) {
            json.put("startCharacter", startCharacter);
        }
        json.put("endLine", endLine);
        if (endCharacter != null) {
            json.put("endCharacter", endCharacter);
        }
        json.putOpt("kind", kind);
        return new FoldingRange(json);
    }
}

