/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.SymbolKind;

public class DocumentSymbolClientCapabilities
extends JSONBase {
    DocumentSymbolClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDynamicRegistration() {
        return this.jsonData.has("dynamicRegistration") ? Boolean.valueOf(this.jsonData.getBoolean("dynamicRegistration")) : null;
    }

    public DocumentSymbolClientCapabilities setDynamicRegistration(Boolean dynamicRegistration) {
        this.jsonData.putOpt("dynamicRegistration", dynamicRegistration);
        return this;
    }

    public SymbolKindCapabilities getSymbolKind() {
        return this.jsonData.has("symbolKind") ? new SymbolKindCapabilities(this.jsonData.optJSONObject("symbolKind")) : null;
    }

    public DocumentSymbolClientCapabilities setSymbolKind(SymbolKindCapabilities symbolKind) {
        this.jsonData.putOpt("symbolKind", symbolKind != null ? symbolKind.jsonData : null);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getHierarchicalDocumentSymbolSupport() {
        return this.jsonData.has("hierarchicalDocumentSymbolSupport") ? Boolean.valueOf(this.jsonData.getBoolean("hierarchicalDocumentSymbolSupport")) : null;
    }

    public DocumentSymbolClientCapabilities setHierarchicalDocumentSymbolSupport(Boolean hierarchicalDocumentSymbolSupport) {
        this.jsonData.putOpt("hierarchicalDocumentSymbolSupport", hierarchicalDocumentSymbolSupport);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentSymbolClientCapabilities other = (DocumentSymbolClientCapabilities)obj;
        if (!Objects.equals(this.getDynamicRegistration(), other.getDynamicRegistration())) {
            return false;
        }
        if (!Objects.equals(this.getSymbolKind(), other.getSymbolKind())) {
            return false;
        }
        return Objects.equals(this.getHierarchicalDocumentSymbolSupport(), other.getHierarchicalDocumentSymbolSupport());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getDynamicRegistration() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getDynamicRegistration());
        }
        if (this.getSymbolKind() != null) {
            hash = 97 * hash + Objects.hashCode(this.getSymbolKind());
        }
        if (this.getHierarchicalDocumentSymbolSupport() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getHierarchicalDocumentSymbolSupport());
        }
        return hash;
    }

    public static DocumentSymbolClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new DocumentSymbolClientCapabilities(json);
    }

    public static class SymbolKindCapabilities
    extends JSONBase {
        SymbolKindCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        public List<SymbolKind> getValueSet() {
            JSONArray json = this.jsonData.optJSONArray("valueSet");
            if (json == null) {
                return null;
            }
            ArrayList<SymbolKind> list = new ArrayList<SymbolKind>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(SymbolKind.get(json.getInt(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public SymbolKindCapabilities setValueSet(List<SymbolKind> valueSet) {
            if (valueSet != null) {
                JSONArray json = new JSONArray();
                for (SymbolKind symbolKind : valueSet) {
                    json.put(symbolKind.getIntValue());
                }
                this.jsonData.put("valueSet", json);
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymbolKindCapabilities other = (SymbolKindCapabilities)obj;
            return Objects.equals(this.getValueSet(), other.getValueSet());
        }

        public int hashCode() {
            int hash = 5;
            if (this.getValueSet() != null) {
                hash = 17 * hash + Objects.hashCode(this.getValueSet());
            }
            return hash;
        }
    }
}

