/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.DiagnosticRelatedInformation;
import org.graalvm.tools.lsp.server.types.DiagnosticSeverity;
import org.graalvm.tools.lsp.server.types.DiagnosticTag;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;

public class Diagnostic
extends JSONBase {
    Diagnostic(JSONObject jsonData) {
        super(jsonData);
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public Diagnostic setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public DiagnosticSeverity getSeverity() {
        return DiagnosticSeverity.get(this.jsonData.has("severity") ? Integer.valueOf(this.jsonData.getInt("severity")) : null);
    }

    public Diagnostic setSeverity(DiagnosticSeverity severity) {
        this.jsonData.putOpt("severity", severity != null ? Integer.valueOf(severity.getIntValue()) : null);
        return this;
    }

    public Object getCode() {
        return this.jsonData.opt("code");
    }

    public Diagnostic setCode(Object code) {
        this.jsonData.putOpt("code", code);
        return this;
    }

    public String getSource() {
        return this.jsonData.optString("source", null);
    }

    public Diagnostic setSource(String source) {
        this.jsonData.putOpt("source", source);
        return this;
    }

    public String getMessage() {
        return this.jsonData.getString("message");
    }

    public Diagnostic setMessage(String message) {
        this.jsonData.put("message", message);
        return this;
    }

    public List<DiagnosticTag> getTags() {
        JSONArray json = this.jsonData.optJSONArray("tags");
        if (json == null) {
            return null;
        }
        ArrayList<DiagnosticTag> list = new ArrayList<DiagnosticTag>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(DiagnosticTag.get(json.getInt(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Diagnostic setTags(List<DiagnosticTag> tags) {
        if (tags != null) {
            JSONArray json = new JSONArray();
            for (DiagnosticTag diagnosticTag : tags) {
                json.put(diagnosticTag.getIntValue());
            }
            this.jsonData.put("tags", json);
        }
        return this;
    }

    public List<DiagnosticRelatedInformation> getRelatedInformation() {
        JSONArray json = this.jsonData.optJSONArray("relatedInformation");
        if (json == null) {
            return null;
        }
        ArrayList<DiagnosticRelatedInformation> list = new ArrayList<DiagnosticRelatedInformation>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new DiagnosticRelatedInformation(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Diagnostic setRelatedInformation(List<DiagnosticRelatedInformation> relatedInformation) {
        if (relatedInformation != null) {
            JSONArray json = new JSONArray();
            for (DiagnosticRelatedInformation diagnosticRelatedInformation : relatedInformation) {
                json.put(diagnosticRelatedInformation.jsonData);
            }
            this.jsonData.put("relatedInformation", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Diagnostic other = (Diagnostic)obj;
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        if (this.getSeverity() != other.getSeverity()) {
            return false;
        }
        if (!Objects.equals(this.getCode(), other.getCode())) {
            return false;
        }
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        if (!Objects.equals(this.getTags(), other.getTags())) {
            return false;
        }
        return Objects.equals(this.getRelatedInformation(), other.getRelatedInformation());
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.getRange());
        if (this.getSeverity() != null) {
            hash = 83 * hash + Objects.hashCode((Object)this.getSeverity());
        }
        if (this.getCode() != null) {
            hash = 83 * hash + Objects.hashCode(this.getCode());
        }
        if (this.getSource() != null) {
            hash = 83 * hash + Objects.hashCode(this.getSource());
        }
        hash = 83 * hash + Objects.hashCode(this.getMessage());
        if (this.getTags() != null) {
            hash = 83 * hash + Objects.hashCode(this.getTags());
        }
        if (this.getRelatedInformation() != null) {
            hash = 83 * hash + Objects.hashCode(this.getRelatedInformation());
        }
        return hash;
    }

    public static Diagnostic create(Range range, String message, DiagnosticSeverity severity, Object code, String source, List<DiagnosticRelatedInformation> relatedInformation) {
        JSONObject json = new JSONObject();
        json.put("range", range.jsonData);
        json.putOpt("severity", severity != null ? Integer.valueOf(severity.getIntValue()) : null);
        json.putOpt("code", code);
        json.putOpt("source", source);
        json.put("message", message);
        if (relatedInformation != null) {
            JSONArray relatedInformationJsonArr = new JSONArray();
            for (DiagnosticRelatedInformation diagnosticRelatedInformation : relatedInformation) {
                relatedInformationJsonArr.put(diagnosticRelatedInformation.jsonData);
            }
            json.put("relatedInformation", relatedInformationJsonArr);
        }
        return new Diagnostic(json);
    }
}

