/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CodeActionKind;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressOptions;

public class CodeActionOptions
extends WorkDoneProgressOptions {
    CodeActionOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public List<CodeActionKind> getCodeActionKinds() {
        JSONArray json = this.jsonData.optJSONArray("codeActionKinds");
        if (json == null) {
            return null;
        }
        ArrayList<CodeActionKind> list = new ArrayList<CodeActionKind>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(CodeActionKind.get(json.getString(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public CodeActionOptions setCodeActionKinds(List<CodeActionKind> codeActionKinds) {
        if (codeActionKinds != null) {
            JSONArray json = new JSONArray();
            for (CodeActionKind codeActionKind : codeActionKinds) {
                json.put(codeActionKind.getStringValue());
            }
            this.jsonData.put("codeActionKinds", json);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeActionOptions other = (CodeActionOptions)obj;
        if (!Objects.equals(this.getCodeActionKinds(), other.getCodeActionKinds())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneProgress(), other.getWorkDoneProgress());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getCodeActionKinds() != null) {
            hash = 89 * hash + Objects.hashCode(this.getCodeActionKinds());
        }
        if (this.getWorkDoneProgress() != null) {
            hash = 89 * hash + Boolean.hashCode(this.getWorkDoneProgress());
        }
        return hash;
    }

    public static CodeActionOptions create() {
        JSONObject json = new JSONObject();
        return new CodeActionOptions(json);
    }
}

