/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.ComponentInstaller;
import org.graalvm.component.installer.DependencyException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SuppressFBWarnings;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;

public class Verifier {
    private final Feedback feedback;
    private final ComponentRegistry localRegistry;
    private final ComponentCollection catalog;
    private boolean silent;
    private boolean replaceComponents;
    private boolean ignoreRequirements;
    private boolean collectErrors;
    private boolean ignoreExisting;
    private boolean collectVersion;
    private Version.Match versionMatch;
    private Version minVersion;
    private List<DependencyException> errors = new ArrayList<DependencyException>();

    public Verifier(Feedback feedback, ComponentRegistry registry, ComponentCollection catalog) {
        this.feedback = feedback.withBundle(ComponentInstaller.class);
        this.localRegistry = registry;
        this.catalog = catalog;
    }

    public boolean isCollectVersion() {
        return this.collectVersion;
    }

    public Verifier collectVersion(boolean collect) {
        this.collectVersion = collect;
        return this;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public Version.Match getVersionMatch() {
        return this.versionMatch;
    }

    public Verifier setVersionMatch(Version.Match versionMatch) {
        this.versionMatch = versionMatch;
        return this;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean isCollectErrors() {
        return this.collectErrors;
    }

    public void setCollectErrors(boolean collectErrors) {
        this.collectErrors = collectErrors;
    }

    public boolean isIgnoreExisting() {
        return this.ignoreExisting;
    }

    public Verifier ignoreExisting(boolean ignore) {
        this.ignoreExisting = ignore;
        return this;
    }

    public boolean isReplaceComponents() {
        return this.replaceComponents;
    }

    public Verifier replaceComponents(boolean value) {
        this.replaceComponents = value;
        return this;
    }

    public boolean isIgnoreRequirements() {
        return this.ignoreRequirements;
    }

    public Verifier ignoreRequirements(boolean value) {
        this.ignoreRequirements = value;
        return this;
    }

    public Verifier collect(boolean value) {
        this.collectErrors = value;
        return this;
    }

    private void addOrThrow(DependencyException ex) {
        if (!this.collectErrors) {
            throw ex;
        }
        this.errors.add(ex);
    }

    public void printRequirements(ComponentInfo info) {
        if (this.isSilent()) {
            return;
        }
        Map<String, String> requiredCaps = info.getRequiredGraalValues();
        Map<String, String> graalCaps = this.localRegistry.getGraalCapabilities();
        if (this.feedback.verboseOutput("VERIFY_VerboseCheckRequirements", this.catalog.shortenComponentId(info), info.getName(), info.getVersionString())) {
            ArrayList<String> keys = new ArrayList<String>(requiredCaps.keySet());
            Collections.sort(keys);
            String none = this.feedback.l10n("VERIFY_VerboseCapabilityNone", new Object[0]);
            for (String s : keys) {
                String v = graalCaps.get(s);
                this.feedback.verboseOutput("VERIFY_VerboseCapability", this.localRegistry.localizeCapabilityName(s), requiredCaps.get(s), v == null ? none : v);
            }
        }
    }

    public List<DependencyException> getErrors() {
        return this.errors;
    }

    public boolean shouldInstall(ComponentInfo componentInfo) {
        if (this.replaceComponents) {
            return true;
        }
        ComponentInfo existing = this.localRegistry.findComponent(componentInfo.getId());
        return existing == null || existing.getVersion().compareTo(componentInfo.getVersion()) < 0;
    }

    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="intentional comparison of strings using ==")
    public Verifier validateRequirements(ComponentInfo componentInfo) {
        this.errors.clear();
        ComponentInfo existing = this.localRegistry.findComponent(componentInfo.getId());
        if (existing != null && existing.getVersion().compareTo(componentInfo.getVersion()) >= 0 && !this.ignoreExisting && !this.replaceComponents) {
            this.addOrThrow(new DependencyException.Conflict(existing.getId(), componentInfo.getVersionString(), existing.getVersionString(), this.feedback.l10n("VERIFY_ComponentExists", existing.getName(), existing, existing.getVersionString())));
        }
        if (this.ignoreRequirements) {
            return this;
        }
        Map<String, String> requiredCaps = componentInfo.getRequiredGraalValues();
        Map<String, String> graalCaps = this.localRegistry.getGraalCapabilities();
        boolean verbose = this.feedback.verboseOutput(null, new Object[0]);
        if (!this.isSilent() && verbose) {
            this.feedback.verboseOutput("VERIFY_VerboseCheckRequirements", this.catalog.shortenComponentId(componentInfo), componentInfo.getName(), componentInfo.getVersionString());
            ArrayList<String> keys = new ArrayList<String>(requiredCaps.keySet());
            Collections.sort(keys);
            String none = this.feedback.l10n("VERIFY_VerboseCapabilityNone", new Object[0]);
            for (String s : keys) {
                String v = graalCaps.get(s);
                this.feedback.verboseOutput("VERIFY_VerboseCapability", this.localRegistry.localizeCapabilityName(s), requiredCaps.get(s), v == null ? none : v);
            }
        }
        for (String s : requiredCaps.keySet()) {
            boolean matches;
            String reqVal = requiredCaps.get(s);
            String graalVal = graalCaps.get(s);
            if ("graalvm_version".equals(s)) {
                Version gv;
                if (this.versionMatch != null) {
                    Version cv = Version.fromString(reqVal.toLowerCase());
                    matches = this.versionMatch.test(cv);
                } else {
                    Version rv = Version.fromString(reqVal);
                    gv = Version.fromString(graalVal);
                    matches = rv.installVersion().equals(gv.installVersion());
                }
                if (matches) continue;
                Version rq = Version.fromString(reqVal);
                gv = this.localRegistry.getGraalVersion();
                int n = gv.compareTo(rq);
                if (n > 0) {
                    if (gv.installVersion().equals(rq.installVersion())) continue;
                    this.addOrThrow(new DependencyException.Mismatch("org.graalvm", s, reqVal, graalVal, this.feedback.l10n("VERIFY_ObsoleteGraalVM", componentInfo.getName(), reqVal, gv.displayString())));
                    continue;
                }
                if (this.collectVersion) {
                    this.minVersion = rq;
                    continue;
                }
                this.addOrThrow(new DependencyException.Mismatch("org.graalvm", s, reqVal, graalVal, this.feedback.l10n("VERIFY_UpdateGraalVM", componentInfo.getName(), reqVal, gv.displayString())));
                continue;
            }
            matches = Verifier.matches(reqVal, graalVal);
            if (matches) continue;
            String val = graalVal != null ? graalVal : this.feedback.l10n("VERIFY_CapabilityMissing", new Object[0]);
            this.addOrThrow(new DependencyException.Mismatch(componentInfo.getId(), s, reqVal, graalVal, this.feedback.l10n("VERIFY_Dependency_Failed", componentInfo.getName(), this.localRegistry.localizeCapabilityName(s), reqVal, val)));
        }
        return this;
    }

    private static boolean matches(String reqVal, String graalVal) {
        return reqVal == graalVal || reqVal != null && graalVal != null && reqVal.replace('-', '_').compareToIgnoreCase(graalVal.replace('-', '_')) == 0;
    }
}

