/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds.rest;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.persist.AbstractCatalogStorage;

class GDSCatalogStorage
extends AbstractCatalogStorage {
    private final Map<String, Set<ComponentInfo>> components;

    GDSCatalogStorage(ComponentRegistry localRegistry, Feedback feedback, URL baseURL, Collection<ComponentInfo> artifacts) {
        super(localRegistry, feedback, baseURL);
        this.components = GDSCatalogStorage.buildComponentsMap(artifacts);
    }

    @Override
    public Set<String> listComponentIDs() throws IOException {
        return this.components.keySet();
    }

    @Override
    public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
        return this.components.get(id);
    }

    private static Map<String, Set<ComponentInfo>> buildComponentsMap(Collection<ComponentInfo> artifacts) {
        HashMap<String, Set<ComponentInfo>> comps = new HashMap<String, Set<ComponentInfo>>();
        for (ComponentInfo info : artifacts) {
            comps.computeIfAbsent(info.getId(), i -> new HashSet()).add(info);
        }
        return comps;
    }

    Map<String, Set<ComponentInfo>> getComponents() {
        return this.components;
    }
}

