/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.ComponentInstaller;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.UpgradeProcess;
import org.graalvm.component.installer.model.ComponentInfo;

public class UpgradeCommand
implements InstallerCommand {
    private static final Map<String, String> options = new HashMap<String, String>();
    private final boolean allowDistUpgrades;
    private CommandInput input;
    private Feedback feedback;
    private UpgradeProcess helper;
    private boolean verifyJars = true;

    public UpgradeCommand(boolean allowDistUpgrades) {
        this.allowDistUpgrades = allowDistUpgrades;
    }

    public UpgradeCommand() {
        this(true);
    }

    @Override
    public Map<String, String> supportedOptions() {
        return this.allowDistUpgrades ? options : Collections.emptyMap();
    }

    protected boolean allowDistUpgrades() {
        return this.allowDistUpgrades;
    }

    UpgradeProcess getProcess() {
        return this.helper;
    }

    protected void initUpgradeOptions() {
        String ed;
        ComponentCatalog coll = this.input.getRegistry();
        coll.setAllowDistUpdate(this.allowDistUpgrades());
        if (this.input.optValue("x") != null) {
            this.helper.setAllowMissing(true);
        }
        if (this.input.optValue("s") != null) {
            this.verifyJars = false;
        }
        if ((ed = this.input.optValue("$")) != null) {
            this.helper.setEditionUpgrade(ed);
        }
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        this.input = commandInput;
        this.feedback = feedBack.withBundle(UpgradeCommand.class);
        this.helper = new UpgradeProcess(this.input, feedBack, commandInput.getRegistry());
        this.initUpgradeOptions();
    }

    ComponentInfo configureProcess() throws IOException {
        this.input.existingFiles().setVerifyJars(this.verifyJars);
        Version min = this.input.getLocalRegistry().getGraalVersion();
        String s = this.input.peekParameter();
        Version v = min;
        Version.Match filter = min.match(this.allowDistUpgrades() ? Version.Match.Type.MOSTRECENT : Version.Match.Type.COMPATIBLE);
        if (s != null) {
            try {
                Object mt = Version.Match.Type.COMPATIBLE;
                if (s.startsWith("=")) {
                    mt = Version.Match.Type.EXACT;
                    s = s.substring(1);
                } else if (s.startsWith("+")) {
                    mt = Version.Match.Type.INSTALLABLE;
                    s = s.substring(1);
                }
                v = Version.fromUserString(s);
                filter = v.match((Version.Match.Type)((Object)mt));
                if (min.compareTo(v) > 0) {
                    throw this.feedback.failure("UPGRADE_CannotDowngrade", null, v.displayString());
                }
                this.input.nextParameter();
                this.input.existingFiles().matchVersion(filter);
            }
            catch (IllegalArgumentException mt) {
                // empty catch block
            }
        }
        for (ComponentParam p : this.input.existingFiles()) {
            this.helper.addComponent(p);
        }
        ComponentInfo info = this.helper.findGraalVersion(filter);
        return info;
    }

    @Override
    public int execute() throws IOException {
        this.input.getLocalRegistry().verifyAdministratorAccess();
        if (this.input.optValue("h") != null) {
            this.feedback.output(this.allowDistUpgrades ? "UPGRADE_Help" : "UPDATE_Help", new Object[0]);
            return 0;
        }
        try (UpgradeProcess h = this.helper;){
            ComponentInfo info = this.configureProcess();
            boolean workDone = this.allowDistUpgrades ? h.installGraalCore(info) : false;
            h.installAddedComponents();
            if (h.addedComponents().isEmpty()) {
                int n = workDone ? 0 : 1;
                return n;
            }
        }
        return 0;
    }

    static {
        options.put("x", "");
        options.put("ignore-missing", "x");
        options.put("s", "");
        options.put("n", "");
        options.put("no-progress", "n");
        options.put("no-verify-jars", "s");
        options.put("$", "s");
        options.put("edition", "$");
        options.put("d", "s");
        options.put("target-dir", "d");
        options.put("S", "");
        options.put("no-symlink", "S");
        options.putAll(ComponentInstaller.componentOptions);
    }
}

