/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.component.installer.SystemUtils;

public final class SoftwareChannelSource {
    private String locationURL;
    private String label;
    private int priority;
    private Map<String, String> params = new HashMap<String, String>();

    public SoftwareChannelSource(String locationURL) {
        this.locationURL = SystemUtils.parseURLParameters(locationURL, this.params);
    }

    public SoftwareChannelSource(String locationURL, String label) {
        this.locationURL = locationURL;
        this.label = label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParameter(String param, String value) {
        this.params.put(param, value);
    }

    public String getLocationURL() {
        return this.locationURL;
    }

    public String getLabel() {
        return this.label;
    }

    public String getParameter(String key) {
        return this.params.get(key);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

