/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.graalvm.component.installer.ComponentInstaller;
import org.graalvm.component.installer.Environment;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SimpleGetopt;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.jar.JarMetaLoader;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.remote.FileDownloader;

public final class GenerateCatalog {
    private List<String> params = new ArrayList<String>();
    private List<String> locations = new ArrayList<String>();
    private String graalVersionPrefix;
    private String graalVersionName;
    private String forceVersion;
    private String forceOS;
    private String forceVariant;
    private String forceArch;
    private String urlPrefix;
    private final StringBuilder catalogContents = new StringBuilder();
    private final StringBuilder catalogHeader = new StringBuilder();
    private Environment env;
    private String graalNameFormatString = "GraalVM %s %s%s/%s";
    private String graalVersionFormatString;
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private static final String OPT_FORMAT_1 = "1";
    private static final String OPT_FORMAT_2 = "2";
    private static final String OPT_VERBOSE = "v";
    private static final String OPT_GRAAL_PREFIX = "g";
    private static final String OPT_GRAAL_NAME = "n";
    private static final String OPT_GRAAL_NAME_FORMAT = "f";
    private static final String OPT_URL_BASE = "b";
    private static final String OPT_PATH_BASE = "p";
    private static final String OPT_FORCE_VERSION = "e";
    private static final String OPT_FORCE_OS = "o";
    private static final String OPT_FORCE_VARIANT = "V";
    private static final String OPT_FORCE_ARCH = "a";
    private static final String OPT_SEARCH_LOCATION = "l";
    private Map<String, GraalVersion> graalVMReleases = new LinkedHashMap<String, GraalVersion>();
    private List<Spec> componentSpecs = new ArrayList<Spec>();
    private Path pathBase = null;
    private String os;
    private String variant;
    private String arch;
    private String version;
    private int formatVer = 1;

    public static void main(String[] args) throws IOException {
        new GenerateCatalog(args).run();
        System.exit(0);
    }

    private GenerateCatalog(String[] args) {
        this.params = new ArrayList<String>(Arrays.asList(args));
    }

    private static byte[] computeHash(File f) throws IOException {
        MessageDigest fileDigest;
        try {
            fileDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Cannot compute digest " + ex.getLocalizedMessage(), ex);
        }
        ByteBuffer bb = ByteBuffer.allocate(2048);
        boolean updated = false;
        try (FileInputStream is = new FileInputStream(f);
             ReadableByteChannel bch = Channels.newChannel(is);){
            int read;
            while ((read = bch.read(bb)) >= 0) {
                bb.flip();
                fileDigest.update(bb);
                bb.clear();
                updated = true;
            }
        }
        if (!updated) {
            fileDigest.update(new byte[0]);
        }
        return fileDigest.digest();
    }

    static String digest2String(byte[] digest) {
        StringBuilder sb = new StringBuilder(digest.length * 3);
        for (int i = 0; i < digest.length; ++i) {
            sb.append(String.format("%02x", digest[i] & 0xFF));
        }
        return sb.toString();
    }

    public void run() throws IOException {
        this.readCommandLine();
        this.downloadFiles();
        this.generateCatalog();
        this.generateReleases();
        System.out.println(this.catalogHeader);
        System.out.println(this.catalogContents);
    }

    private void readCommandLine() throws IOException {
        SimpleGetopt getopt = new SimpleGetopt(OPTIONS){

            @Override
            public RuntimeException err(String messageKey, Object ... args) {
                ComponentInstaller.printErr(messageKey, args);
                System.exit(1);
                return null;
            }
        }.ignoreUnknownCommands(true);
        getopt.setParameters(new LinkedList<String>(this.params));
        getopt.process();
        this.env = new Environment(null, getopt.getPositionalParameters(), getopt.getOptValues());
        this.env.setAllOutputToErr(true);
        String pb = this.env.optValue(OPT_PATH_BASE);
        if (pb != null) {
            this.pathBase = SystemUtils.fromUserString(pb).toAbsolutePath();
        }
        this.urlPrefix = this.env.optValue(OPT_URL_BASE);
        this.graalVersionPrefix = this.env.optValue(OPT_GRAAL_PREFIX);
        if (this.graalVersionPrefix != null) {
            this.graalVersionName = this.env.optValue(OPT_GRAAL_NAME);
            if (this.graalVersionName == null) {
                throw new IOException("Graal prefix specified, but no human-readable name");
            }
        }
        this.forceVersion = this.env.optValue(OPT_FORCE_VERSION);
        this.forceOS = this.env.optValue(OPT_FORCE_OS);
        this.forceVariant = this.env.optValue(OPT_FORCE_VARIANT);
        this.forceArch = this.env.optValue(OPT_FORCE_ARCH);
        if (this.env.hasOption(OPT_FORMAT_1)) {
            this.formatVer = 1;
        } else if (this.env.hasOption(OPT_FORMAT_2)) {
            this.formatVer = 2;
        }
        String s = this.env.optValue(OPT_GRAAL_NAME_FORMAT);
        if (s != null) {
            this.graalNameFormatString = s;
        }
        switch (this.formatVer) {
            case 1: {
                this.graalVersionFormatString = "%s_%s%s_%s";
                break;
            }
            case 2: {
                this.graalVersionFormatString = "%2$s%3$s_%4$s/%1$s";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.env.hasOption(OPT_SEARCH_LOCATION)) {
            Path listFrom = Paths.get(this.env.optValue(OPT_SEARCH_LOCATION), new String[0]);
            Files.walk(listFrom, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".jar")).forEach(p -> this.locations.add(p.toString()));
        }
        while (this.env.hasParameter()) {
            this.locations.add(this.env.nextParameter());
        }
        for (String spec : this.locations) {
            File f = null;
            String u = null;
            int eq = spec.indexOf(61);
            if (eq != -1) {
                String uriPart;
                f = new File(spec.substring(0, eq));
                if (!f.exists()) {
                    throw new FileNotFoundException(f.toString());
                }
                u = uriPart = spec.substring(eq + 1);
            } else {
                f = new File(spec);
                if (!f.exists()) {
                    f = null;
                    u = spec;
                    URL check = SystemUtils.toURL(spec);
                    assert (check.toString() != null);
                }
            }
            this.addComponentSpec(f, u);
        }
    }

    private void addComponentSpec(File f, String u) {
        Spec spc = new Spec(f, u);
        if (f != null && this.pathBase != null) {
            spc.relativePath = this.pathBase.relativize(f.toPath().toAbsolutePath()).toString();
        }
        this.componentSpecs.add(spc);
    }

    private URL createURL(String spec) throws MalformedURLException {
        if (this.urlPrefix != null) {
            return SystemUtils.toURL(this.urlPrefix, spec);
        }
        return SystemUtils.toURL(spec);
    }

    private void downloadFiles() throws IOException {
        for (Spec spec : this.componentSpecs) {
            if (spec.f != null) continue;
            FileDownloader dn = new FileDownloader(spec.u, this.createURL(spec.u), this.env);
            dn.setDisplayProgress(true);
            dn.download();
            spec.f = dn.getLocalFile();
        }
    }

    private String findComponentPrefix(ComponentInfo info) {
        Map<String, String> m = info.getRequiredGraalValues();
        if (this.graalVersionPrefix != null) {
            this.variant = null;
            this.os = null;
            this.arch = null;
            this.version = this.graalVersionPrefix;
            return this.graalVersionPrefix;
        }
        if (this.forceVersion != null) {
            this.version = this.forceVersion;
        } else {
            switch (this.formatVer) {
                case 1: {
                    this.version = info.getVersionString();
                    break;
                }
                case 2: {
                    this.version = info.getVersion().toString();
                }
            }
        }
        String var = this.forceVariant != null ? this.forceVariant : m.get("os_variant");
        Object[] objectArray = new Object[4];
        objectArray[0] = this.version;
        this.os = this.forceOS != null ? this.forceOS : m.get("os_name");
        objectArray[1] = this.os;
        this.variant = var == null || var.isEmpty() ? "" : "_" + var;
        objectArray[2] = this.variant;
        this.arch = this.forceArch != null ? this.forceArch : m.get("os_arch");
        objectArray[3] = this.arch;
        return String.format(this.graalVersionFormatString, objectArray);
    }

    private void generateReleases() {
        for (String prefix : this.graalVMReleases.keySet()) {
            String n;
            String vprefix;
            GraalVersion ver = this.graalVMReleases.get(prefix);
            if (ver.os == null) {
                vprefix = this.graalVersionPrefix;
                n = this.graalVersionName;
            } else {
                vprefix = String.format(this.graalVersionFormatString, ver.version, ver.os, ver.variant, ver.arch);
                n = String.format(this.graalNameFormatString, ver.version, ver.os, ver.variant, ver.arch);
            }
            this.catalogHeader.append("org.graalvm").append('.').append(vprefix).append('=').append(n).append('\n');
            if (ver.os != null) continue;
            break;
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void generateCatalog() throws IOException {
        for (Spec spec : this.componentSpecs) {
            File f = spec.f;
            byte[] hash = GenerateCatalog.computeHash(f);
            String hashString = GenerateCatalog.digest2String(hash);
            try (JarFile jf = new JarFile(f);){
                String sel;
                int endPos;
                int pos;
                String name;
                Manifest mf;
                JarMetaLoader ldr = new JarMetaLoader(jf, hashString, (Feedback)this.env);
                ComponentInfo info = ldr.createComponentInfo();
                Object prefix = this.findComponentPrefix(info);
                if (!this.graalVMReleases.containsKey(prefix)) {
                    this.graalVMReleases.put((String)prefix, new GraalVersion(this.version, this.os, this.variant, this.arch));
                }
                if ((mf = jf.getManifest()) == null) {
                    throw new IOException("No manifest in " + String.valueOf(spec));
                }
                Object tagString = this.formatVer < 2 || info.getTag() == null || info.getTag().isEmpty() ? "" : "/" + hashString;
                Attributes atts = mf.getMainAttributes();
                String bid = atts.getValue("Bundle-Symbolic-Name").toLowerCase().replace("-", "_");
                String bl = atts.getValue("Bundle-Name");
                if (bid == null) {
                    throw new IOException("Missing bundle id in " + String.valueOf(spec));
                }
                if (bl == null) {
                    throw new IOException("Missing bundle name in " + String.valueOf(spec));
                }
                prefix = (String)prefix + (String)tagString;
                if (spec.u != null) {
                    name = spec.u.toString();
                } else {
                    String string = name = spec.relativePath != null ? spec.relativePath : f.getName();
                }
                while ((pos = name.indexOf("${")) != -1 && (endPos = name.indexOf("}", pos + 1)) != -1) {
                    String key = name.substring(pos + 2, endPos);
                    String repl = info.getRequiredGraalValues().get(key);
                    if (repl == null) {
                        switch (key) {
                            case "version": {
                                repl = this.version;
                                break;
                            }
                            case "os": {
                                repl = this.os;
                                break;
                            }
                            case "arch": {
                                repl = this.arch;
                                break;
                            }
                            case "comp_version": {
                                repl = info.getVersionString();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(key);
                            }
                        }
                    }
                    if (repl == null) {
                        throw new IllegalArgumentException(key);
                    }
                    String toReplace = "${" + key + "}";
                    name = name.replace(toReplace, repl);
                }
                String url = this.urlPrefix == null || this.urlPrefix.isEmpty() ? name : this.urlPrefix + "/" + name;
                String hashSuffix = switch (this.formatVer) {
                    case 1 -> {
                        sel = "Component.{0}.{1}";
                        yield "-hash";
                    }
                    case 2 -> {
                        sel = "Component.{0}/{1}";
                        yield "-hash";
                    }
                    default -> throw new IllegalStateException();
                };
                this.catalogContents.append(MessageFormat.format(sel + "={2}\n", prefix, bid, url));
                this.catalogContents.append(MessageFormat.format(sel + hashSuffix + "={2}\n", prefix, bid, hashString));
                for (Object a : atts.keySet()) {
                    String key = a.toString();
                    String val = atts.getValue(key);
                    if (key.startsWith("x-GraalVM-Message-")) continue;
                    this.catalogContents.append(MessageFormat.format(sel + "-{2}={3}\n", prefix, bid, key, val));
                }
            }
        }
    }

    static {
        OPTIONS.put(OPT_FORMAT_1, "");
        OPTIONS.put(OPT_FORMAT_2, "");
        OPTIONS.put(OPT_VERBOSE, "");
        OPTIONS.put(OPT_GRAAL_PREFIX, "s");
        OPTIONS.put(OPT_FORCE_VERSION, "s");
        OPTIONS.put(OPT_FORCE_OS, "s");
        OPTIONS.put(OPT_FORCE_VARIANT, "s");
        OPTIONS.put(OPT_GRAAL_NAME_FORMAT, "s");
        OPTIONS.put(OPT_GRAAL_NAME, "s");
        OPTIONS.put(OPT_FORCE_ARCH, "s");
        OPTIONS.put(OPT_GRAAL_NAME, "");
        OPTIONS.put(OPT_URL_BASE, "s");
        OPTIONS.put(OPT_PATH_BASE, "s");
        OPTIONS.put(OPT_SEARCH_LOCATION, "s");
    }

    static class Spec {
        File f;
        String u;
        String relativePath;

        Spec(File f, String u) {
            this.f = f;
            this.u = u;
        }
    }

    static class GraalVersion {
        String version;
        String os;
        String variant;
        String arch;

        GraalVersion(String version, String os, String variant, String arch) {
            this.version = version;
            this.os = os;
            this.variant = variant;
            this.arch = arch;
        }
    }
}

