/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class StackFrame
extends JSONBase {
    StackFrame(JSONObject jsonData) {
        super(jsonData);
    }

    public int getId() {
        return this.jsonData.getInt("id");
    }

    public StackFrame setId(int id) {
        this.jsonData.put("id", id);
        return this;
    }

    public String getName() {
        return this.jsonData.getString("name");
    }

    public StackFrame setName(String name) {
        this.jsonData.put("name", name);
        return this;
    }

    public Source getSource() {
        return this.jsonData.has("source") ? new Source(this.jsonData.optJSONObject("source")) : null;
    }

    public StackFrame setSource(Source source) {
        this.jsonData.putOpt("source", source != null ? source.jsonData : null);
        return this;
    }

    public int getLine() {
        return this.jsonData.getInt("line");
    }

    public StackFrame setLine(int line) {
        this.jsonData.put("line", line);
        return this;
    }

    public int getColumn() {
        return this.jsonData.getInt("column");
    }

    public StackFrame setColumn(int column) {
        this.jsonData.put("column", column);
        return this;
    }

    public Integer getEndLine() {
        return this.jsonData.has("endLine") ? Integer.valueOf(this.jsonData.getInt("endLine")) : null;
    }

    public StackFrame setEndLine(Integer endLine) {
        this.jsonData.putOpt("endLine", endLine);
        return this;
    }

    public Integer getEndColumn() {
        return this.jsonData.has("endColumn") ? Integer.valueOf(this.jsonData.getInt("endColumn")) : null;
    }

    public StackFrame setEndColumn(Integer endColumn) {
        this.jsonData.putOpt("endColumn", endColumn);
        return this;
    }

    public String getInstructionPointerReference() {
        return this.jsonData.optString("instructionPointerReference", null);
    }

    public StackFrame setInstructionPointerReference(String instructionPointerReference) {
        this.jsonData.putOpt("instructionPointerReference", instructionPointerReference);
        return this;
    }

    public Object getModuleId() {
        return this.jsonData.opt("moduleId");
    }

    public StackFrame setModuleId(Object moduleId) {
        this.jsonData.putOpt("moduleId", moduleId);
        return this;
    }

    public String getPresentationHint() {
        return this.jsonData.optString("presentationHint", null);
    }

    public StackFrame setPresentationHint(String presentationHint) {
        this.jsonData.putOpt("presentationHint", presentationHint);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackFrame other = (StackFrame)obj;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        if (!Objects.equals(this.getEndLine(), other.getEndLine())) {
            return false;
        }
        if (!Objects.equals(this.getEndColumn(), other.getEndColumn())) {
            return false;
        }
        if (!Objects.equals(this.getInstructionPointerReference(), other.getInstructionPointerReference())) {
            return false;
        }
        if (!Objects.equals(this.getModuleId(), other.getModuleId())) {
            return false;
        }
        return Objects.equals(this.getPresentationHint(), other.getPresentationHint());
    }

    public int hashCode() {
        int hash = 2;
        hash = 53 * hash + Integer.hashCode(this.getId());
        hash = 53 * hash + Objects.hashCode(this.getName());
        if (this.getSource() != null) {
            hash = 53 * hash + Objects.hashCode(this.getSource());
        }
        hash = 53 * hash + Integer.hashCode(this.getLine());
        hash = 53 * hash + Integer.hashCode(this.getColumn());
        if (this.getEndLine() != null) {
            hash = 53 * hash + Integer.hashCode(this.getEndLine());
        }
        if (this.getEndColumn() != null) {
            hash = 53 * hash + Integer.hashCode(this.getEndColumn());
        }
        if (this.getInstructionPointerReference() != null) {
            hash = 53 * hash + Objects.hashCode(this.getInstructionPointerReference());
        }
        if (this.getModuleId() != null) {
            hash = 53 * hash + Objects.hashCode(this.getModuleId());
        }
        if (this.getPresentationHint() != null) {
            hash = 53 * hash + Objects.hashCode(this.getPresentationHint());
        }
        return hash;
    }

    public static StackFrame create(Integer id, String name, Integer line, Integer column) {
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("name", name);
        json.put("line", line);
        json.put("column", column);
        return new StackFrame(json);
    }
}

