/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class SourceBreakpoint
extends JSONBase {
    SourceBreakpoint(JSONObject jsonData) {
        super(jsonData);
    }

    public int getLine() {
        return this.jsonData.getInt("line");
    }

    public SourceBreakpoint setLine(int line) {
        this.jsonData.put("line", line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public SourceBreakpoint setColumn(Integer column) {
        this.jsonData.putOpt("column", column);
        return this;
    }

    public String getCondition() {
        return this.jsonData.optString("condition", null);
    }

    public SourceBreakpoint setCondition(String condition) {
        this.jsonData.putOpt("condition", condition);
        return this;
    }

    public String getHitCondition() {
        return this.jsonData.optString("hitCondition", null);
    }

    public SourceBreakpoint setHitCondition(String hitCondition) {
        this.jsonData.putOpt("hitCondition", hitCondition);
        return this;
    }

    public String getLogMessage() {
        return this.jsonData.optString("logMessage", null);
    }

    public SourceBreakpoint setLogMessage(String logMessage) {
        this.jsonData.putOpt("logMessage", logMessage);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceBreakpoint other = (SourceBreakpoint)obj;
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getCondition(), other.getCondition())) {
            return false;
        }
        if (!Objects.equals(this.getHitCondition(), other.getHitCondition())) {
            return false;
        }
        return Objects.equals(this.getLogMessage(), other.getLogMessage());
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Integer.hashCode(this.getLine());
        if (this.getColumn() != null) {
            hash = 37 * hash + Integer.hashCode(this.getColumn());
        }
        if (this.getCondition() != null) {
            hash = 37 * hash + Objects.hashCode(this.getCondition());
        }
        if (this.getHitCondition() != null) {
            hash = 37 * hash + Objects.hashCode(this.getHitCondition());
        }
        if (this.getLogMessage() != null) {
            hash = 37 * hash + Objects.hashCode(this.getLogMessage());
        }
        return hash;
    }

    public static SourceBreakpoint create(Integer line) {
        JSONObject json = new JSONObject();
        json.put("line", line);
        return new SourceBreakpoint(json);
    }
}

