/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.CompletionItem;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CompletionsResponse
extends Response {
    CompletionsResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public CompletionsResponse setBody(ResponseBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionsResponse other = (CompletionsResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.getBody());
        hash = 53 * hash + Objects.hashCode(this.getType());
        hash = 53 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 53 * hash + Boolean.hashCode(this.isSuccess());
        hash = 53 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 53 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 53 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static CompletionsResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", body.jsonData);
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new CompletionsResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<CompletionItem> getTargets() {
            JSONArray json = this.jsonData.getJSONArray("targets");
            ArrayList<CompletionItem> list = new ArrayList<CompletionItem>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new CompletionItem(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setTargets(List<CompletionItem> targets) {
            JSONArray json = new JSONArray();
            for (CompletionItem completionItem : targets) {
                json.put(completionItem.jsonData);
            }
            this.jsonData.put("targets", json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getTargets(), other.getTargets());
        }

        public int hashCode() {
            int hash = 7;
            hash = 61 * hash + Objects.hashCode(this.getTargets());
            return hash;
        }

        public static ResponseBody create(List<CompletionItem> targets) {
            JSONObject json = new JSONObject();
            JSONArray targetsJsonArr = new JSONArray();
            for (CompletionItem completionItem : targets) {
                targetsJsonArr.put(completionItem.jsonData);
            }
            json.put("targets", targetsJsonArr);
            return new ResponseBody(json);
        }
    }
}

