/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.insight.heap.instrument;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.graalvm.collections.EconomicMap;
import org.graalvm.tools.insight.heap.HeapDump;
import org.graalvm.tools.insight.heap.instrument.CacheReplacement;
import org.graalvm.tools.insight.heap.instrument.HeapException;
import org.graalvm.tools.insight.heap.instrument.HeapGenerator;
import org.graalvm.tools.insight.heap.instrument.InteropUtils;
import org.graalvm.tools.insight.heap.instrument.WeakIdentityHashMap;

@ExportLibrary(value=InteropLibrary.class)
final class MemoryDump
implements TruffleObject {
    static final String FORMAT = "format";
    static final String DEPTH = "depth";
    static final String EVENTS = "events";
    static final String STACK = "stack";
    private static final String FORMAT_VERSION = "1.0";
    private static final InteropLibrary iop = InteropLibrary.getUncached();
    private static final MembersArray MEMBERS = new MembersArray("format", "depth", "events");
    private final int limit;
    private final CacheReplacement replacement;
    private final Supplier<HeapDump.Builder> heapDumpBuilder;
    private int maxDepth = 0;
    private final List<Object> events;
    private final WeakIdentityHashMap<Object, ObjectCopy> objectCache = new WeakIdentityHashMap();
    private final Map<String, MetaObjectCopy> metaObjectCache = new HashMap<String, MetaObjectCopy>();

    MemoryDump(int limit, CacheReplacement replacement, Supplier<HeapDump.Builder> heapDumpBuilder) {
        assert (replacement != null);
        assert (heapDumpBuilder != null);
        this.limit = limit;
        this.replacement = replacement;
        this.heapDumpBuilder = heapDumpBuilder;
        this.events = replacement == CacheReplacement.LRU ? new LinkedList<Object>() : new ArrayList<Object>();
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        switch (member) {
            case "format": 
            case "depth": 
            case "events": {
                return true;
            }
        }
        return false;
    }

    @ExportMessage
    Object readMember(String name) throws UnknownIdentifierException {
        switch (name) {
            case "format": {
                return FORMAT_VERSION;
            }
            case "depth": {
                return this.maxDepth;
            }
            case "events": {
                return new ListArray(this.events);
            }
        }
        throw UnknownIdentifierException.create((String)name);
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return MEMBERS;
    }

    void addDump(Object[] dump) throws UnsupportedTypeException, UnsupportedMessageException {
        HeapGenerator.DumpData dumpData = HeapGenerator.getDumpData(dump);
        this.maxDepth = Math.max(this.maxDepth, dumpData.getDepth());
        long eventCount = iop.getArraySize(dumpData.getEvents());
        int i = 0;
        while ((long)i < eventCount) {
            Object event = InteropUtils.readArrayElement(dumpData.getEvents(), i, "event");
            Object eventStack = HeapGenerator.readMember(iop, event, STACK);
            Integer depthOrNull = HeapGenerator.asIntOrNull(iop, event, DEPTH);
            int eventDepth = depthOrNull != null ? depthOrNull.intValue() : dumpData.getDepth();
            StackCopier copier = new StackCopier();
            Object stack = copier.copyStack(eventStack, eventDepth);
            this.events.add(new Event(stack));
            if (this.limit >= 0 && this.events.size() > this.limit) {
                if (this.replacement == CacheReplacement.FLUSH) {
                    this.flush();
                    this.maxDepth = dumpData.getDepth();
                } else {
                    assert (this.replacement == CacheReplacement.LRU) : this.replacement;
                    this.events.remove(0);
                }
            }
            ++i;
        }
    }

    int eventCount() {
        return this.events.size();
    }

    void clear() {
        this.events.clear();
    }

    void flush() throws UnsupportedTypeException, UnsupportedMessageException {
        HeapGenerator heap = new HeapGenerator(this.heapDumpBuilder.get());
        heap.dump(new Object[]{this});
        this.events.clear();
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ListArray
    implements TruffleObject {
        private final List<?> list;

        private ListArray(List<?> list) {
            this.list = list;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.list.size();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < (long)this.list.size();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.list.get((int)index);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MembersArray
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final String[] members;

        private MembersArray(String ... members) {
            this.members = members;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.members.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < (long)this.members.length;
        }

        @ExportMessage
        Object readArrayElement(long index, @Bind(value="$node") Node node, @Cached InlinedBranchProfile exception) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                exception.enter(node);
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.members[(int)index];
        }
    }

    private final class StackCopier {
        private final Map<Object, Object> duplicates = new IdentityHashMap<Object, Object>();

        private StackCopier() {
        }

        Object copyStack(Object eventStack, int eventDepth) {
            long count;
            if (!iop.hasArrayElements(eventStack)) {
                throw new HeapException("The `stack` must be an array");
            }
            try {
                count = iop.getArraySize(eventStack);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((String)"Can not read size of a stack array");
            }
            Object[] elements = new StackTraceElement[(int)count];
            int j = 0;
            int i = 0;
            while ((long)i < count) {
                Object item = InteropUtils.readArrayElement(eventStack, i, "event stack");
                Location at = new Location(HeapGenerator.readMember(iop, item, "at"));
                Object frame = HeapGenerator.readMember(iop, item, "frame");
                Object frameCopy = this.copyObject(frame, eventDepth + 1);
                if (frameCopy != null) {
                    elements[j++] = new StackTraceElement(at, frameCopy);
                }
                ++i;
            }
            if (j != elements.length) {
                elements = Arrays.copyOf(elements, j);
            }
            return new ArrayObject(elements);
        }

        private Object copyObject(Object obj, int depth) {
            Object preferredValue = this.preferredValueOf(obj);
            if (preferredValue != null) {
                return preferredValue;
            }
            if (iop.isExecutable(obj)) {
                return null;
            }
            if (iop.hasMembers(obj)) {
                long count;
                Object members;
                if (depth <= 0) {
                    return Unreachable.INSTANCE;
                }
                Object dupl = this.duplicates.get(obj);
                if (dupl != null) {
                    return dupl;
                }
                ObjectCopy newObj = new ObjectCopy();
                this.duplicates.put(obj, newObj);
                ObjectCopy prevObj = MemoryDump.this.objectCache.get(obj);
                boolean same = prevObj != null;
                try {
                    members = iop.getMembers(obj);
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((String)obj.getClass().getName());
                }
                try {
                    count = iop.getArraySize(members);
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((String)members.getClass().getName());
                }
                int i = 0;
                while ((long)i < count) {
                    String name;
                    Object member = InteropUtils.readArrayElement(members, i, "member");
                    try {
                        name = iop.asString(member);
                    }
                    catch (UnsupportedMessageException ex) {
                        throw new HeapException("Member must be a string.");
                    }
                    if (iop.isMemberReadable(obj, name) && !iop.hasMemberReadSideEffects(obj, name)) {
                        Object value;
                        try {
                            value = iop.readMember(obj, name);
                        }
                        catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                            throw new HeapException("Can not read member " + name);
                        }
                        Object newValue = this.copyObject(value, depth - 1);
                        if (newValue != null) {
                            if ((!(newValue instanceof ObjectCopy) || ((ObjectCopy)newValue).isFinished()) && same && prevObj.members.get((Object)name) != newValue) {
                                same = false;
                            }
                            newObj.addMember(name, newValue);
                        }
                    }
                    ++i;
                }
                if (same && prevObj.members.size() == newObj.members.size()) {
                    this.duplicates.put(obj, prevObj);
                    return prevObj;
                }
                newObj.setMetaObject(this.copyMetaObject(obj));
                newObj.setFinished();
                MemoryDump.this.objectCache.put(obj, newObj);
                return newObj;
            }
            return obj;
        }

        MetaObjectCopy copyMetaObject(Object obj) {
            if (!iop.hasMetaObject(obj)) {
                return null;
            }
            try {
                Object metaObj = iop.getMetaObject(obj);
                String qualifiedName = iop.asString(iop.getMetaQualifiedName(metaObj));
                MetaObjectCopy metaCopy = MemoryDump.this.metaObjectCache.get(qualifiedName);
                if (metaCopy == null) {
                    String simpleName = iop.asString(iop.getMetaSimpleName(metaObj));
                    metaCopy = new MetaObjectCopy(simpleName, qualifiedName);
                }
                return metaCopy;
            }
            catch (UnsupportedMessageException ex) {
                return null;
            }
        }

        private Object preferredValueOf(Object obj) {
            if (iop.isNull(obj)) {
                return obj;
            }
            if (obj instanceof Boolean || obj instanceof Byte || obj instanceof Character || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof CharSequence) {
                return obj;
            }
            return null;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Event
    implements TruffleObject {
        private static final MembersArray MEMBERS = new MembersArray("stack");
        private final Object stack;

        Event(Object stack) {
            this.stack = stack;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return MEMBERS;
        }

        @ExportMessage
        boolean isMemberReadable(String member) {
            return member.equals(MemoryDump.STACK);
        }

        @ExportMessage
        Object readMember(String name) throws UnknownIdentifierException {
            if (name.equals(MemoryDump.STACK)) {
                return this.stack;
            }
            throw UnknownIdentifierException.create((String)name);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Unreachable
    implements TruffleObject {
        static final Unreachable INSTANCE = new Unreachable();
        private static final String UNREACHABLE = "<unreachable>";
        private static final MembersArray MEMBERS = new MembersArray("<unreachable>");

        Unreachable() {
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return MEMBERS;
        }

        @ExportMessage
        boolean isMemberReadable(String member) {
            return UNREACHABLE.equals(member);
        }

        @ExportMessage
        Object readMember(String name) throws UnknownIdentifierException {
            if (UNREACHABLE.equals(name)) {
                return Boolean.TRUE;
            }
            throw UnknownIdentifierException.create((String)name);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MetaObjectCopy
    implements TruffleObject {
        private final String metaSimpleName;
        private final String metaQualifiedName;

        MetaObjectCopy(String metaSimpleName, String metaQualifiedName) {
            this.metaSimpleName = metaSimpleName;
            this.metaQualifiedName = metaQualifiedName;
        }

        @ExportMessage
        boolean isMetaObject() {
            return true;
        }

        @ExportMessage
        Object getMetaSimpleName() {
            return this.metaSimpleName;
        }

        @ExportMessage
        Object getMetaQualifiedName() {
            return this.metaQualifiedName;
        }

        @ExportMessage
        boolean isMetaInstance(Object instance) {
            return instance instanceof ObjectCopy && ((ObjectCopy)instance).metaObject == this;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ObjectCopy
    implements TruffleObject {
        private final EconomicMap<String, Object> members = EconomicMap.create();
        private MetaObjectCopy metaObject;
        private boolean finished = false;

        ObjectCopy() {
        }

        void addMember(String name, Object value) {
            assert (!this.finished);
            this.members.put((Object)name, value);
        }

        void setMetaObject(MetaObjectCopy metaObject) {
            this.metaObject = metaObject;
        }

        boolean isFinished() {
            return this.finished;
        }

        void setFinished() {
            this.finished = true;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        @ExportMessage
        Object getMembers(boolean includeInternal) {
            assert (this.isFinished());
            String[] names = new String[this.members.size()];
            int i = 0;
            for (String name : this.members.getKeys()) {
                names[i++] = name;
            }
            return new MembersArray(names);
        }

        @CompilerDirectives.TruffleBoundary
        @ExportMessage
        boolean isMemberReadable(String member) {
            return this.members.containsKey((Object)member);
        }

        @CompilerDirectives.TruffleBoundary
        @ExportMessage
        Object readMember(String name) throws UnknownIdentifierException {
            Object value = this.members.get((Object)name);
            if (value != null) {
                return value;
            }
            throw UnknownIdentifierException.create((String)name);
        }

        @ExportMessage
        boolean hasMetaObject() {
            return this.metaObject != null;
        }

        @ExportMessage
        Object getMetaObject() throws UnsupportedMessageException {
            if (this.metaObject != null) {
                return this.metaObject;
            }
            throw UnsupportedMessageException.create();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ArrayObject
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Object[] array;

        private ArrayObject(Object[] array) {
            this.array = array;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.array.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < (long)this.array.length;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.array[(int)index];
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class StackTraceElement
    implements TruffleObject {
        private static final String PROP_AT = "at";
        private static final String PROP_FRAME = "frame";
        private static final MembersArray MEMBERS = new MembersArray("at", "frame");
        private final Location at;
        private final Object frame;

        private StackTraceElement(Location at, Object frame) {
            this.at = at;
            this.frame = frame;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return MEMBERS;
        }

        @ExportMessage
        boolean isMemberReadable(String member) {
            switch (member) {
                case "at": 
                case "frame": {
                    return true;
                }
            }
            return false;
        }

        @ExportMessage
        Object readMember(String name) throws UnknownIdentifierException {
            switch (name) {
                case "at": {
                    return this.at;
                }
                case "frame": {
                    return this.frame;
                }
            }
            throw UnknownIdentifierException.create((String)name);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Location
    implements TruffleObject {
        private static final String PROP_NAME = "name";
        private static final String PROP_SOURCE = "source";
        private static final String PROP_LINE = "line";
        private static final String PROP_COLUMN = "column";
        private static final String PROP_CHAR_INDEX = "charIndex";
        private static final String PROP_CHAR_LENGTH = "charLength";
        private static final MembersArray MEMBERS = new MembersArray("name", "source", "line", "column", "charIndex", "charLength");
        private final String name;
        private final Object source;
        private final Integer line;
        private final Integer column;
        private final Integer charIndex;
        private final Integer charLength;

        private Location(Object at) {
            this.name = HeapGenerator.asStringOrNull(iop, at, PROP_NAME);
            this.source = HeapGenerator.readMember(iop, at, PROP_SOURCE);
            this.line = HeapGenerator.asIntOrNull(iop, at, PROP_LINE);
            this.column = HeapGenerator.asIntOrNull(iop, at, PROP_COLUMN);
            this.charIndex = HeapGenerator.asIntOrNull(iop, at, PROP_CHAR_INDEX);
            this.charLength = HeapGenerator.asIntOrNull(iop, at, PROP_CHAR_LENGTH);
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return MEMBERS;
        }

        @ExportMessage
        boolean isMemberReadable(String member) {
            switch (member) {
                case "name": {
                    return this.name != null;
                }
                case "source": {
                    return true;
                }
                case "line": {
                    return this.line != null;
                }
                case "column": {
                    return this.column != null;
                }
                case "charIndex": {
                    return this.charIndex != null;
                }
                case "charLength": {
                    return this.charLength != null;
                }
            }
            return false;
        }

        @ExportMessage
        Object readMember(String member) throws UnknownIdentifierException {
            switch (member) {
                case "name": {
                    if (this.name == null) break;
                    return this.name;
                }
                case "source": {
                    return this.source;
                }
                case "line": {
                    if (this.line == null) break;
                    return this.line;
                }
                case "column": {
                    if (this.column == null) break;
                    return this.column;
                }
                case "charIndex": {
                    if (this.charIndex == null) break;
                    return this.charIndex;
                }
                case "charLength": {
                    if (this.charLength == null) break;
                    return this.charLength;
                }
            }
            throw UnknownIdentifierException.create((String)member);
        }
    }
}

