/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.insight.heap.instrument;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.graalvm.tools.insight.heap.instrument.HeapException;

final class InteropUtils {
    private static final InteropLibrary iop = InteropLibrary.getUncached();

    private InteropUtils() {
    }

    static Object readArrayElement(Object array, int index, String name) {
        try {
            return iop.readArrayElement(array, (long)index);
        }
        catch (UnsupportedMessageException ex) {
            throw new HeapException("Reading of " + name + " elements must be supported");
        }
        catch (InvalidArrayIndexException ex) {
            throw new HeapException("No " + name + " at index " + index);
        }
    }
}

