/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.insight.heap.instrument;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.graalvm.tools.insight.heap.HeapDump;
import org.graalvm.tools.insight.heap.instrument.HeapException;

final class HeapGenerator {
    private final HeapDump.Builder generator;
    private final Map<TreeSet<String>, HeapDump.ClassInstance> classes = new HashMap<TreeSet<String>, HeapDump.ClassInstance>();
    private final Map<String, HeapDump.ClassInstance> languages = new HashMap<String, HeapDump.ClassInstance>();
    private final Map<Object, HeapDump.ObjectInstance> objects = new IdentityHashMap<Object, HeapDump.ObjectInstance>();
    private final Map<SourceKey, HeapDump.ObjectInstance> sources = new HashMap<SourceKey, HeapDump.ObjectInstance>();
    private final Map<SourceSectionKey, HeapDump.ObjectInstance> sourceSections = new HashMap<SourceSectionKey, HeapDump.ObjectInstance>();
    private final LinkedList<Dump> pending = new LinkedList();
    private HeapDump.ClassInstance sourceSectionClass;
    private HeapDump.ObjectInstance unreachable;
    private int frames;
    private HeapDump.ClassInstance keyClass;
    private HeapDump.ClassInstance sourceClass;

    HeapGenerator(HeapDump.Builder generator) {
        this.generator = generator;
    }

    void dump(Object[] args) throws UnsupportedTypeException, UnsupportedMessageException {
        DumpData dumpData = HeapGenerator.getDumpData(args);
        InteropLibrary iop = InteropLibrary.getUncached();
        try {
            Object events = dumpData.getEvents();
            int defaultDepth = dumpData.getDepth();
            long eventCount = iop.getArraySize(events);
            this.generator.dumpHeap(data -> {
                try {
                    for (long i = 0L; i < eventCount; ++i) {
                        int depth;
                        Object ithEvent = iop.readArrayElement(events, i);
                        Object stack = HeapGenerator.readMember(iop, ithEvent, "stack");
                        Integer ithDepthOrNull = HeapGenerator.asIntOrNull(iop, ithEvent, "depth");
                        int n = depth = ithDepthOrNull != null ? ithDepthOrNull : defaultDepth;
                        if (!iop.hasArrayElements(stack)) {
                            throw new HeapException("'stack' shall be an array");
                        }
                        this.dumpStack((HeapDump)data, iop, stack, depth);
                    }
                    while (!this.pending.isEmpty()) {
                        Dump d = this.pending.removeFirst();
                        d.dump();
                    }
                }
                catch (InteropException | IOException ex) {
                    throw new HeapException(ex);
                }
            });
        }
        catch (IOException ex) {
            throw new HeapException(ex);
        }
    }

    private static Object checkDumpParameter(Object[] args, InteropLibrary iop) throws UnsupportedTypeException {
        String errMessage = "Use as dump({ format: '', events: []})";
        if (args.length != 1) {
            throw UnsupportedTypeException.create((Object[])args, (String)"Use as dump({ format: '', events: []})", (Throwable)((Object)new HeapException("Use as dump({ format: '', events: []})")));
        }
        Object dump = args[0];
        if (iop.isExecutable(dump)) {
            throw UnsupportedTypeException.create((Object[])args, (String)"Use as dump({ format: '', events: []})", (Throwable)((Object)new HeapException("Use as dump({ format: '', events: []})")));
        }
        return dump;
    }

    static DumpData getDumpData(Object[] args) throws UnsupportedTypeException, UnsupportedMessageException {
        InteropLibrary iop = InteropLibrary.getUncached();
        Object dump = HeapGenerator.checkDumpParameter(args, iop);
        String errMessage = "Use as dump({ format: '1.0', events: []})";
        Object format = HeapGenerator.readMember(iop, dump, "format");
        if (!iop.isString(format) || !"1.0".equals(iop.asString(format))) {
            throw UnsupportedTypeException.create((Object[])args, (String)"Use as dump({ format: '1.0', events: []})", (Throwable)((Object)new HeapException("Use as dump({ format: '1.0', events: []})")));
        }
        Object events = HeapGenerator.readMember(iop, dump, "events");
        if (!iop.hasArrayElements(events)) {
            throw UnsupportedTypeException.create((Object[])args, (String)"Use as dump({ format: '1.0', events: []})", (Throwable)((Object)new HeapException("Use as dump({ format: '1.0', events: []})")));
        }
        Integer depthOrNull = HeapGenerator.asIntOrNull(iop, dump, "depth");
        int defaultDepth = depthOrNull != null ? depthOrNull : Integer.MAX_VALUE;
        return new DumpData(format, events, defaultDepth);
    }

    static String asStringOrNull(InteropLibrary iop, Object from, String key) {
        Object value;
        if (key != null) {
            try {
                value = iop.readMember(from, key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                return null;
            }
        } else {
            value = from;
        }
        if (iop.isString(value)) {
            try {
                return iop.asString(value);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
        return null;
    }

    static Integer asIntOrNull(InteropLibrary iop, Object from, String key) {
        Object value;
        if (key != null) {
            try {
                value = iop.readMember(from, key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                return null;
            }
        } else {
            value = from;
        }
        if (iop.fitsInInt(value)) {
            try {
                return iop.asInt(value);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
        return null;
    }

    static Object readMember(InteropLibrary iop, Object obj, String member) {
        return HeapGenerator.readMember(iop, obj, member, id -> id);
    }

    private static <T> T readMember(InteropLibrary iop, Object obj, String member, Convert<T> convert) {
        String errMsg;
        try {
            Object value = iop.readMember(obj, member);
            if (!iop.isNull(value)) {
                return convert.convert(value);
            }
            errMsg = "'" + member + "' should be defined";
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
            errMsg = "Cannot find '" + member + "'";
        }
        StringBuilder sb = new StringBuilder(errMsg);
        try {
            Object members = iop.getMembers(obj);
            long count = iop.getArraySize(members);
            sb.append(" among [");
            String sep = "";
            for (long i = 0L; i < count; ++i) {
                sb.append(sep);
                try {
                    sb.append(iop.readArrayElement(members, i));
                }
                catch (InvalidArrayIndexException invalidArrayIndexException) {
                    // empty catch block
                }
                sep = ", ";
            }
            sb.append("]");
        }
        catch (UnsupportedMessageException cannotDumpMembers) {
            sb.append(" in ").append(iop.toDisplayString(obj));
        }
        throw new HeapException(sb.toString());
    }

    private void dumpStack(HeapDump seg, InteropLibrary iop, Object stack, int depth) throws IOException, UnsupportedMessageException, InvalidArrayIndexException {
        HeapDump.ThreadBuilder threadBuilder = null;
        long frameCount = iop.getArraySize(stack);
        for (long i = 0L; i < frameCount; ++i) {
            Object stackTraceElement = iop.readArrayElement(stack, i);
            Object at = HeapGenerator.readMember(iop, stackTraceElement, "at");
            Object frame = HeapGenerator.readMember(iop, stackTraceElement, "frame");
            String rootName = HeapGenerator.asStringOrNull(iop, at, "name");
            Object source = HeapGenerator.readMember(iop, at, "source");
            HeapDump.ClassInstance language = this.findLanguage(seg, HeapGenerator.asStringOrNull(iop, source, "language"));
            String srcName = HeapGenerator.asStringOrNull(iop, source, "name");
            Integer line = HeapGenerator.asIntOrNull(iop, at, "line");
            Integer charIndex = HeapGenerator.asIntOrNull(iop, at, "charIndex");
            Integer charLength = HeapGenerator.asIntOrNull(iop, at, "charLength");
            if (this.unreachable == null) {
                HeapDump.ClassInstance unreachClass = seg.newClass("unreachable").field("<unreachable>", Boolean.TYPE).dumpClass();
                this.unreachable = seg.newInstance(unreachClass).putBoolean("<unreachable>", true).dumpInstance();
            }
            if (threadBuilder == null) {
                threadBuilder = seg.newThread(rootName + "#" + ++this.frames);
            }
            HeapDump.ObjectInstance sourceId = this.dumpSource(iop, seg, source);
            HeapDump.ObjectInstance sectionId = this.dumpSourceSection(seg, sourceId, charIndex, charLength);
            HeapDump.ObjectInstance localFrame = this.dumpObject(iop, seg, "frame:" + rootName, frame, depth + 1);
            threadBuilder.addStackFrame(language, rootName, srcName, line == null ? -1 : line, localFrame, sectionId);
        }
        if (threadBuilder != null) {
            threadBuilder.dumpThread();
        }
    }

    private HeapDump.ClassInstance findLanguage(HeapDump seg, String language) {
        HeapDump.ClassInstance l = this.languages.get(language);
        if (l == null) {
            l = seg.newClass("lang:" + language).dumpClass();
            this.languages.put(language, l);
        }
        return l;
    }

    private HeapDump.ObjectInstance dumpObject(InteropLibrary iop, HeapDump seg, String metaName, Object obj, int depth) throws IOException {
        HeapDump.ObjectInstance id = this.objects.get(obj);
        if (id != null) {
            return id;
        }
        if (iop.isString(obj)) {
            try {
                return seg.dumpString(iop.asString(obj));
            }
            catch (UnsupportedMessageException ex) {
                throw new HeapException(ex);
            }
        }
        if (!(obj instanceof TruffleObject)) {
            return seg.dumpPrimitive(obj);
        }
        if (depth <= 0) {
            return this.unreachable;
        }
        HeapDump.ClassInstance clazz = this.findClass(iop, seg, metaName, obj);
        if (clazz == null) {
            return this.unreachable;
        }
        int len = HeapGenerator.findArrayLength(iop, obj);
        if (len >= 0) {
            HeapDump.ArrayBuilder builder = seg.newArray(len);
            this.objects.put(obj, builder.id());
            this.pending.add(() -> {
                for (int i = 0; i < len; ++i) {
                    Object v = iop.readArrayElement(obj, (long)i);
                    HeapDump.ObjectInstance vId = this.dumpObject(iop, seg, null, v, depth - 1);
                    builder.put(i, vId);
                }
                builder.dumpInstance();
            });
            return builder.id();
        }
        HeapDump.InstanceBuilder builder = seg.newInstance(clazz);
        this.objects.put(obj, builder.id());
        this.pending.add(() -> {
            for (String n : clazz.names()) {
                Object v = iop.readMember(obj, n);
                HeapDump.ObjectInstance vId = this.dumpObject(iop, seg, null, v, depth - 1);
                builder.put(n, vId);
            }
            builder.dumpInstance();
        });
        return builder.id();
    }

    private static int findArrayLength(InteropLibrary iop, Object obj) {
        if (!iop.hasArrayElements(obj)) {
            return -1;
        }
        try {
            long len = iop.getArraySize(obj);
            if (len > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)len;
        }
        catch (UnsupportedMessageException ex) {
            return -1;
        }
    }

    HeapDump.ClassInstance findClass(InteropLibrary iop, HeapDump seg, String metaHint, Object obj) throws IOException {
        TreeSet<String> sortedNames = new TreeSet<String>();
        try {
            Object names = iop.getMembers(obj, true);
            long len = iop.getArraySize(names);
            for (long i = 0L; i < len; ++i) {
                String ithName = iop.asString(iop.readArrayElement(names, i));
                if (!iop.isMemberReadable(obj, ithName) || iop.hasMemberReadSideEffects(obj, ithName)) continue;
                sortedNames.add(ithName);
            }
        }
        catch (UnsupportedMessageException names) {
        }
        catch (InteropException ex) {
            throw new IOException("Object " + String.valueOf(obj), ex);
        }
        HeapDump.ClassInstance clazz = this.classes.get(sortedNames);
        if (clazz == null) {
            String metaName = metaHint;
            if (metaName == null) {
                try {
                    Object meta = iop.getMetaObject(obj);
                    metaName = HeapGenerator.asStringOrNull(iop, iop.getMetaQualifiedName(meta), null);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    metaName = "Frame";
                }
            }
            if ("unreachable".equals(metaName) && sortedNames.size() == 1 && "<unreachable>".equals(sortedNames.iterator().next())) {
                return null;
            }
            HeapDump.ClassBuilder builder = seg.newClass(metaName);
            for (String n : sortedNames) {
                builder.field(n, Object.class);
            }
            clazz = builder.dumpClass();
            this.classes.put(sortedNames, clazz);
        }
        return clazz;
    }

    private HeapDump.ObjectInstance dumpSourceSection(HeapDump seg, HeapDump.ObjectInstance sourceId, Integer charIndex, Integer charLength) throws IOException {
        int length;
        int index;
        SourceSectionKey key;
        HeapDump.ObjectInstance id;
        if (this.sourceSectionClass == null) {
            this.sourceSectionClass = seg.newClass("com.oracle.truffle.api.source.SourceSection").field("source", Object.class).field("charIndex", Integer.TYPE).field("charLength", Integer.TYPE).dumpClass();
        }
        if ((id = this.sourceSections.get(key = new SourceSectionKey(sourceId, index = charIndex == null ? -1 : charIndex, length = charLength == null ? -1 : charLength))) == null) {
            id = seg.newInstance(this.sourceSectionClass).put("source", sourceId).putInt("charIndex", index).putInt("charLength", length).dumpInstance();
            this.sourceSections.put(key, id);
        }
        return id;
    }

    private HeapDump.ObjectInstance dumpSource(InteropLibrary iop, HeapDump seg, Object source) throws IOException, UnsupportedMessageException {
        String characters;
        String srcName = HeapGenerator.readMember(iop, source, "name", arg_0 -> ((InteropLibrary)iop).asString(arg_0));
        String mimeType = HeapGenerator.asStringOrNull(iop, source, "mimeType");
        String uri = HeapGenerator.asStringOrNull(iop, source, "uri");
        SourceKey key = new SourceKey(srcName, uri, mimeType, characters = HeapGenerator.asStringOrNull(iop, source, "characters"));
        HeapDump.ObjectInstance prevId = this.sources.get(key);
        if (prevId != null) {
            return prevId;
        }
        if (this.sourceClass == null) {
            this.keyClass = seg.newClass("com.oracle.truffle.api.source.SourceImpl$Key").field("uri", String.class).field("content", String.class).field("mimeType", String.class).field("name", String.class).dumpClass();
            this.sourceClass = seg.newClass("com.oracle.truffle.api.source.Source").field("key", Object.class).dumpClass();
        }
        HeapDump.ObjectInstance keyId = seg.newInstance(this.keyClass).put("uri", seg.dumpString(uri)).put("mimeType", seg.dumpString(mimeType)).put("content", seg.dumpString(characters)).put("name", seg.dumpString(srcName)).dumpInstance();
        HeapDump.ObjectInstance srcId = seg.newInstance(this.sourceClass).put("key", keyId).dumpInstance();
        this.sources.put(key, srcId);
        return srcId;
    }

    static final class DumpData {
        private final Object format;
        private final Object events;
        private final int depth;

        DumpData(Object format, Object events, int depth) {
            this.format = format;
            this.events = events;
            this.depth = depth;
        }

        Object getFormat() {
            return this.format;
        }

        Object getEvents() {
            return this.events;
        }

        int getDepth() {
            return this.depth;
        }
    }

    private static interface Convert<T> {
        public T convert(Object var1) throws UnsupportedTypeException, UnsupportedMessageException;
    }

    private static interface Dump {
        public void dump() throws UnknownIdentifierException, IOException, UnsupportedMessageException, InvalidArrayIndexException;
    }

    private static final class SourceSectionKey {
        private final HeapDump.ObjectInstance sourceId;
        private final int charIndex;
        private final int charLength;

        private SourceSectionKey(HeapDump.ObjectInstance sourceId, int charIndex, int charLength) {
            this.sourceId = sourceId;
            this.charIndex = charIndex;
            this.charLength = charLength;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.sourceId);
            hash = 41 * hash + this.charIndex;
            hash = 41 * hash + this.charLength;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceSectionKey other = (SourceSectionKey)obj;
            if (this.charIndex != other.charIndex) {
                return false;
            }
            if (this.charLength != other.charLength) {
                return false;
            }
            return Objects.equals(this.sourceId, other.sourceId);
        }
    }

    private static final class SourceKey {
        private final String srcName;
        private final String uri;
        private final String mimeType;
        private final String characters;

        SourceKey(String srcName, String uri, String mimeType, String characters) {
            this.srcName = srcName;
            this.uri = uri;
            this.mimeType = mimeType;
            this.characters = characters;
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + Objects.hashCode(this.srcName);
            hash = 79 * hash + Objects.hashCode(this.uri);
            hash = 79 * hash + Objects.hashCode(this.mimeType);
            hash = 79 * hash + Objects.hashCode(this.characters);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceKey other = (SourceKey)obj;
            if (!Objects.equals(this.srcName, other.srcName)) {
                return false;
            }
            if (!Objects.equals(this.uri, other.uri)) {
                return false;
            }
            if (!Objects.equals(this.mimeType, other.mimeType)) {
                return false;
            }
            return Objects.equals(this.characters, other.characters);
        }
    }
}

