/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sandbox.enterprise;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.sandbox.enterprise.e;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(value=e.class)
final class f
implements TruffleOptionDescriptors {
    f() {
    }

    public OptionDescriptor get(String string) {
        switch (string) {
            case "sandbox.AllocatedBytesCheckEnabled": {
                return OptionDescriptor.newBuilder(e.v, (String)"sandbox.AllocatedBytesCheckEnabled").deprecated(false).help("Specifies whether checking of allocated bytes for an execution context is enabled. Is set to 'true' by default.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "sandbox.AllocatedBytesCheckFactor": {
                return OptionDescriptor.newBuilder(e.w, (String)"sandbox.AllocatedBytesCheckFactor").deprecated(false).help("Specifies a factor of MaxHeapMemory the allocation of which triggers retained heap memory computation. When allocated bytes for an execution context reach the specified factor, computation of bytes retained in the heap by the context is initiated. Is set to '1.0' by default.").usageSyntax("[0.0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "sandbox.AllocatedBytesCheckInterval": {
                return OptionDescriptor.newBuilder(e.u, (String)"sandbox.AllocatedBytesCheckInterval").deprecated(false).help("Time interval to check allocated bytes for an execution context. Exceeding certain number of allocated bytes triggers computation of bytes retained in the heap by the context. Is set to '10ms' by default. Maximum interval is 1h.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxASTDepth": {
                return OptionDescriptor.newBuilder(e.H, (String)"sandbox.MaxASTDepth").deprecated(false).help("Maximum AST depth of a function (default: no limit).").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxCPUTime": {
                return OptionDescriptor.newBuilder(e.B, (String)"sandbox.MaxCPUTime").deprecated(false).help("Limits the total maximum CPU time that was spent running the application. No limit is set by default. Example value: '100ms'.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxCPUTimeCheckInterval": {
                return OptionDescriptor.newBuilder(e.C, (String)"sandbox.MaxCPUTimeCheckInterval").deprecated(false).help("Time interval to check the active CPU time for an execution context. Is set to '10ms' by default. Maximum interval is 1h.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxErrorStreamSize": {
                return OptionDescriptor.newBuilder(e.K, (String)"sandbox.MaxErrorStreamSize").deprecated(false).help("Specifies the maximum size that the guest application can write to stderr. No limit is set by default. Example value: '10MB'.").usageSyntax("[0, inf)B|KB|MB|GB").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxHeapMemory": {
                return OptionDescriptor.newBuilder(e.t, (String)"sandbox.MaxHeapMemory").deprecated(false).help("Specifies the maximum heap memory that can be retained by the application during its run. Includes only data retained by the guest application, runtime allocated data is not included. No limit is set by default and setting the related expert options has no effect. Example value: '100MB'.").usageSyntax("[1, inf)B|KB|MB|GB").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxOutputStreamSize": {
                return OptionDescriptor.newBuilder(e.J, (String)"sandbox.MaxOutputStreamSize").deprecated(false).help("Specifies the maximum size that the guest application can write to stdout. No limit is set by default. Example value: '10MB'.").usageSyntax("[0, inf)B|KB|MB|GB").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxStackFrames": {
                return OptionDescriptor.newBuilder(e.F, (String)"sandbox.MaxStackFrames").deprecated(false).help("Limits the maximum number of guest stack frames (default: no limit).").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxStatements": {
                return OptionDescriptor.newBuilder(e.D, (String)"sandbox.MaxStatements").deprecated(false).help("Limits the maximum number of guest language statements executed. The execution is cancelled with an resource exhausted error when it is exceeded.").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxStatementsIncludeInternal": {
                return OptionDescriptor.newBuilder(e.E, (String)"sandbox.MaxStatementsIncludeInternal").deprecated(false).help("Configures whether to include internal sources in the max statements computation.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "sandbox.MaxThreads": {
                return OptionDescriptor.newBuilder(e.G, (String)"sandbox.MaxThreads").deprecated(false).help("Limits the number of threads that can be entered by a context at the same point in time (default: no limit).").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.RetainedBytesCheckFactor": {
                return OptionDescriptor.newBuilder(e.y, (String)"sandbox.RetainedBytesCheckFactor").deprecated(false).help("Specifies a factor of total heap memory of the host VM the exceeding of which stops the world. When the total number of bytes allocated in the heap for the whole host VM exceeds the factor, the following process is initiated. Execution for all engines with at least one memory-limited execution context is paused. Retained bytes in the heap for each memory-limited context are computed. Contexts exceeding their limits are cancelled. The execution is resumed. Is set to '0.7' by default. Has no effect if 'UseLowMemoryTrigger' is 'false'.").usageSyntax("[0.0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "sandbox.RetainedBytesCheckInterval": {
                return OptionDescriptor.newBuilder(e.x, (String)"sandbox.RetainedBytesCheckInterval").deprecated(false).help("Specifies the minimum time interval between two computations of retained bytes in the heap for a single execution context. Is set to '10ms' by default. Maximum value for the minimum interval is 1h.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "sandbox.ReuseLowMemoryTriggerThreshold": {
                return OptionDescriptor.newBuilder(e.A, (String)"sandbox.ReuseLowMemoryTriggerThreshold").deprecated(false).help("Specifies whether an already set heap memory notification limit can be reused for the low memory trigger. When reusing is allowed and the usage threshold or the collection usage threshold of a heap memory pool has already been set, then the value of 'RetainedBytesCheckFactor' is ignored for that memory pool and threshold type and whatever threshold value has already been set is used. Is set to 'false' by default.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "sandbox.TraceLimits": {
                return OptionDescriptor.newBuilder(e.I, (String)"sandbox.TraceLimits").deprecated(false).help("Records the maximum amount of resources used during execution, and reports a summary of resource limits to the log file upon application exit. Users may also provide limits to enforce while tracing. This flag can be used to estimate an application's optimal sandbox parameters, either by tracing the limits of a stress test or peak usage.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "sandbox.UseLowMemoryTrigger": {
                return OptionDescriptor.newBuilder(e.z, (String)"sandbox.UseLowMemoryTrigger").deprecated(false).help("Specifies whether stopping the world is enabled. When enabled, engines with at least one memory limited execution context are paused when the total number of bytes allocated in the heap for the whole host VM exceeds the specified factor of total heap memory of the host VM. Is set to 'true' by default.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
        }
        return null;
    }

    public SandboxPolicy getSandboxPolicy(String string) {
        assert (this.get(string) != null) : "Unknown option " + string;
        switch (string) {
            case "sandbox.AllocatedBytesCheckEnabled": {
                return SandboxPolicy.CONSTRAINED;
            }
            case "sandbox.RetainedBytesCheckFactor": {
                return SandboxPolicy.CONSTRAINED;
            }
            case "sandbox.UseLowMemoryTrigger": {
                return SandboxPolicy.CONSTRAINED;
            }
            case "sandbox.ReuseLowMemoryTriggerThreshold": {
                return SandboxPolicy.TRUSTED;
            }
            case "sandbox.TraceLimits": {
                return SandboxPolicy.ISOLATED;
            }
        }
        return SandboxPolicy.UNTRUSTED;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(e.v, (String)"sandbox.AllocatedBytesCheckEnabled").deprecated(false).help("Specifies whether checking of allocated bytes for an execution context is enabled. Is set to 'true' by default.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(e.w, (String)"sandbox.AllocatedBytesCheckFactor").deprecated(false).help("Specifies a factor of MaxHeapMemory the allocation of which triggers retained heap memory computation. When allocated bytes for an execution context reach the specified factor, computation of bytes retained in the heap by the context is initiated. Is set to '1.0' by default.").usageSyntax("[0.0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(e.u, (String)"sandbox.AllocatedBytesCheckInterval").deprecated(false).help("Time interval to check allocated bytes for an execution context. Exceeding certain number of allocated bytes triggers computation of bytes retained in the heap by the context. Is set to '10ms' by default. Maximum interval is 1h.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.H, (String)"sandbox.MaxASTDepth").deprecated(false).help("Maximum AST depth of a function (default: no limit).").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.B, (String)"sandbox.MaxCPUTime").deprecated(false).help("Limits the total maximum CPU time that was spent running the application. No limit is set by default. Example value: '100ms'.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.C, (String)"sandbox.MaxCPUTimeCheckInterval").deprecated(false).help("Time interval to check the active CPU time for an execution context. Is set to '10ms' by default. Maximum interval is 1h.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.K, (String)"sandbox.MaxErrorStreamSize").deprecated(false).help("Specifies the maximum size that the guest application can write to stderr. No limit is set by default. Example value: '10MB'.").usageSyntax("[0, inf)B|KB|MB|GB").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.t, (String)"sandbox.MaxHeapMemory").deprecated(false).help("Specifies the maximum heap memory that can be retained by the application during its run. Includes only data retained by the guest application, runtime allocated data is not included. No limit is set by default and setting the related expert options has no effect. Example value: '100MB'.").usageSyntax("[1, inf)B|KB|MB|GB").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.J, (String)"sandbox.MaxOutputStreamSize").deprecated(false).help("Specifies the maximum size that the guest application can write to stdout. No limit is set by default. Example value: '10MB'.").usageSyntax("[0, inf)B|KB|MB|GB").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.F, (String)"sandbox.MaxStackFrames").deprecated(false).help("Limits the maximum number of guest stack frames (default: no limit).").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.D, (String)"sandbox.MaxStatements").deprecated(false).help("Limits the maximum number of guest language statements executed. The execution is cancelled with an resource exhausted error when it is exceeded.").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.E, (String)"sandbox.MaxStatementsIncludeInternal").deprecated(false).help("Configures whether to include internal sources in the max statements computation.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.G, (String)"sandbox.MaxThreads").deprecated(false).help("Limits the number of threads that can be entered by a context at the same point in time (default: no limit).").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.y, (String)"sandbox.RetainedBytesCheckFactor").deprecated(false).help("Specifies a factor of total heap memory of the host VM the exceeding of which stops the world. When the total number of bytes allocated in the heap for the whole host VM exceeds the factor, the following process is initiated. Execution for all engines with at least one memory-limited execution context is paused. Retained bytes in the heap for each memory-limited context are computed. Contexts exceeding their limits are cancelled. The execution is resumed. Is set to '0.7' by default. Has no effect if 'UseLowMemoryTrigger' is 'false'.").usageSyntax("[0.0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(e.x, (String)"sandbox.RetainedBytesCheckInterval").deprecated(false).help("Specifies the minimum time interval between two computations of retained bytes in the heap for a single execution context. Is set to '10ms' by default. Maximum value for the minimum interval is 1h.").usageSyntax("[1, inf)ms|s|m|h|d").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.A, (String)"sandbox.ReuseLowMemoryTriggerThreshold").deprecated(false).help("Specifies whether an already set heap memory notification limit can be reused for the low memory trigger. When reusing is allowed and the usage threshold or the collection usage threshold of a heap memory pool has already been set, then the value of 'RetainedBytesCheckFactor' is ignored for that memory pool and threshold type and whatever threshold value has already been set is used. Is set to 'false' by default.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(e.I, (String)"sandbox.TraceLimits").deprecated(false).help("Records the maximum amount of resources used during execution, and reports a summary of resource limits to the log file upon application exit. Users may also provide limits to enforce while tracing. This flag can be used to estimate an application's optimal sandbox parameters, either by tracing the limits of a stress test or peak usage.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(e.z, (String)"sandbox.UseLowMemoryTrigger").deprecated(false).help("Specifies whether stopping the world is enabled. When enabled, engines with at least one memory limited execution context are paused when the total number of bytes allocated in the heap for the whole host VM exceeds the specified factor of total heap memory of the host VM. Is set to 'true' by default.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build()).iterator();
    }
}

