/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory;
import com.oracle.truffle.nfi.NFIClosure;
import com.oracle.truffle.nfi.NFISignature;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=NFIClosure.class)
final class NFIClosureGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private NFIClosureGen() {
    }

    static {
        LibraryExport.register(NFIClosure.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=NFIClosure.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NFIClosure.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFIClosure);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NFIClosure);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFIClosure.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFIClosure) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIClosure;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                if (arg0Value.signature.cachedState != null) {
                    return NFIClosure.Execute.doOptimizedIndirect(arg0Value, arg1Value, IndirectCallNode.getUncached());
                }
                if (arg0Value.signature.cachedState == null) {
                    return NFIClosure.Execute.doSlowPath(arg0Value, arg1Value, BranchProfile.getUncached(), ConvertTypeNodeFactory.ConvertFromNativeNodeGen.getUncached(), ConvertTypeNodeFactory.ConvertToNativeNodeGen.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.executable));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                return arg0Value.isExecutable((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.executable));
            }
        }

        @GeneratedBy(value=NFIClosure.class)
        private static final class Cached
        extends InteropLibrary {
            static final InlineSupport.ReferenceField<ExecuteOptimizedDirectData> EXECUTE_OPTIMIZED_DIRECT_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"execute_optimizedDirect_cache", ExecuteOptimizedDirectData.class);
            @Node.Child
            private InteropLibrary receiverExecutableInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private ExecuteOptimizedDirectData execute_optimizedDirect_cache;
            @Node.Child
            private IndirectCallNode execute_optimizedIndirect_call_;
            @Node.Child
            private ExecuteSlowPathData execute_slowPath_cache;

            protected Cached(Object receiver) {
                NFIClosure castReceiver = (NFIClosure)receiver;
                this.receiverExecutableInteropLibrary_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(castReceiver.executable)));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFIClosure) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFIClosure)) {
                    return false;
                }
                return this.receiverExecutableInteropLibrary_.accepts(((NFIClosure)receiver).executable);
            }

            @ExplodeLoop
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (arg0Value_ instanceof NFIClosure) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    ExecuteSlowPathData s2_;
                    IndirectCallNode call__;
                    if ((state_0 & 1) != 0 && arg0Value.signature.cachedState != null) {
                        ExecuteOptimizedDirectData s0_ = this.execute_optimizedDirect_cache;
                        while (s0_ != null) {
                            if (arg0Value.signature.cachedState == s0_.cachedState_) {
                                return NFIClosure.Execute.doOptimizedDirect(arg0Value, arg1Value, s0_.cachedState_, s0_.call_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && (call__ = this.execute_optimizedIndirect_call_) != null && arg0Value.signature.cachedState != null) {
                        return NFIClosure.Execute.doOptimizedIndirect(arg0Value, arg1Value, call__);
                    }
                    if ((state_0 & 4) != 0 && (s2_ = this.execute_slowPath_cache) != null && arg0Value.signature.cachedState == null) {
                        InteropLibrary interop__ = this.receiverExecutableInteropLibrary_;
                        return NFIClosure.Execute.doSlowPath(arg0Value, arg1Value, s2_.exception_, s2_.convertArg_, s2_.convertRet_, interop__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIClosure arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value.signature.cachedState != null) {
                    ExecuteOptimizedDirectData s0_;
                    block6: {
                        ExecuteOptimizedDirectData s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = (ExecuteOptimizedDirectData)((Object)EXECUTE_OPTIMIZED_DIRECT_CACHE_UPDATER.getVolatile((Node)this));
                            while (s0_ != null && arg0Value.signature.cachedState != s0_.cachedState_) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || count0_ >= 3) break block6;
                            s0_ = (ExecuteOptimizedDirectData)this.insert(new ExecuteOptimizedDirectData(s0_original));
                            s0_.cachedState_ = arg0Value.signature.cachedState;
                            s0_.call_ = (CallSignatureNode)s0_.insert(s0_.cachedState_.createOptimizedClosureCall());
                        } while (!EXECUTE_OPTIMIZED_DIRECT_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        return NFIClosure.Execute.doOptimizedDirect(arg0Value, arg1Value, s0_.cachedState_, s0_.call_);
                    }
                }
                if (arg0Value.signature.cachedState != null) {
                    VarHandle.storeStoreFence();
                    this.execute_optimizedIndirect_call_ = (IndirectCallNode)this.insert((Node)IndirectCallNode.create());
                    this.execute_optimizedDirect_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    return NFIClosure.Execute.doOptimizedIndirect(arg0Value, arg1Value, this.execute_optimizedIndirect_call_);
                }
                InteropLibrary interop__ = null;
                if (arg0Value.signature.cachedState == null) {
                    ExecuteSlowPathData s2_ = (ExecuteSlowPathData)this.insert(new ExecuteSlowPathData());
                    BranchProfile exception__ = BranchProfile.create();
                    Objects.requireNonNull(exception__, "Specialization 'doSlowPath(NFIClosure, Object[], BranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s2_.exception_ = exception__;
                    ConvertTypeNode.ConvertFromNativeNode convertArg__ = (ConvertTypeNode.ConvertFromNativeNode)s2_.insert(ConvertTypeNodeFactory.ConvertFromNativeNodeGen.create());
                    Objects.requireNonNull(convertArg__, "Specialization 'doSlowPath(NFIClosure, Object[], BranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary)' cache 'convertArg' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s2_.convertArg_ = convertArg__;
                    ConvertTypeNode.ConvertToNativeNode convertRet__ = (ConvertTypeNode.ConvertToNativeNode)s2_.insert(ConvertTypeNodeFactory.ConvertToNativeNodeGen.create());
                    Objects.requireNonNull(convertRet__, "Specialization 'doSlowPath(NFIClosure, Object[], BranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary)' cache 'convertRet' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s2_.convertRet_ = convertRet__;
                    interop__ = this.receiverExecutableInteropLibrary_;
                    VarHandle.storeStoreFence();
                    this.execute_slowPath_cache = s2_;
                    this.state_0_ = state_0 |= 4;
                    return NFIClosure.Execute.doSlowPath(arg0Value, arg1Value, exception__, convertArg__, convertRet__, interop__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                ExecuteOptimizedDirectData s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.execute_optimizedDirect_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (arg0Value_ instanceof NFIClosure) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                InteropLibrary interop__ = this.receiverExecutableInteropLibrary_;
                return arg0Value.isExecutable(interop__);
            }

            @GeneratedBy(value=NFIClosure.class)
            @DenyReplace
            private static final class ExecuteOptimizedDirectData
            extends Node {
                @Node.Child
                ExecuteOptimizedDirectData next_;
                @CompilerDirectives.CompilationFinal
                NFISignature.SignatureCachedState cachedState_;
                @Node.Child
                CallSignatureNode call_;

                ExecuteOptimizedDirectData(ExecuteOptimizedDirectData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }

            @GeneratedBy(value=NFIClosure.class)
            @DenyReplace
            private static final class ExecuteSlowPathData
            extends Node {
                @CompilerDirectives.CompilationFinal
                BranchProfile exception_;
                @Node.Child
                ConvertTypeNode.ConvertFromNativeNode convertArg_;
                @Node.Child
                ConvertTypeNode.ConvertToNativeNode convertRet_;

                ExecuteSlowPathData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }
}

