/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodes;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringFactory;
import java.lang.invoke.MethodHandles;

@GeneratedBy(value=TruffleStringBuilder.class)
public final class TruffleStringBuilderFactory {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString.CompactionLevel[] COMPACTION_LEVEL_VALUES = (TruffleString.CompactionLevel[])DSLSupport.lookupEnumConstants(TruffleString.CompactionLevel.class);

    private static TruffleString.CompactionLevel decodeCompactionLevel(int state) {
        if (state >= 0) {
            return COMPACTION_LEVEL_VALUES[state];
        }
        return null;
    }

    private static int encodeCompactionLevel(TruffleString.CompactionLevel e) {
        if (e != null) {
            return e.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendArrayIntlNode.class)
    static final class AppendArrayIntlNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        AppendArrayIntlNodeGen() {
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendArrayIntlNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendArrayIntlNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendArrayIntlNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendArrayIntlNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                TruffleStringBuilder.AppendArrayIntlNode.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendArrayIntlNode.class)
        @DenyReplace
        private static final class Inlined
        extends TruffleStringBuilder.AppendArrayIntlNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<CachedData> cached_cache;
            private final InlinedConditionProfile bufferGrow;
            private final InlinedBranchProfile error;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TruffleStringBuilder.AppendArrayIntlNode.class));
                this.state_0_ = target.getState(0, 5);
                this.cached_cache = target.getReference(1, CachedData.class);
                this.bufferGrow = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(2, 2)));
                this.error = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(4, 1)));
            }

            @Override
            @ExplodeLoop
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0) {
                        CachedData s0_ = this.cached_cache.get(arg0Value);
                        while (s0_ != null) {
                            if (arg1Value.stride == s0_.cachedStrideSB_ && arg5Value == s0_.cachedStrideA_ && arg6Value == s0_.cachedStrideNew_) {
                                TruffleStringBuilder.AppendArrayIntlNode.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideSB_, s0_.cachedStrideA_, s0_.cachedStrideNew_, this.bufferGrow, this.error);
                                return;
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        TruffleStringBuilder.AppendArrayIntlNode.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.bufferGrow, this.error);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private void executeAndSpecialize(Node arg0Value, TruffleStringBuilder arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 2) == 0) {
                    CachedData s0_;
                    block4: {
                        CachedData s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = this.cached_cache.getVolatile(arg0Value);
                            while (s0_ != null && (arg1Value.stride != s0_.cachedStrideSB_ || arg5Value != s0_.cachedStrideA_ || arg6Value != s0_.cachedStrideNew_)) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || count0_ >= 9) break block4;
                            s0_ = arg0Value.insert(new CachedData(s0_original));
                            s0_.cachedStrideSB_ = arg1Value.stride;
                            s0_.cachedStrideA_ = arg5Value;
                            s0_.cachedStrideNew_ = arg6Value;
                        } while (!this.cached_cache.compareAndSet(arg0Value, s0_original, s0_));
                        this.state_0_.set(arg0Value, state_0 |= 1);
                    }
                    if (s0_ != null) {
                        TruffleStringBuilder.AppendArrayIntlNode.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideSB_, s0_.cachedStrideA_, s0_.cachedStrideNew_, this.bufferGrow, this.error);
                        return;
                    }
                }
                this.cached_cache.set(arg0Value, null);
                state_0 &= 0xFFFFFFFE;
                this.state_0_.set(arg0Value, state_0 |= 2);
                TruffleStringBuilder.AppendArrayIntlNode.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.bufferGrow, this.error);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendArrayIntlNode.class)
        @DenyReplace
        private static final class CachedData
        extends Node {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            int cachedStrideSB_;
            @CompilerDirectives.CompilationFinal
            int cachedStrideA_;
            @CompilerDirectives.CompilationFinal
            int cachedStrideNew_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.ToStringNode.class)
    static final class ToStringNodeGen
    extends TruffleStringBuilder.ToStringNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final InlinedConditionProfile INLINED_CALC_ATTRIBUTES_PROFILE_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(0, 2)));
        private static final TStringInternalNodes.CalcStringAttributesNode INLINED_CALC_ATTRIBUTES_NODE_ = TStringInternalNodesFactory.CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, STATE_0_UPDATER.subUpdater(2, 16)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;

        private ToStringNodeGen() {
        }

        @Override
        public TruffleString execute(TruffleStringBuilder arg0Value, boolean arg1Value) {
            return this.createString(arg0Value, arg1Value, INLINED_CALC_ATTRIBUTES_PROFILE_, INLINED_CALC_ATTRIBUTES_NODE_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.ToStringNode create() {
            return new ToStringNodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.ToStringNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.ToStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.ToStringNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString execute(TruffleStringBuilder arg0Value, boolean arg1Value) {
                return this.createString(arg0Value, arg1Value, InlinedConditionProfile.getUncached(), TStringInternalNodesFactory.CalcStringAttributesNodeGen.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendJavaStringUTF16Node.class)
    static final class AppendJavaStringUTF16NodeGen
    extends TruffleStringBuilder.AppendJavaStringUTF16Node {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final TruffleStringBuilder.AppendArrayIntlNode INLINED_APPEND_ARRAY_INTL_NODE_ = AppendArrayIntlNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringBuilder.AppendArrayIntlNode.class, STATE_0_UPDATER.subUpdater(0, 5), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "appendArrayIntlNode__field1_", Node.class)));
        private static final InlinedConditionProfile INLINED_STRIDE0_PROFILE_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(5, 2)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Node appendArrayIntlNode__field1_;

        private AppendJavaStringUTF16NodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, String arg1Value, int arg2Value, int arg3Value) {
            this.append(arg0Value, arg1Value, arg2Value, arg3Value, INLINED_APPEND_ARRAY_INTL_NODE_, INLINED_STRIDE0_PROFILE_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendJavaStringUTF16Node create() {
            return new AppendJavaStringUTF16NodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendJavaStringUTF16Node getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendJavaStringUTF16Node {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, String arg1Value, int arg2Value, int arg3Value) {
                this.append(arg0Value, arg1Value, arg2Value, arg3Value, AppendArrayIntlNodeGen.getUncached(), InlinedConditionProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendSubstringByteIndexNode.class)
    static final class AppendSubstringByteIndexNodeGen
    extends TruffleStringBuilder.AppendSubstringByteIndexNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final InlineSupport.StateField STATE_1_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_1_");
        private static final InlineSupport.StateField STATE_2_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_2_");
        private static final TruffleString.ToIndexableNode INLINED_TO_INDEXABLE_NODE_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, STATE_0_UPDATER.subUpdater(0, 7)));
        private static final TStringInternalNodes.GetCodePointLengthNode INLINED_GET_CODE_POINT_LENGTH_NODE_ = TStringInternalNodesFactory.GetCodePointLengthNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetCodePointLengthNode.class, STATE_0_UPDATER.subUpdater(7, 25)));
        private static final TStringInternalNodes.GetPreciseCodeRangeNode INLINED_GET_PRECISE_CODE_RANGE_NODE_ = TStringInternalNodesFactory.GetPreciseCodeRangeNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetPreciseCodeRangeNode.class, STATE_1_UPDATER.subUpdater(0, 25)));
        private static final TruffleStringBuilder.AppendArrayIntlNode INLINED_APPEND_ARRAY_INTL_NODE_ = AppendArrayIntlNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringBuilder.AppendArrayIntlNode.class, STATE_1_UPDATER.subUpdater(25, 5), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "appendArrayIntlNode__field1_", Node.class)));
        private static final TStringInternalNodes.CalcStringAttributesNode INLINED_CALC_ATTRIBUTES_NODE_ = TStringInternalNodesFactory.CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, STATE_2_UPDATER.subUpdater(0, 16)));
        private static final InlinedConditionProfile INLINED_CALC_ATTRS_PROFILE_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_1_UPDATER.subUpdater(30, 2)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_1_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_2_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Node appendArrayIntlNode__field1_;

        private AppendSubstringByteIndexNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value) {
            this.append(arg0Value, arg1Value, arg2Value, arg3Value, INLINED_TO_INDEXABLE_NODE_, INLINED_GET_CODE_POINT_LENGTH_NODE_, INLINED_GET_PRECISE_CODE_RANGE_NODE_, INLINED_APPEND_ARRAY_INTL_NODE_, INLINED_CALC_ATTRIBUTES_NODE_, INLINED_CALC_ATTRS_PROFILE_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendSubstringByteIndexNode create() {
            return new AppendSubstringByteIndexNodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendSubstringByteIndexNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendSubstringByteIndexNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendSubstringByteIndexNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value) {
                this.append(arg0Value, arg1Value, arg2Value, arg3Value, TruffleStringFactory.ToIndexableNodeGen.getUncached(), TStringInternalNodes.GetCodePointLengthNode.getUncached(), TStringInternalNodesFactory.GetPreciseCodeRangeNodeGen.getUncached(), AppendArrayIntlNodeGen.getUncached(), TStringInternalNodesFactory.CalcStringAttributesNodeGen.getUncached(), InlinedConditionProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendStringNode.class)
    static final class AppendStringNodeGen
    extends TruffleStringBuilder.AppendStringNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final InlineSupport.StateField STATE_1_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_1_");
        private static final TruffleString.ToIndexableNode INLINED_TO_INDEXABLE_NODE_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, STATE_0_UPDATER.subUpdater(0, 7)));
        private static final TStringInternalNodes.GetCodePointLengthNode INLINED_GET_CODE_POINT_LENGTH_NODE_ = TStringInternalNodesFactory.GetCodePointLengthNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetCodePointLengthNode.class, STATE_0_UPDATER.subUpdater(7, 25)));
        private static final TStringInternalNodes.GetPreciseCodeRangeNode INLINED_GET_PRECISE_CODE_RANGE_NODE_ = TStringInternalNodesFactory.GetPreciseCodeRangeNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetPreciseCodeRangeNode.class, STATE_1_UPDATER.subUpdater(0, 25)));
        private static final TruffleStringBuilder.AppendArrayIntlNode INLINED_APPEND_ARRAY_INTL_NODE_ = AppendArrayIntlNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringBuilder.AppendArrayIntlNode.class, STATE_1_UPDATER.subUpdater(25, 5), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "appendArrayIntlNode__field1_", Node.class)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_1_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Node appendArrayIntlNode__field1_;

        private AppendStringNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value) {
            this.append(arg0Value, arg1Value, INLINED_TO_INDEXABLE_NODE_, INLINED_GET_CODE_POINT_LENGTH_NODE_, INLINED_GET_PRECISE_CODE_RANGE_NODE_, INLINED_APPEND_ARRAY_INTL_NODE_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendStringNode create() {
            return new AppendStringNodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendStringNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendStringNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value) {
                this.append(arg0Value, arg1Value, TruffleStringFactory.ToIndexableNodeGen.getUncached(), TStringInternalNodes.GetCodePointLengthNode.getUncached(), TStringInternalNodesFactory.GetPreciseCodeRangeNodeGen.getUncached(), AppendArrayIntlNodeGen.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendLongNumberNode.class)
    static final class AppendLongNumberNodeGen
    extends TruffleStringBuilder.AppendLongNumberNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final InlinedConditionProfile INLINED_APPEND0_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(12, 2)));
        private static final InlinedBranchProfile INLINED_APPEND0_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(14, 1)));
        private static final InlinedConditionProfile INLINED_APPEND1_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(15, 2)));
        private static final InlinedBranchProfile INLINED_APPEND1_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(17, 1)));
        private static final InlinedConditionProfile INLINED_APPEND2_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(18, 2)));
        private static final InlinedBranchProfile INLINED_APPEND2_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(20, 1)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;

        private AppendLongNumberNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x111) != 0) {
                TruffleString.CompactionLevel compaction__;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), INLINED_APPEND0_BUFFER_GROW_PROFILE_, INLINED_APPEND0_ERROR_PROFILE_);
                    return;
                }
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), INLINED_APPEND1_BUFFER_GROW_PROFILE_, INLINED_APPEND1_ERROR_PROFILE_);
                    return;
                }
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), INLINED_APPEND2_BUFFER_GROW_PROFILE_, INLINED_APPEND2_ERROR_PROFILE_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            TruffleString.CompactionLevel compaction__ = null;
            boolean Append0_duplicateFound_ = false;
            if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                Append0_duplicateFound_ = true;
            }
            if (!Append0_duplicateFound_ && (state_0 & 1) == 0) {
                compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride);
                state_0 |= TruffleStringBuilderFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                this.state_0_ = state_0 |= 1;
                Append0_duplicateFound_ = true;
            }
            if (Append0_duplicateFound_) {
                this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), INLINED_APPEND0_BUFFER_GROW_PROFILE_, INLINED_APPEND0_ERROR_PROFILE_);
                return;
            }
            compaction__ = null;
            boolean Append1_duplicateFound_ = false;
            if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                Append1_duplicateFound_ = true;
            }
            if (!Append1_duplicateFound_ && (state_0 & 0x10) == 0) {
                compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride);
                state_0 |= TruffleStringBuilderFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                this.state_0_ = state_0 |= 0x10;
                Append1_duplicateFound_ = true;
            }
            if (Append1_duplicateFound_) {
                this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), INLINED_APPEND1_BUFFER_GROW_PROFILE_, INLINED_APPEND1_ERROR_PROFILE_);
                return;
            }
            compaction__ = null;
            boolean Append2_duplicateFound_ = false;
            if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                Append2_duplicateFound_ = true;
            }
            if (!Append2_duplicateFound_ && (state_0 & 0x100) == 0) {
                compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride);
                state_0 |= TruffleStringBuilderFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                this.state_0_ = state_0 |= 0x100;
                Append2_duplicateFound_ = true;
            }
            if (Append2_duplicateFound_) {
                this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), INLINED_APPEND2_BUFFER_GROW_PROFILE_, INLINED_APPEND2_ERROR_PROFILE_);
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x111) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x111 & (state_0 & 0x111) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendLongNumberNode create() {
            return new AppendLongNumberNodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendLongNumberNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendLongNumberNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendLongNumberNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, long arg1Value) {
                this.doAppend(arg0Value, arg1Value, TruffleString.CompactionLevel.fromStride(arg0Value.stride), TruffleString.CompactionLevel.fromStride(arg0Value.stride), InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendIntNumberNode.class)
    static final class AppendIntNumberNodeGen
    extends TruffleStringBuilder.AppendIntNumberNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final InlinedConditionProfile INLINED_BUFFER_GROW = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(12, 2)));
        private static final InlinedBranchProfile INLINED_ERROR = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(14, 1)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;

        private AppendIntNumberNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x111) != 0) {
                TruffleString.CompactionLevel compaction__;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                    return;
                }
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                    return;
                }
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            TruffleString.CompactionLevel compaction__ = null;
            boolean Append0_duplicateFound_ = false;
            if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                Append0_duplicateFound_ = true;
            }
            if (!Append0_duplicateFound_ && (state_0 & 1) == 0) {
                compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride);
                state_0 |= TruffleStringBuilderFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                this.state_0_ = state_0 |= 1;
                Append0_duplicateFound_ = true;
            }
            if (Append0_duplicateFound_) {
                this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                return;
            }
            compaction__ = null;
            boolean Append1_duplicateFound_ = false;
            if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                Append1_duplicateFound_ = true;
            }
            if (!Append1_duplicateFound_ && (state_0 & 0x10) == 0) {
                compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride);
                state_0 |= TruffleStringBuilderFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                this.state_0_ = state_0 |= 0x10;
                Append1_duplicateFound_ = true;
            }
            if (Append1_duplicateFound_) {
                this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                return;
            }
            compaction__ = null;
            boolean Append2_duplicateFound_ = false;
            if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)) == TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                Append2_duplicateFound_ = true;
            }
            if (!Append2_duplicateFound_ && (state_0 & 0x100) == 0) {
                compaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride);
                state_0 |= TruffleStringBuilderFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                this.state_0_ = state_0 |= 0x100;
                Append2_duplicateFound_ = true;
            }
            if (Append2_duplicateFound_) {
                this.doAppend(arg0Value, arg1Value, compaction__, TruffleStringBuilderFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x111) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x111 & (state_0 & 0x111) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendIntNumberNode create() {
            return new AppendIntNumberNodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendIntNumberNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendIntNumberNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendIntNumberNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, int arg1Value) {
                this.doAppend(arg0Value, arg1Value, TruffleString.CompactionLevel.fromStride(arg0Value.stride), TruffleString.CompactionLevel.fromStride(arg0Value.stride), InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendCodePointIntlNode.class)
    static final class AppendCodePointIntlNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        AppendCodePointIntlNodeGen() {
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendCodePointIntlNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendCodePointIntlNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendCodePointIntlNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, int arg2Value, TruffleString.Encoding arg3Value, int arg4Value, boolean arg5Value) {
                if (TStringGuards.isAsciiBytesOrLatin1(arg3Value)) {
                    TruffleStringBuilder.AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (TStringGuards.isUTF8(arg3Value)) {
                    TruffleStringBuilder.AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (TStringGuards.isUTF16(arg3Value)) {
                    TruffleStringBuilder.AppendCodePointIntlNode.utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached());
                    return;
                }
                if (TStringGuards.isUTF32(arg3Value)) {
                    TruffleStringBuilder.AppendCodePointIntlNode.utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                if (TStringGuards.isUnsupportedEncoding(arg3Value)) {
                    TruffleStringBuilder.AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value});
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Inlined
        extends TruffleStringBuilder.AppendCodePointIntlNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Utf16CachedData> utf16Cached_cache;
            private final InlineSupport.ReferenceField<Utf32CachedData> utf32Cached_cache;
            private final InlinedConditionProfile bufferGrow;
            private final InlinedBranchProfile error;
            private final InlinedConditionProfile bmp;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TruffleStringBuilder.AppendCodePointIntlNode.class));
                this.state_0_ = target.getState(0, 12);
                this.utf16Cached_cache = target.getReference(1, Utf16CachedData.class);
                this.utf32Cached_cache = target.getReference(2, Utf32CachedData.class);
                this.bufferGrow = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(7, 2)));
                this.error = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(9, 1)));
                this.bmp = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(10, 2)));
            }

            @Override
            @ExplodeLoop
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, int arg2Value, TruffleString.Encoding arg3Value, int arg4Value, boolean arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x7F) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isAsciiBytesOrLatin1(arg3Value)) {
                        TruffleStringBuilder.AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                        return;
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF8(arg3Value)) {
                        TruffleStringBuilder.AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                        return;
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF16(arg3Value)) {
                        Utf16CachedData s2_ = this.utf16Cached_cache.get(arg0Value);
                        while (s2_ != null) {
                            if (s2_.cachedCurStride_ == arg1Value.stride && s2_.cachedNewStride_ == TruffleStringBuilder.utf16Stride(arg1Value, arg2Value)) {
                                TruffleStringBuilder.AppendCodePointIntlNode.utf16Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s2_.cachedCurStride_, s2_.cachedNewStride_, this.bmp);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUTF16(arg3Value)) {
                        TruffleStringBuilder.AppendCodePointIntlNode.utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, this.bmp);
                        return;
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isUTF32(arg3Value)) {
                        Utf32CachedData s4_ = this.utf32Cached_cache.get(arg0Value);
                        while (s4_ != null) {
                            if (s4_.cachedCurStride_ == arg1Value.stride && s4_.cachedNewStride_ == TruffleStringBuilder.utf32Stride(arg1Value, arg2Value)) {
                                TruffleStringBuilder.AppendCodePointIntlNode.utf32Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s4_.cachedCurStride_, s4_.cachedNewStride_);
                                return;
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0x20) != 0 && TStringGuards.isUTF32(arg3Value)) {
                        TruffleStringBuilder.AppendCodePointIntlNode.utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                        return;
                    }
                    if ((state_0 & 0x40) != 0 && TStringGuards.isUnsupportedEncoding(arg3Value)) {
                        TruffleStringBuilder.AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private void executeAndSpecialize(Node arg0Value, TruffleStringBuilder arg1Value, int arg2Value, TruffleString.Encoding arg3Value, int arg4Value, boolean arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isAsciiBytesOrLatin1(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    TruffleStringBuilder.AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                if (TStringGuards.isUTF8(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    TruffleStringBuilder.AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                if ((state_0 & 8) == 0 && TStringGuards.isUTF16(arg3Value)) {
                    Utf16CachedData s2_;
                    block13: {
                        Utf16CachedData s2_original;
                        do {
                            int cachedNewStride__;
                            int count2_ = 0;
                            s2_original = s2_ = this.utf16Cached_cache.getVolatile(arg0Value);
                            while (s2_ != null && (s2_.cachedCurStride_ != arg1Value.stride || s2_.cachedNewStride_ != TruffleStringBuilder.utf16Stride(arg1Value, arg2Value))) {
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || (cachedNewStride__ = TruffleStringBuilder.utf16Stride(arg1Value, arg2Value)) != TruffleStringBuilder.utf16Stride(arg1Value, arg2Value) || count2_ >= 9) break block13;
                            s2_ = arg0Value.insert(new Utf16CachedData(s2_original));
                            s2_.cachedCurStride_ = arg1Value.stride;
                            s2_.cachedNewStride_ = cachedNewStride__;
                        } while (!this.utf16Cached_cache.compareAndSet(arg0Value, s2_original, s2_));
                        this.state_0_.set(arg0Value, state_0 |= 4);
                    }
                    if (s2_ != null) {
                        TruffleStringBuilder.AppendCodePointIntlNode.utf16Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s2_.cachedCurStride_, s2_.cachedNewStride_, this.bmp);
                        return;
                    }
                }
                if (TStringGuards.isUTF16(arg3Value)) {
                    this.utf16Cached_cache.set(arg0Value, null);
                    state_0 &= 0xFFFFFFFB;
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    TruffleStringBuilder.AppendCodePointIntlNode.utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, this.bmp);
                    return;
                }
                if ((state_0 & 0x20) == 0 && TStringGuards.isUTF32(arg3Value)) {
                    Utf32CachedData s4_;
                    block14: {
                        Utf32CachedData s4_original;
                        do {
                            int cachedNewStride__1;
                            int count4_ = 0;
                            s4_original = s4_ = this.utf32Cached_cache.getVolatile(arg0Value);
                            while (s4_ != null && (s4_.cachedCurStride_ != arg1Value.stride || s4_.cachedNewStride_ != TruffleStringBuilder.utf32Stride(arg1Value, arg2Value))) {
                                ++count4_;
                                s4_ = s4_.next_;
                            }
                            if (s4_ != null || (cachedNewStride__1 = TruffleStringBuilder.utf32Stride(arg1Value, arg2Value)) != TruffleStringBuilder.utf32Stride(arg1Value, arg2Value) || count4_ >= 9) break block14;
                            s4_ = arg0Value.insert(new Utf32CachedData(s4_original));
                            s4_.cachedCurStride_ = arg1Value.stride;
                            s4_.cachedNewStride_ = cachedNewStride__1;
                        } while (!this.utf32Cached_cache.compareAndSet(arg0Value, s4_original, s4_));
                        this.state_0_.set(arg0Value, state_0 |= 0x10);
                    }
                    if (s4_ != null) {
                        TruffleStringBuilder.AppendCodePointIntlNode.utf32Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s4_.cachedCurStride_, s4_.cachedNewStride_);
                        return;
                    }
                }
                if (TStringGuards.isUTF32(arg3Value)) {
                    this.utf32Cached_cache.set(arg0Value, null);
                    state_0 &= 0xFFFFFFEF;
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    TruffleStringBuilder.AppendCodePointIntlNode.utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                if (TStringGuards.isUnsupportedEncoding(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x40);
                    TruffleStringBuilder.AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value});
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Utf32CachedData
        extends Node {
            @Node.Child
            Utf32CachedData next_;
            @CompilerDirectives.CompilationFinal
            int cachedCurStride_;
            @CompilerDirectives.CompilationFinal
            int cachedNewStride_;

            Utf32CachedData(Utf32CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Utf16CachedData
        extends Node {
            @Node.Child
            Utf16CachedData next_;
            @CompilerDirectives.CompilationFinal
            int cachedCurStride_;
            @CompilerDirectives.CompilationFinal
            int cachedNewStride_;

            Utf16CachedData(Utf16CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendCodePointNode.class)
    static final class AppendCodePointNodeGen
    extends TruffleStringBuilder.AppendCodePointNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final TruffleStringBuilder.AppendCodePointIntlNode INLINED_APPEND_CODE_POINT_INTL_NODE_ = AppendCodePointIntlNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringBuilder.AppendCodePointIntlNode.class, STATE_0_UPDATER.subUpdater(0, 12), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "appendCodePointIntlNode__field1_", Node.class), InlineSupport.ReferenceField.create(MethodHandles.lookup(), "appendCodePointIntlNode__field2_", Node.class)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Node appendCodePointIntlNode__field1_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Node appendCodePointIntlNode__field2_;

        private AppendCodePointNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
            this.append(arg0Value, arg1Value, arg2Value, arg3Value, INLINED_APPEND_CODE_POINT_INTL_NODE_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendCodePointNode create() {
            return new AppendCodePointNodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendCodePointNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendCodePointNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
                this.append(arg0Value, arg1Value, arg2Value, arg3Value, AppendCodePointIntlNodeGen.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendCharUTF16Node.class)
    static final class AppendCharUTF16NodeGen
    extends TruffleStringBuilder.AppendCharUTF16Node {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        static final InlineSupport.ReferenceField<CachedData> CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
        private static final InlinedConditionProfile INLINED_BUFFER_GROW = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(2, 2)));
        private static final InlinedBranchProfile INLINED_ERROR = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(4, 1)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private CachedData cached_cache;

        private AppendCharUTF16NodeGen() {
        }

        @Override
        @ExplodeLoop
        public void execute(TruffleStringBuilder arg0Value, char arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 3) != 0) {
                if ((state_0 & 1) != 0) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if (TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2).getStride() == arg0Value.stride && TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2).getStride() == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value)) {
                            AppendCharUTF16NodeGen node__ = this;
                            TruffleStringBuilder.AppendCharUTF16Node.doCached(arg0Value, arg1Value, node__, TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2), TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                            return;
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    this.doUncached(arg0Value, arg1Value, INLINED_BUFFER_GROW, INLINED_ERROR);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, char arg1Value) {
            int state_0 = this.state_0_;
            AppendCharUTF16NodeGen node__ = null;
            if ((state_0 & 2) == 0) {
                CachedData s0_;
                block5: {
                    CachedData s0_original;
                    do {
                        TruffleString.CompactionLevel cachedNewCompaction__;
                        TruffleString.CompactionLevel cachedCurCompaction__;
                        int count0_ = 0;
                        s0_original = s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                        while (s0_ != null) {
                            if (TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2).getStride() == arg0Value.stride && TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2).getStride() == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value)) {
                                node__ = this;
                                break;
                            }
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || (cachedCurCompaction__ = TruffleString.CompactionLevel.fromStride(arg0Value.stride)).getStride() != arg0Value.stride || (cachedNewCompaction__ = TruffleString.CompactionLevel.fromStride(TruffleStringBuilder.utf16Stride(arg0Value, arg1Value))).getStride() != TruffleStringBuilder.utf16Stride(arg0Value, arg1Value) || count0_ >= 9) break block5;
                        s0_ = this.insert(new CachedData(s0_original));
                        node__ = this;
                        s0_.cached_state_0_ |= TruffleStringBuilderFactory.encodeCompactionLevel(cachedCurCompaction__) + 2 << 0;
                        s0_.cached_state_0_ |= TruffleStringBuilderFactory.encodeCompactionLevel(cachedNewCompaction__) + 2 << 3;
                    } while (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_));
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    TruffleStringBuilder.AppendCharUTF16Node.doCached(arg0Value, arg1Value, node__, TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2), TruffleStringBuilderFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                    return;
                }
            }
            this.cached_cache = null;
            state_0 &= 0xFFFFFFFE;
            this.state_0_ = state_0 |= 2;
            this.doUncached(arg0Value, arg1Value, INLINED_BUFFER_GROW, INLINED_ERROR);
        }

        @Override
        public NodeCost getCost() {
            CachedData s0_;
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s0_ = this.cached_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendCharUTF16Node create() {
            return new AppendCharUTF16NodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendCharUTF16Node getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendCharUTF16Node.class)
        @DenyReplace
        private static final class CachedData
        extends Node {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            private int cached_state_0_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendCharUTF16Node.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendCharUTF16Node {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, char arg1Value) {
                this.doUncached(arg0Value, arg1Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TruffleStringBuilder.AppendByteNode.class)
    static final class AppendByteNodeGen
    extends TruffleStringBuilder.AppendByteNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final InlinedConditionProfile INLINED_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(0, 2)));
        private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(2, 1)));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;

        private AppendByteNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, byte arg1Value) {
            this.append(arg0Value, arg1Value, INLINED_BUFFER_GROW_PROFILE_, INLINED_ERROR_PROFILE_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendByteNode create() {
            return new AppendByteNodeGen();
        }

        @NeverDefault
        public static TruffleStringBuilder.AppendByteNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringBuilder.AppendByteNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringBuilder.AppendByteNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(TruffleStringBuilder arg0Value, byte arg1Value) {
                this.append(arg0Value, arg1Value, InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }
}

