/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.VM;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.driver.BundleSupport;
import com.oracle.svm.driver.NativeImage;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.graalvm.compiler.options.OptionType;

class CmdLineOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private static final String HELP_TEXT = NativeImage.getResource("/Help.txt");
    private static final String HELP_EXTRA_TEXT = NativeImage.getResource("/HelpExtra.txt");
    static final String VERBOSE_OPTION = "--verbose";
    static final String DRY_RUN_OPTION = "--dry-run";
    static final String DEBUG_ATTACH_OPTION = "--debug-attach";
    private static final String VERBOSE_SERVER_OPTION = "--verbose-server";
    private static final String SERVER_OPTION_PREFIX = "--server-";
    private static final String LAUNCHER_NAME = "native-image";
    boolean useDebugAttach = false;

    CmdLineOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
    }

    @Override
    boolean consume(NativeImage.ArgumentQueue args) {
        String headArg = args.peek();
        boolean consumed = this.consume(args, headArg);
        OptionOrigin origin = OptionOrigin.from((String)args.argumentOrigin);
        if (consumed && !origin.commandLineLike()) {
            String msg = String.format("Using '%s' provided by %s is only allowed on command line.", headArg, origin);
            throw NativeImage.showError(msg);
        }
        return consumed;
    }

    private boolean consume(NativeImage.ArgumentQueue args, String headArg) {
        switch (headArg) {
            case "--help": {
                args.poll();
                CmdLineOptionHandler.singleArgumentCheck(args, headArg);
                this.nativeImage.showMessage(HELP_TEXT);
                this.nativeImage.showNewline();
                this.nativeImage.apiOptionHandler.printOptions(this.nativeImage::showMessage, false);
                this.nativeImage.showNewline();
                this.nativeImage.optionRegistry.showOptions(null, true, this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                System.exit(ExitStatus.OK.getValue());
                return true;
            }
            case "--version": {
                args.poll();
                CmdLineOptionHandler.singleArgumentCheck(args, headArg);
                this.printVersion();
                System.exit(ExitStatus.OK.getValue());
                return true;
            }
            case "--help-extra": {
                args.poll();
                CmdLineOptionHandler.singleArgumentCheck(args, headArg);
                this.nativeImage.showMessage(HELP_EXTRA_TEXT);
                this.nativeImage.apiOptionHandler.printOptions(this.nativeImage::showMessage, true);
                this.nativeImage.showNewline();
                this.nativeImage.optionRegistry.showOptions(OptionUtils.MacroOptionKind.Macro, true, this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                System.exit(ExitStatus.OK.getValue());
                return true;
            }
            case "--configurations-path": {
                args.poll();
                String configPath = args.poll();
                if (configPath == null) {
                    NativeImage.showError(headArg + " requires a " + File.pathSeparator + " separated list of directories");
                }
                for (String configDir : configPath.split(File.pathSeparator)) {
                    this.nativeImage.addMacroOptionRoot(Paths.get(configDir, new String[0]));
                }
                return true;
            }
            case "--exclude-config": {
                String excludeConfig;
                args.poll();
                String excludeJar = args.poll();
                if (excludeJar == null) {
                    NativeImage.showError(headArg + " requires two arguments: a jar regular expression and a resource regular expression");
                }
                if ((excludeConfig = args.poll()) == null) {
                    NativeImage.showError(headArg + " requires resource regular expression");
                }
                this.nativeImage.addExcludeConfig(Pattern.compile(excludeJar), Pattern.compile(excludeConfig));
                return true;
            }
            case "--verbose": {
                args.poll();
                this.nativeImage.addVerbose();
                return true;
            }
            case "--dry-run": {
                args.poll();
                this.nativeImage.setDryRun(true);
                return true;
            }
            case "--expert-options": {
                args.poll();
                this.nativeImage.setPrintFlagsOptionQuery(OptionType.User.name());
                return true;
            }
            case "--expert-options-all": {
                args.poll();
                this.nativeImage.setPrintFlagsOptionQuery("");
                return true;
            }
            case "--expert-options-detail": {
                args.poll();
                String optionNames = args.poll();
                this.nativeImage.setPrintFlagsWithExtraHelpOptionQuery(optionNames);
                return true;
            }
            case "--verbose-server": {
                args.poll();
                NativeImage.showWarning("Ignoring server-mode native-image argument " + headArg + ".");
                return true;
            }
        }
        if (headArg.startsWith("--bundle")) {
            this.nativeImage.bundleSupport = BundleSupport.create(this.nativeImage, args.poll(), args);
            return true;
        }
        if (headArg.startsWith(DEBUG_ATTACH_OPTION)) {
            if (this.useDebugAttach) {
                throw NativeImage.showError("The --debug-attach option can only be used once.");
            }
            this.useDebugAttach = true;
            String debugAttachArg = args.poll();
            String addressSuffix = debugAttachArg.substring(DEBUG_ATTACH_OPTION.length());
            String address = addressSuffix.isEmpty() ? "8000" : addressSuffix.substring(1);
            this.nativeImage.addImageBuilderJavaArgs("-agentlib:jdwp=transport=dt_socket,server=y,address=" + address + ",suspend=y");
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHDeadlockWatchdogInterval + "0");
            return true;
        }
        if (headArg.startsWith(SERVER_OPTION_PREFIX)) {
            args.poll();
            NativeImage.showWarning("Ignoring server-mode native-image argument " + headArg + ".");
            String serverOptionCommand = headArg.substring(SERVER_OPTION_PREFIX.length());
            if (!serverOptionCommand.startsWith("session=")) {
                System.exit(ExitStatus.OK.getValue());
            }
            return true;
        }
        return false;
    }

    private void printVersion() {
        String javaVersion = System.getProperty("java.version");
        String javaVersionDate = System.getProperty("java.version.date");
        Optional<String> versionOpt = Runtime.version().optional();
        boolean isLTS = versionOpt.isPresent() && versionOpt.get().startsWith("LTS");
        this.nativeImage.showMessage("%s %s %s", LAUNCHER_NAME, javaVersion, javaVersionDate, isLTS ? " LTS" : "");
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        Object jdkDebugLevel = System.getProperty("jdk.debug", "release");
        jdkDebugLevel = "release".equals(jdkDebugLevel) ? "" : (String)jdkDebugLevel + " ";
        String javaRuntimeName = System.getProperty("java.runtime.name");
        Object vendorVersion = VM.getVendorVersion();
        vendorVersion = ((String)vendorVersion).isEmpty() ? "" : " " + (String)vendorVersion;
        this.nativeImage.showMessage("%s%s (%sbuild %s)", javaRuntimeName, vendorVersion, jdkDebugLevel, javaRuntimeVersion);
        String javaVMName = System.getProperty("java.vm.name");
        String javaVMVersion = System.getProperty("java.vm.version");
        String javaVMInfo = System.getProperty("java.vm.info");
        this.nativeImage.showMessage("%s%s (%sbuild %s, %s)", javaVMName, vendorVersion, jdkDebugLevel, javaVMVersion, javaVMInfo);
    }

    private static void singleArgumentCheck(NativeImage.ArgumentQueue args, String arg) {
        if (!args.isEmpty()) {
            NativeImage.showError("Option " + arg + " cannot be combined with other options.");
        }
    }

    @Override
    void addFallbackBuildArgs(List<String> buildArgs) {
        if (this.nativeImage.isVerbose()) {
            buildArgs.add(VERBOSE_OPTION);
        }
    }
}

