/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFINFIBackend;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendFactory;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;

@TruffleLanguage.Registration(id="internal/nfi-native", name="nfi-native", version="0.1", characterMimeTypes={"trufflenfi/native"}, internal=true, services={NFIBackendFactory.class}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
public class LibFFILanguage
extends TruffleLanguage<LibFFIContext> {
    public static final String MIME_TYPE = "trufflenfi/native";
    private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("libffi backend single context");
    @CompilerDirectives.CompilationFinal
    private LibFFINFIBackend backend;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType.CachedTypeInfo[] simpleTypeMap = new LibFFIType.CachedTypeInfo[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType.CachedTypeInfo[] arrayTypeMap = new LibFFIType.CachedTypeInfo[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType.CachedTypeInfo[] varargsTypeMap = new LibFFIType.CachedTypeInfo[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal
    LibFFIType.CachedTypeInfo cachedEnvType;
    private static final TruffleLanguage.LanguageReference<LibFFILanguage> REFERENCE = TruffleLanguage.LanguageReference.create(LibFFILanguage.class);

    static Assumption getSingleContextAssumption() {
        return LibFFILanguage.get(null).singleContextAssumption;
    }

    protected void initializeMultipleContexts() {
        super.initializeMultipleContexts();
        this.singleContextAssumption.invalidate();
    }

    LibFFIType.CachedTypeInfo lookupSimpleTypeInfo(NativeSimpleType type) {
        return this.simpleTypeMap[type.ordinal()];
    }

    protected LibFFIContext createContext(TruffleLanguage.Env env) {
        env.registerService((Object)new NFIBackendFactory(){

            public String getBackendId() {
                return "native";
            }

            public NFIBackend createBackend() {
                if (LibFFILanguage.this.backend == null) {
                    LibFFILanguage.this.backend = new LibFFINFIBackend(LibFFILanguage.this);
                }
                return LibFFILanguage.this.backend;
            }
        });
        return new LibFFIContext(this, env);
    }

    protected void initializeContext(LibFFIContext context) throws Exception {
        context.initialize();
    }

    protected boolean patchContext(LibFFIContext context, TruffleLanguage.Env newEnv) {
        context.patchEnv(newEnv);
        context.initialize();
        return true;
    }

    protected void disposeContext(LibFFIContext context) {
        context.dispose();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        return new RootNode(this){

            public Object execute(VirtualFrame frame) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException("illegal access to internal language");
            }
        }.getCallTarget();
    }

    protected static LibFFIContext getCurrentContext() {
        return LibFFIContext.get(null);
    }

    public static LibFFILanguage get(Node node) {
        return (LibFFILanguage)REFERENCE.get(node);
    }
}

