/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentNode;
import java.lang.ref.Reference;

@GenerateUncached
@ImportStatic(value={LibFFILanguage.class})
@GenerateAOT
abstract class FunctionExecuteNode
extends Node {
    FunctionExecuteNode() {
    }

    public abstract Object execute(long var1, LibFFISignature var3, Object[] var4) throws ArityException, UnsupportedTypeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"signature.signatureInfo == cachedInfo"})
    @GenerateAOT.Exclude
    protected Object cachedSignature(long receiver, LibFFISignature signature, Object[] args, @Cached(value="signature.signatureInfo") LibFFISignature.CachedSignatureInfo cachedInfo, @Cached(value="createCachedSignatureCall(cachedInfo)") DirectCallNode execute) {
        try {
            Object object = execute.call(new Object[]{receiver, args, signature});
            return object;
        }
        finally {
            Reference.reachabilityFence(args);
        }
    }

    protected static DirectCallNode createCachedSignatureCall(LibFFISignature.CachedSignatureInfo signature) {
        DirectCallNode callNode = DirectCallNode.create((CallTarget)signature.callTarget);
        callNode.forceInlining();
        return callNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(replaces={"cachedSignature"})
    static Object genericExecute(long receiver, LibFFISignature signature, Object[] args, @Cached IndirectCallNode execute) {
        try {
            Object object = execute.call(signature.signatureInfo.callTarget, new Object[]{receiver, args, signature});
            return object;
        }
        finally {
            Reference.reachabilityFence(args);
        }
    }

    static final class SignatureExecuteNode
    extends RootNode {
        final LibFFISignature.CachedSignatureInfo signatureInfo;
        @Node.Children
        SerializeArgumentNode[] argNodes;

        SignatureExecuteNode(LibFFILanguage language, LibFFISignature.CachedSignatureInfo signatureInfo) {
            super((TruffleLanguage)language);
            this.signatureInfo = signatureInfo;
            LibFFIType.CachedTypeInfo[] argTypes = signatureInfo.getArgTypes();
            this.argNodes = new SerializeArgumentNode[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                this.argNodes[i] = argTypes[i].createSerializeArgumentNode();
            }
        }

        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            long address = (Long)frame.getArguments()[0];
            Object[] args = (Object[])frame.getArguments()[1];
            LibFFISignature signature = (LibFFISignature)frame.getArguments()[2];
            if (args.length != this.argNodes.length) {
                throw SignatureExecuteNode.silenceException(RuntimeException.class, (Exception)ArityException.create((int)this.argNodes.length, (int)this.argNodes.length, (int)args.length));
            }
            NativeArgumentBuffer.Array buffer = this.signatureInfo.prepareBuffer();
            try {
                LibFFIType.CachedTypeInfo[] types = this.signatureInfo.getArgTypes();
                assert (this.argNodes.length == types.length);
                for (int i = 0; i < this.argNodes.length; ++i) {
                    this.argNodes[i].serialize(args[i], buffer);
                }
            }
            catch (UnsupportedTypeException ex) {
                throw SignatureExecuteNode.silenceException(RuntimeException.class, (Exception)((Object)ex));
            }
            CompilerDirectives.ensureVirtualized((Object)buffer);
            return this.signatureInfo.execute((Node)this, signature, LibFFIContext.get((Node)this), address, buffer);
        }

        static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
            throw ex;
        }
    }
}

