/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.truffle;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateHostFeatureEnabled;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;

@AutomaticallyRegisteredFeature
public final class PolyglotIsolateHostFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (PolyglotIsolateHostFeature.jO()) {
            ImageSingletons.add(PolyglotIsolateHostFeatureEnabled.class, (Object)new PolyglotIsolateHostFeatureEnabled());
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        if (PolyglotIsolateHostFeature.jO()) {
            PolyglotIsolateHostFeature.c((FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess);
        }
    }

    private static boolean jO() {
        return ImageSingletons.contains(TruffleBaseFeature.class) && (Boolean)SubstrateOptions.JNI.getValue() != false;
    }

    private static void c(FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl) {
        try {
            ImageClassLoader imageClassLoader = beforeAnalysisAccessImpl.getImageClassLoader();
            ArrayList<Method> arrayList = new ArrayList<Method>();
            arrayList.addAll(PolyglotIsolateHostFeature.b("org.graalvm.jniutils.JNIExceptionWrapperEntryPoints", JNIEntryPoint.class));
            arrayList.addAll(PolyglotIsolateHostFeature.b("org.graalvm.nativebridge.ForeignExceptionEndPoints", JNIEntryPoint.class));
            arrayList.addAll(imageClassLoader.findAnnotatedMethods(JNIEntryPoint.class));
            arrayList.stream().map(Method::getDeclaringClass).distinct().forEach(clazz -> RuntimeJNIAccess.register((Class[])new Class[]{clazz}));
            arrayList.forEach(executable -> RuntimeJNIAccess.register((Executable[])new Executable[]{executable}));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            UserError.abort((Throwable)reflectiveOperationException, (String)"Failed to register JNI entry points.", (Object[])new Object[0]);
        }
    }

    private static Collection<Method> b(String string, Class<? extends Annotation> clazz) throws ReflectiveOperationException {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Class<?> clazz2 = Class.forName(string);
        for (Method method : clazz2.getDeclaredMethods()) {
            if (AnnotationAccess.getAnnotation((AnnotatedElement)method, clazz) == null) continue;
            arrayList.add(method);
        }
        return arrayList;
    }
}

