/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profiling.features;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.al;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.pgo.c;
import com.oracle.svm.enterprise.hosted.phases.priorityinline.SubstratePriorityInliningPhase;
import com.oracle.svm.enterprise.profiling.f;
import com.oracle.svm.enterprise.profiling.h;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.i;
import com.oracle.svm.enterprise.profiling.metadata.elements.d;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingInstrumentationProfile;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class a
implements InternalFeature {
    public static boolean ie() {
        if (((Boolean)a.ProfilingEnabled.getValue()).booleanValue()) {
            UserError.guarantee((boolean)((Boolean)GraalOptions.TrackNodeSourcePosition.getValue(HostedOptionValues.singleton())), (String)"%s is incompatible with %s", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)GraalOptions.TrackNodeSourcePosition, (String)"-"), SubstrateOptionsParser.commandArgument(a.ProfilingEnabled, (String)"+")});
            UserError.guarantee(((Boolean)SubstrateOptions.AOTTrivialInline.getValue(HostedOptionValues.singleton()) == false ? 1 : 0) != 0, (String)"%s is incompatible with %s", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.AOTTrivialInline, (String)"+"), SubstrateOptionsParser.commandArgument(a.ProfilingEnabled, (String)"+")});
            return true;
        }
        return false;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(CGlobalDataFeature.class);
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        substrateForeignCallsProvider.register(f.Mm);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return a.ie();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        ImageSingletons.add(ProfilingInstrumentationProfile.class, (Object)new ProfilingInstrumentationProfile());
        ImageSingletons.add(b.class, (Object)new b());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        ProfilingInstrumentationProfile profilingInstrumentationProfile = ProfilingInstrumentationProfile.instance();
        b b2 = ProfilingInstrumentationProfile.metadataBuilder();
        RuntimeSupport runtimeSupport = RuntimeSupport.getRuntimeSupport();
        runtimeSupport.addStartupHook(profilingInstrumentationProfile.dumpStartupHook());
        runtimeSupport.addShutdownHook(profilingInstrumentationProfile.dumpShutdownHook());
        b2.b(new d());
        b2.a(new com.oracle.svm.enterprise.profiling.metadata.elements.c());
        FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        AnalysisMetaAccess analysisMetaAccess = beforeAnalysisAccessImpl.getMetaAccess();
        Iterator iterator = Stream.of("hashCode", "toString", "wait", "notify").map(string -> ReflectionUtil.lookupMethod(Object.class, (String)string, (Class[])new Class[0])).map(arg_0 -> ((AnalysisMetaAccess)analysisMetaAccess).lookupJavaMethod(arg_0)).iterator();
        NodeSourcePosition nodeSourcePosition = new NodeSourcePosition(null, (ResolvedJavaMethod)iterator.next(), 0);
        b2.a(f.a(nodeSourcePosition, b2::k), (byte)0, 0);
        b2.a(f.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> b2.a((int)n2, (int)n3, new int[]{0, 1}, new int[]{0, 1})), (byte)0, 0);
        b2.a(f.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> b2.a((int)n2, (int)n3, new ResolvedJavaType[0])), (byte)0, 0);
        b2.a(f.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> new i(0, 0)), (byte)0, 0);
        profilingInstrumentationProfile.data().iy();
        profilingInstrumentationProfile.setMetadata(b2.iJ());
        for (SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor : f.Mm) {
            beforeAnalysisAccessImpl.registerAsRoot((AnalysisMethod)substrateForeignCallDescriptor.findMethod((MetaAccessProvider)analysisMetaAccess), true);
        }
        if (!((Boolean)SubstrateOptions.MultiThreaded.getValue()).booleanValue()) {
            System.err.println("warning: Single-threaded VM cannot use signals to trigger profile dumping.");
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        ProfilingInstrumentationProfile.instance().reset();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        int n2 = ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId();
        VMError.guarantee((n2 > 0 ? 1 : 0) != 0, (String)"Max type ID should be positive.");
        int n3 = ProfilingInstrumentationProfile.instance().data().az(n2);
        VMError.guarantee((n3 == 0 ? 1 : 0) != 0, (String)"The monitor record should be in the beginning of the data storage.");
        b b2 = ProfilingInstrumentationProfile.metadataBuilder();
        b2.j(n2, n3);
        if (a.ProfilingPackagePrefixes.hasBeenSet()) {
            Set set = Arrays.stream(((String)a.ProfilingPackagePrefixes.getValue()).split(",")).map(string -> string.split("\\.")).map(Arrays::asList).collect(Collectors.toSet());
            Set<String> set2 = ((FeatureImpl.BeforeCompilationAccessImpl)beforeCompilationAccess).getUniverse().getTypes().stream().filter(hostedType -> a.a(hostedType, set)).map(JavaType::toClassName).collect(Collectors.toSet());
            b2.g(set2);
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        b b2 = ProfilingInstrumentationProfile.metadataBuilder();
        HostedUniverse hostedUniverse = ((FeatureImpl.AfterCompilationAccessImpl)afterCompilationAccess).getUniverse();
        Set<HostedMethod> set = a.a(hostedUniverse, b2.iI());
        Set<HostedType> set2 = a.a(hostedUniverse, b2, set);
        b2.b(a.e(set));
        b2.a(a.f(set2));
        ProfilingInstrumentationProfile.instance().setMetadata(b2.iJ());
    }

    private static boolean a(HostedType hostedType, Set<List<String>> set) {
        if (hostedType.isPrimitive() || hostedType.isArray() && hostedType.getBaseType().isPrimitive()) {
            return true;
        }
        List<String> list = a.b(hostedType);
        return set.stream().anyMatch(list2 -> a.b(list, list2));
    }

    private static List<String> b(HostedType hostedType) {
        String[] stringArray = hostedType.toJavaName().split("\\.");
        return Arrays.asList(Arrays.copyOf(stringArray, stringArray.length - 1));
    }

    private static boolean b(List<String> list, List<String> list2) {
        if (list2.size() > list.size()) {
            return false;
        }
        return list.subList(0, list2.size()).equals(list2);
    }

    private static Set<HostedMethod> a(HostedUniverse hostedUniverse, Set<String> set) {
        if (h.isSamplingActive()) {
            return new HashSet<HostedMethod>(hostedUniverse.getMethods());
        }
        Map<Integer, HostedMethod> map = hostedUniverse.getMethods().stream().collect(Collectors.toMap(hostedMethod -> hostedMethod.getWrapped().getId(), hostedMethod -> hostedMethod));
        return set.stream().flatMap(string -> a.a(string, map)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Stream<HostedMethod> a(String string2, Map<Integer, HostedMethod> map) {
        return Arrays.stream(f.af(string2)).map(string -> (HostedMethod)map.get(f.ae(string).getLeft()));
    }

    private static com.oracle.svm.enterprise.profiling.metadata.elements.b<com.oracle.svm.enterprise.profiling.metadata.elements.c> e(Set<? extends ResolvedJavaMethod> set) {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<com.oracle.svm.enterprise.profiling.metadata.elements.c>(set.stream().map(resolvedJavaMethod -> {
            ResolvedJavaType resolvedJavaType = resolvedJavaMethod.getDeclaringClass();
            int[] nArray = Arrays.stream(resolvedJavaMethod.getSignature().toParameterTypes(null)).map(javaType -> javaType.resolve(resolvedJavaType)).mapToInt(f::o).toArray();
            int n2 = f.o(resolvedJavaMethod.getSignature().getReturnType(resolvedJavaType).resolve(resolvedJavaType));
            return new com.oracle.svm.enterprise.profiling.metadata.elements.c(f.p(resolvedJavaMethod), resolvedJavaMethod.getName(), f.o(resolvedJavaType), n2, nArray);
        }).collect(Collectors.toList()));
    }

    private static Set<HostedType> a(HostedUniverse hostedUniverse, b b2, Set<HostedMethod> set) {
        Set<HostedType> set2 = hostedUniverse.getTypes().stream().filter(hostedType -> c.d(hostedType.getWrapped())).filter(hostedType -> b2.ai(hostedType.toClassName())).collect(Collectors.toSet());
        Set set3 = set.stream().flatMap(a::s).collect(Collectors.toSet());
        a.a(set, b2);
        set2.addAll(set3);
        return set2;
    }

    private static void a(Set<HostedMethod> set2, b b2) {
        HashMap<HostedMethod, Set<String>> hashMap = new HashMap<HostedMethod, Set<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        a.a(set2, b2, hashMap, hashSet);
        if (!hashMap.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("WARNING: incomplete partial profiling. We profile forbidden types (types that do not match the profiling package prefixes):\n");
            hashMap.forEach((hostedMethod, set) -> stringBuilder.append(hostedMethod.format("%H.%n")).append(" -> ").append(String.join((CharSequence)", ", set)).append("\n"));
            stringBuilder.append("Consider expanding your filter by including the packages:").append("\n").append("-H:ProfilingPackagePrefixes=").append(String.join((CharSequence)",", hashSet));
            System.out.println(stringBuilder);
        }
    }

    private static void a(Set<HostedMethod> set, b b2, Map<HostedMethod, Set<String>> map, Set<String> set2) {
        for (HostedMethod hostedMethod : set) {
            Set<HostedType> set3 = a.s(hostedMethod).filter(hostedType -> !b2.ai(hostedType.toClassName())).collect(Collectors.toSet());
            a.a(hostedMethod, set3, map, set2);
        }
    }

    private static void a(HostedMethod hostedMethod, Set<HostedType> set, Map<HostedMethod, Set<String>> map, Set<String> set2) {
        for (HostedType hostedType : set) {
            String string;
            map.putIfAbsent(hostedMethod, new HashSet());
            map.get(hostedMethod).add(hostedType.toClassName());
            String string2 = string = hostedType.isArray() ? hostedType.getBaseType().toClassName() : hostedType.toClassName();
            if (string.contains(".")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            set2.add(string);
        }
    }

    private static Stream<HostedType> s(HostedMethod hostedMethod) {
        HostedType hostedType = hostedMethod.getDeclaringClass();
        Stream<HostedType> stream = Stream.of(hostedType, (HostedType)hostedMethod.getSignature().getReturnType((ResolvedJavaType)hostedType).resolve((ResolvedJavaType)hostedType));
        Stream<HostedType> stream2 = Arrays.stream(hostedMethod.getSignature().toParameterTypes(null)).map(javaType -> (HostedType)javaType.resolve((ResolvedJavaType)hostedType));
        return Stream.concat(stream, stream2);
    }

    private static com.oracle.svm.enterprise.profiling.metadata.elements.b<d> f(Set<HostedType> set) {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<d>(set.stream().map(hostedType -> new d(f.o((ResolvedJavaType)hostedType), hostedType.toClassName())).collect(Collectors.toList()));
    }

    public static class a {
        @APIOption(name={"pgo-instrument"})
        public static final HostedOptionKey<Boolean> ProfilingEnabled = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    SubstrateOptions.InstallExitHandlers.update(economicMap, (Object)true);
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                    SubstrateOptions.AOTTrivialInline.update(economicMap, (Object)false);
                    al.AOTPriorityInline.update(economicMap, (Object)true);
                    SubstratePriorityInliningPhase.a.UseIPEA.update(economicMap, (Object)false);
                    h.a.SamplingCollect.update(economicMap, (Object)true);
                    a.a.MLProfileInference.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<String> ProfilingPackagePrefixes = new HostedOptionKey(null);
    }
}

