/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.AllocationFeature;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.jdk.management.ManagementFeature;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import com.oracle.svm.core.jvmstat.PerfDataFeature;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.option.SubstrateOptionKey;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.core.al;
import com.oracle.svm.enterprise.gc.g1.G1PerfData;
import com.oracle.svm.enterprise.gc.g1.a;
import com.oracle.svm.enterprise.gc.g1.e;
import com.oracle.svm.enterprise.gc.g1.g;
import com.oracle.svm.enterprise.gc.g1.graal.j;
import com.oracle.svm.enterprise.gc.g1.h;
import com.oracle.svm.enterprise.gc.g1.hosted.d;
import com.oracle.svm.enterprise.gc.g1.j;
import com.oracle.svm.enterprise.gc.g1.l;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.thread.VMThreadMTFeature;
import com.sun.management.GarbageCollectorMXBean;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.PlatformManagedObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.PinnedObjectSupport;

@AutomaticallyRegisteredFeature
public class b
implements InternalFeature {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public b() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return (Boolean)al.UseG1GC.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(VMThreadMTFeature.class, ManagementFeature.class, PerfDataFeature.class, AllocationFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        b.eX();
        ImageSingletons.add(BarrierSetProvider.class, (Object)new com.oracle.svm.enterprise.gc.g1.graal.b());
        ImageSingletons.add(ObjectLayout.class, (Object)b.eY());
        a a2 = new a();
        ImageSingletons.add(CommittedMemoryProvider.class, (Object)((Object)a2));
        ImageSingletons.add(a.class, (Object)((Object)a2));
    }

    public void duringSetup(Feature.DuringSetupAccess duringSetupAccess) {
        G1PerfData g1PerfData = null;
        if (ImageSingletons.contains(PerfManager.class)) {
            g1PerfData = new G1PerfData();
        }
        e e2 = new e(SubstrateOptions.getPageSize(), g1PerfData);
        ImageSingletons.add(Heap.class, (Object)((Object)e2));
        ImageSingletons.add(e.class, (Object)((Object)e2));
        ImageSingletons.add(GCAllocationSupport.class, (Object)new com.oracle.svm.enterprise.gc.g1.graal.a());
        ManagementSupport managementSupport = ManagementSupport.getSingleton();
        managementSupport.addPlatformManagedObjectSingleton(MemoryMXBean.class, (PlatformManagedObject)((Object)new h()));
        managementSupport.addPlatformManagedObjectList(GarbageCollectorMXBean.class, Collections.emptyList());
        managementSupport.addPlatformManagedObjectList(MemoryPoolMXBean.class, Collections.emptyList());
        managementSupport.addPlatformManagedObjectList(BufferPoolMXBean.class, Collections.emptyList());
        l l2 = new l();
        ImageSingletons.add(PinnedObjectSupport.class, (Object)l2);
        ImageSingletons.add(l.class, (Object)l2);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        beforeAnalysisAccessImpl.registerAsUsed(Object[].class);
        com.oracle.svm.enterprise.gc.g1.hosted.a.b(beforeAnalysisAccessImpl);
        j.a(beforeAnalysisAccessImpl);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        ImageSingletons.add(ImageHeapLayouter.class, (Object)new d());
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        FeatureImpl.BeforeCompilationAccessImpl beforeCompilationAccessImpl = (FeatureImpl.BeforeCompilationAccessImpl)beforeCompilationAccess;
        e e2 = e.get();
        g g2 = e.getImageHeapInfo();
        beforeCompilationAccessImpl.registerAsImmutable((Object)g2);
        beforeCompilationAccessImpl.registerAsImmutable((Object)g2.ep());
        beforeCompilationAccessImpl.registerAsImmutable((Object)g2.eq());
        byte[] byArray = com.oracle.svm.enterprise.gc.g1.hosted.a.b((Feature.BeforeCompilationAccess)beforeCompilationAccessImpl);
        e2.d(byArray);
        beforeCompilationAccessImpl.registerAsImmutable((Object)byArray);
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        com.oracle.svm.enterprise.gc.g1.graal.j.registerForeignCalls(substrateForeignCallsProvider);
        com.oracle.svm.enterprise.gc.g1.graal.a.registerForeignCalls(substrateForeignCallsProvider);
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfiguration, OptionValues optionValues, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> map, boolean bl2) {
        SubstrateAllocationSnippets substrateAllocationSnippets = (SubstrateAllocationSnippets)ImageSingletons.lookup(SubstrateAllocationSnippets.class);
        SubstrateAllocationSnippets.Templates templates = new SubstrateAllocationSnippets.Templates(optionValues, providers, substrateAllocationSnippets);
        templates.registerLowering(map);
        j.b b2 = new j.b(optionValues, SnippetCounter.Group.NullFactory, providers);
        b2.registerLowerings(map);
    }

    private static void eX() {
        UserError.guarantee((boolean)Platform.includedIn(Platform.LINUX_AMD64.class), (String)"The G1 garbage collector ('--gc=G1') is currently only supported on Linux AMD64.", (Object[])new Object[0]);
        UserError.guarantee(((Boolean)SubstrateOptions.UseSerialGC.getValue() == false ? 1 : 0) != 0, (String)"Only one garbage collector can be used at a time.", (Object[])new Object[0]);
        UserError.guarantee(((Boolean)SubstrateOptions.UseEpsilonGC.getValue() == false ? 1 : 0) != 0, (String)"Only one garbage collector can be used at a time.", (Object[])new Object[0]);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.SpawnIsolates);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.MultiThreaded);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.AllowVMInternalThreads);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.UseNullRegion);
        UserError.guarantee((!SubstrateOptions.supportCompileInIsolates() ? 1 : 0) != 0, (String)"The G1 garbage collector ('--gc=G1') does not support isolated compilation.", (Object[])new Object[0]);
    }

    private static void a(SubstrateOptionKey<Boolean> substrateOptionKey) {
        String string = "When using the G1 garbage collector ('--gc=G1'), please note that option '%s' must be enabled.";
        UserError.guarantee((boolean)((Boolean)substrateOptionKey.getValue()), (String)string, (Object[])new Object[]{substrateOptionKey.getName()});
    }

    private static ObjectLayout eY() {
        int n2;
        SubstrateTargetDescription substrateTargetDescription = ConfigurationValues.getTarget();
        int n3 = b.a(substrateTargetDescription);
        int n4 = 8;
        int n5 = 0;
        int n6 = n2 = n5 + 2 * n3;
        int n7 = n2;
        int n8 = n7 + substrateTargetDescription.arch.getPlatformKind(JavaKind.Int).getSizeInBytes();
        int n9 = b.h(n5, n3);
        return new ObjectLayout(substrateTargetDescription, n3, n4, n5, n6, n7, n8, n9);
    }

    private static int h(int n2, int n3) {
        if (al.useCompressedReferences()) {
            return n2 + n3;
        }
        assert (CodeUtil.isPowerOf2((int)n3));
        return n2 + n3 + (n3 >>> 1);
    }

    private static int a(SubstrateTargetDescription substrateTargetDescription) {
        JavaKind javaKind = JavaKind.Object;
        if (al.useCompressedReferences()) {
            javaKind = JavaKind.Int;
        }
        return substrateTargetDescription.arch.getPlatformKind(javaKind).getSizeInBytes();
    }
}

