/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.sboutlining.concat;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.annotate.a;
import com.oracle.svm.enterprise.core.sboutlining.concat.SubstrateStringConcatHelper;
import com.oracle.svm.enterprise.core.sboutlining.concat.d;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class c {
    private static final char yA = '\u0001';
    private static final char yB = '\u0002';
    private final Function<Class<?>, MethodHandle> yC = new Function<Class<?>, MethodHandle>(){

        public MethodHandle g(Class<?> clazz) {
            MethodHandle methodHandle = d.j(clazz);
            return methodHandle.bindTo(c.this.yF);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.g((Class)object);
        }
    };
    private final Function<Class<?>, MethodHandle> yD = new Function<Class<?>, MethodHandle>(){

        public MethodHandle g(Class<?> clazz) {
            return c.this.a(c.this.yJ.computeIfAbsent(clazz, c.this.yC), 3, null);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.g((Class)object);
        }
    };
    private final Function<Class<?>, MethodHandle> yE = new Function<Class<?>, MethodHandle>(){

        public MethodHandle g(Class<?> clazz) {
            MethodHandle methodHandle = d.h(clazz);
            return methodHandle.bindTo(c.this.yF);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.g((Class)object);
        }
    };
    private MethodHandle xY;
    private MethodHandle xZ;
    private MethodHandle ya;
    private MethodHandle yb;
    private MethodHandle yc;
    private MethodHandle yd;
    private MethodHandle ye;
    private MethodHandle yf;
    private final HostedGraphKit yF;
    private static final Method yG;
    private static final Method yH;
    private static final MethodHandle yI;
    private final Map<Class<?>, MethodHandle> yJ;
    private final Map<Class<?>, MethodHandle> yK;
    private final Map<Class<?>, MethodHandle> yL;
    private static final long yM;

    public MethodHandle b(MethodType methodType) throws StringConcatException {
        String string = "\u0001".repeat(methodType.parameterCount());
        return this.a(methodType, string, new Object[0]);
    }

    private MethodHandle a(MethodType methodType, String string2, Object ... objectArray) throws StringConcatException {
        Objects.requireNonNull(methodType, "Concat type is null");
        Objects.requireNonNull(objectArray, "Constants are null");
        assert (objectArray.length == 0) : "we expect no constants to be passed";
        for (Object object : objectArray) {
            Objects.requireNonNull(object, "Cannot accept null constants");
        }
        List<String> list = c.b(methodType, string2, objectArray);
        if (!((Class)methodType.returnType()).isAssignableFrom(String.class)) {
            throw new StringConcatException("The return type should be compatible with String, but it is " + String.valueOf(methodType.returnType()));
        }
        assert (list.stream().allMatch(string -> string == null)) : "the recipe should be only TAG_ARGs";
        try {
            return this.a(methodType, list);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new StringConcatException("Generator failed", throwable);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static List<String> b(MethodType methodType, String string, Object[] objectArray) throws StringConcatException {
        Objects.requireNonNull(string, "Recipe is null");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\u0002') {
                if (n2 == objectArray.length) {
                    throw c.a(objectArray, n2);
                }
                stringBuilder.append(objectArray[n2++]);
                continue;
            }
            if (c2 == '\u0001') {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                arrayList.add(null);
                ++n3;
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (n3 != methodType.parameterCount()) {
            throw c.b(methodType, n3);
        }
        if (n2 < objectArray.length) {
            throw c.a(objectArray, n2);
        }
        return arrayList;
    }

    private static StringConcatException b(MethodType methodType, int n2) {
        return new StringConcatException("Mismatched number of concat arguments: recipe wants " + n2 + " arguments, but signature provides " + methodType.parameterCount());
    }

    private static StringConcatException a(Object[] objectArray, int n2) {
        return new StringConcatException("Mismatched number of concat constants: recipe wants " + n2 + " constants, but only " + objectArray.length + " are passed");
    }

    /*
     * WARNING - void declaration
     */
    private MethodHandle a(MethodType methodType, List<String> list) {
        void var12_18;
        Object object;
        MethodHandle[] methodHandleArray;
        Object object3;
        if (list.size() == 1) {
            String string = list.get(0);
            if (string == null) {
                return this.i((Class<?>)methodType.parameterType(0));
            }
            return this.a(this.i(Object.class), 0, string);
        }
        if (list.size() == 2) {
            object3 = list.get(0);
            methodHandleArray = list.get(1);
            if (methodType.parameterCount() == 2 && !((Class)methodType.parameterType(0)).isPrimitive() && !((Class)methodType.parameterType(1)).isPrimitive() && object3 == null && methodHandleArray == null) {
                return this.dU();
            }
            if (methodType.parameterCount() == 1) {
                int n2;
                Object object4;
                if (methodHandleArray == null) {
                    object4 = object3;
                    n2 = 0;
                } else {
                    object4 = methodHandleArray;
                    n2 = 1;
                }
                if (((String)object4).isEmpty()) {
                    return this.i((Class<?>)methodType.parameterType(0));
                }
                if (!((Class)methodType.parameterType(0)).isPrimitive()) {
                    return this.a(this.dU(), n2, (String)object4);
                }
            }
        }
        object3 = methodType.erase().parameterArray();
        methodHandleArray = null;
        for (int i2 = 0; i2 < ((Class<?>[])object3).length; ++i2) {
            MethodHandle methodHandle = this.f(object3[i2]);
            if (methodHandle == null) continue;
            if (methodHandleArray == null) {
                methodHandleArray = new MethodHandle[((Class<?>[])object3).length];
            }
            methodHandleArray[i2] = methodHandle;
            object3[i2] = String.class;
        }
        Object[] objectArray = new Class[((Class<?>[])object3).length];
        Arrays.fill(objectArray, ValueNode.class);
        MethodHandle methodHandle = MethodHandles.dropArguments(this.dV(), 2, objectArray);
        long l2 = yM;
        String string = null;
        int n3 = 0;
        for (String object22 : list) {
            if (object22 != null) {
                l2 = SubstrateStringConcatHelper.mix(l2, object22);
                assert (string == null);
                string = object22;
                continue;
            }
            methodHandle = c.b(methodHandle, 1, this.a(string, object3[n3]), 1, 0, 2 + n3);
            string = null;
            ++n3;
        }
        if (string != null) {
            l2 -= (long)string.length();
            object = this.L(string);
        } else {
            object = this.dE();
        }
        methodHandle = c.a(methodHandle, 0, (MethodHandle)object, 1);
        n3 = -1;
        Object var12_17 = null;
        for (String string2 : list) {
            if (string2 != null) continue;
            if (n3 >= 0) {
                methodHandle = c.b(methodHandle, 0, (MethodHandle)var12_18, 0, 1 + n3);
            }
            Class<?> clazz = object3[++n3];
            MethodHandle methodHandle2 = this.e(clazz);
        }
        if (n3 >= 0) {
            MethodHandle methodHandle3 = this.a((MethodHandle)var12_18, 0, l2);
            methodHandle = c.a(methodHandle, 0, methodHandle3, 1 + n3);
        } else {
            methodHandle = this.a(methodHandle, 0, l2);
        }
        if (methodHandleArray != null) {
            methodHandle = MethodHandles.filterArguments(methodHandle, 0, methodHandleArray);
        }
        return methodHandle;
    }

    private MethodHandle a(String string, Class<?> clazz) {
        if (string == null) {
            return this.yK.computeIfAbsent(clazz, this.yD);
        }
        return this.a(this.yJ.computeIfAbsent(clazz, this.yC), 3, string);
    }

    private MethodHandle e(Class<?> clazz) {
        return this.yL.computeIfAbsent(clazz, this.yE);
    }

    private MethodHandle dU() {
        return d.zb.bindTo(this.yF);
    }

    private MethodHandle dV() {
        return d.zc.bindTo(this.yF);
    }

    private MethodHandle L(String string) {
        MethodHandle methodHandle = d.zd.bindTo(this.yF);
        return this.a(methodHandle, 0, string);
    }

    private MethodHandle dE() {
        return d.ze.bindTo(this.yF);
    }

    private MethodHandle dF() {
        MethodHandle methodHandle = this.xY;
        if (methodHandle == null) {
            this.xY = methodHandle = d.yZ.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle dG() {
        MethodHandle methodHandle = this.xZ;
        if (methodHandle == null) {
            this.xZ = methodHandle = d.yX.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle dH() {
        MethodHandle methodHandle = this.ya;
        if (methodHandle == null) {
            this.ya = methodHandle = d.yY.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle dI() {
        MethodHandle methodHandle = this.yb;
        if (methodHandle == null) {
            this.yb = methodHandle = d.yV.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle dJ() {
        MethodHandle methodHandle = this.yc;
        if (methodHandle == null) {
            this.yc = methodHandle = d.yW.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle dK() {
        MethodHandle methodHandle = this.yd;
        if (methodHandle == null) {
            this.yd = methodHandle = d.yU.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle dL() {
        MethodHandle methodHandle = this.ye;
        if (methodHandle == null) {
            this.ye = methodHandle = d.yT.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle dM() {
        MethodHandle methodHandle = this.yf;
        if (methodHandle == null) {
            this.yf = methodHandle = d.za.bindTo(this.yF);
        }
        return methodHandle;
    }

    private MethodHandle i(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return this.dM();
        }
        if (clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
            return this.dI();
        }
        if (clazz == Long.TYPE) {
            return this.dJ();
        }
        if (clazz == Character.TYPE) {
            return this.dK();
        }
        if (clazz == Boolean.TYPE) {
            return this.dL();
        }
        if (clazz == Float.TYPE) {
            return this.dG();
        }
        if (clazz == Double.TYPE) {
            return this.dH();
        }
        throw new InternalError("Unhandled type for unary concatenation: " + String.valueOf(clazz));
    }

    private MethodHandle f(Class<?> clazz) {
        if (clazz == Object.class) {
            return this.dF();
        }
        if (clazz == Float.TYPE) {
            return this.dG();
        }
        if (clazz == Double.TYPE) {
            return this.dH();
        }
        return null;
    }

    public c(HostedGraphKit hostedGraphKit) {
        this.yF = hostedGraphKit;
        this.yJ = new HashMap();
        this.yK = new HashMap();
        this.yL = new HashMap();
    }

    private MethodHandle a(MethodHandle methodHandle, int n2, String string) {
        ConstantNode constantNode = this.yF.createObject((Object)string);
        return MethodHandles.insertArguments(methodHandle, n2, constantNode);
    }

    private MethodHandle a(MethodHandle methodHandle, int n2, long l2) {
        ConstantNode constantNode = this.yF.createLong(l2);
        return MethodHandles.insertArguments(methodHandle, n2, constantNode);
    }

    private static MethodHandle a(MethodHandle methodHandle, int n2, MethodHandle methodHandle2, int ... nArray) {
        try {
            methodHandle = (MethodHandle)yG.invoke(null, methodHandle, n2, methodHandle2, nArray);
            return methodHandle;
        }
        catch (Throwable throwable) {
            throw VMError.shouldNotReachHere((Throwable)throwable);
        }
    }

    private static MethodHandle b(MethodHandle methodHandle, int n2, MethodHandle methodHandle2, int ... nArray) {
        try {
            if (yH != null) {
                methodHandle = (MethodHandle)yH.invoke(null, methodHandle, n2, methodHandle2, nArray);
                return methodHandle;
            }
            MethodHandle methodHandle3 = MethodHandles.insertArguments(yI, 0, methodHandle, n2, methodHandle2, nArray);
            methodHandle3 = methodHandle3.asVarargsCollector(ValueNode[].class);
            return methodHandle3.asType(methodHandle.type());
        }
        catch (Throwable throwable) {
            throw VMError.shouldNotReachHere((Throwable)throwable);
        }
    }

    @a
    private static ValueNode filterArgumentsWithCombinerEmulator(MethodHandle methodHandle, int n2, MethodHandle methodHandle2, int[] nArray, ValueNode[] valueNodeArray) {
        try {
            ValueNode[] valueNodeArray2 = new ValueNode[nArray.length];
            for (int i2 = 0; i2 < valueNodeArray2.length; ++i2) {
                valueNodeArray2[i2] = valueNodeArray[nArray[i2]];
            }
            ValueNode valueNode = (ValueNode)methodHandle2.invokeWithArguments(Arrays.asList(valueNodeArray2));
            ValueNode[] valueNodeArray3 = Arrays.copyOf(valueNodeArray, valueNodeArray.length);
            valueNodeArray3[n2] = valueNode;
            return (ValueNode)methodHandle.invokeWithArguments(Arrays.asList(valueNodeArray3));
        }
        catch (Throwable throwable) {
            throw VMError.shouldNotReachHere((Throwable)throwable);
        }
    }

    static {
        yM = SubstrateStringConcatHelper.dW();
        if (JavaVersionUtil.JAVA_SPEC < 17) {
            yG = ReflectionUtil.lookupMethod(MethodHandles.class, (String)"foldArguments", (Class[])new Class[]{MethodHandle.class, Integer.TYPE, MethodHandle.class, int[].class});
            yH = null;
            MethodType methodType = MethodType.methodType(ValueNode.class, MethodHandle.class, Integer.TYPE, MethodHandle.class, int[].class, ValueNode[].class);
            try {
                yI = MethodHandles.lookup().findStatic(c.class, "filterArgumentsWithCombinerEmulator", methodType);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw VMError.shouldNotReachHere((Throwable)reflectiveOperationException);
            }
        } else {
            yG = ReflectionUtil.lookupMethod(MethodHandles.class, (String)"foldArgumentsWithCombiner", (Class[])new Class[]{MethodHandle.class, Integer.TYPE, MethodHandle.class, int[].class});
            yH = ReflectionUtil.lookupMethod(MethodHandles.class, (String)"filterArgumentsWithCombiner", (Class[])new Class[]{MethodHandle.class, Integer.TYPE, MethodHandle.class, int[].class});
            yI = null;
        }
    }
}

