/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.auximage;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapLayouter;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.LinearImageHeapLayouter;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.image.DisallowedImageHeapObjects;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageHeader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageObjectReplacer;
import com.oracle.svm.enterprise.core.auximage.aj;
import com.oracle.svm.enterprise.core.auximage.c;
import com.oracle.svm.enterprise.core.auximage.f;
import com.oracle.svm.enterprise.core.auximage.h;
import com.oracle.svm.enterprise.core.auximage.j;
import com.oracle.svm.enterprise.core.auximage.k;
import com.oracle.svm.enterprise.core.auximage.m;
import com.oracle.svm.enterprise.core.auximage.n;
import com.oracle.svm.enterprise.core.auximage.o;
import com.oracle.svm.enterprise.core.auximage.p;
import com.oracle.svm.enterprise.core.auximage.r;
import com.oracle.svm.enterprise.core.auximage.t;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.PinnedObjectSupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class g {
    private static final Object rl = new Object();
    private static final Object rm = new Object();

    private g() {
    }

    static ByteBuffer a(k k2, List<AuxiliaryImageObjectReplacer> list) {
        VMError.guarantee((boolean)((Boolean)SubstrateOptions.SpawnIsolates.getValue()), (String)"Needs compressed references to be enabled");
        IdentityHashCodeSupport.ensureInitialized();
        EnumSet<?> enumSet = g.cb();
        Object object = enumSet == null ? null : enumSet.clone();
        f f2 = new f(k2, (EnumSet<?>)object);
        UnsignedWord unsignedWord = VirtualMemoryProvider.get().getGranularity();
        AuxiliaryImageObjectReplacer[] auxiliaryImageObjectReplacerArray = list.toArray(new AuxiliaryImageObjectReplacer[0]);
        a a2 = new a(f2, unsignedWord, auxiliaryImageObjectReplacerArray);
        a2.enqueue();
        if (a2.re != null) {
            throw a2.re;
        }
        return a2.cc();
    }

    static EnumSet<?> cb() {
        EnumSet enumSet;
        if (!r.isSupportedInCurrentImage()) {
            return null;
        }
        SubstrateBackend substrateBackend = GraalSupport.getRuntimeConfig().getBackendForNormalMethod();
        SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures((Backend)substrateBackend);
        Architecture architecture = substrateBackend.getTarget().arch;
        if (architecture instanceof AMD64) {
            enumSet = ((AMD64)architecture).getFeatures();
        } else {
            assert (architecture instanceof AArch64);
            enumSet = ((AArch64)architecture).getFeatures();
        }
        return enumSet;
    }

    static boolean isInPrimaryImageHeap(Object object) {
        return HeapImpl.getImageHeapInfo().isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)object));
    }

    static int a(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.capacity();
        while (n2 % 8 != 0 && byteBuffer.get(n2 - 1) == 0) {
            --n2;
        }
        while (n2 >= 8 && byteBuffer.getLong(n2 - 8) == 0L) {
            n2 -= 8;
        }
        while (n2 >= 1 && byteBuffer.get(n2 - 1) == 0) {
            --n2;
        }
        return n2;
    }

    private static final class com.oracle.svm.enterprise.core.auximage.g$a
    extends JavaVMOperation {
        private final f rn;
        private final int ro;
        private final UnsignedWord rp;
        private final o rq = new o(this::h);
        private final m rr = new j();
        private final Map<Object, m> rs = new IdentityHashMap<Object, m>();
        private final Map<Object, Object> rt = new IdentityHashMap<Object, Object>();
        private final AuxiliaryImageObjectReplacer[] ru;
        private final Map<Object, Object> rv = new IdentityHashMap<Object, Object>();
        private final b rw = new b();
        private c rx;
        private byte[] ry;
        private int rz;
        private Pointer rA;
        private RuntimeException re;
        private final a rB = new a();

        com.oracle.svm.enterprise.core.auximage.g$a(f f2, UnsignedWord unsignedWord, AuxiliaryImageObjectReplacer[] auxiliaryImageObjectReplacerArray) {
            super(VMOperationInfos.get(com.oracle.svm.enterprise.core.auximage.g$a.class, (String)"Snapshot heap", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.rn = f2;
            this.ro = UnsignedUtils.safeToInt((UnsignedWord)unsignedWord);
            this.ru = Arrays.copyOf(auxiliaryImageObjectReplacerArray, auxiliaryImageObjectReplacerArray.length + 2);
            this.ru[auxiliaryImageObjectReplacerArray.length] = new p();
            this.ru[auxiliaryImageObjectReplacerArray.length + 1] = new t(f2);
            Word word = ((Word)Isolates.IMAGE_HEAP_END.get()).subtract((Word)Isolates.IMAGE_HEAP_BEGIN.get()).add(Heap.getHeap().getImageHeapOffsetInAddressSpace());
            UnsignedWord unsignedWord2 = UnsignedUtils.roundUp((UnsignedWord)word, (UnsignedWord)unsignedWord);
            UnsignedWord unsignedWord3 = UnsignedUtils.roundUp((UnsignedWord)WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment()), (UnsignedWord)unsignedWord);
            this.rp = UnsignedUtils.roundUp((UnsignedWord)unsignedWord2, (UnsignedWord)unsignedWord3);
        }

        ByteBuffer cc() {
            return ByteBuffer.wrap(this.ry, 0, this.rz);
        }

        protected void operate() {
            try {
                this.ca();
            }
            catch (RuntimeException runtimeException) {
                this.re = runtimeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ca() {
            Heap.getHeap().getGC().collectCompletely(GCCause.JavaLangSystemGC);
            Object object3 = new Object();
            int n2 = 0;
            try {
                Object object4;
                Stream.of(this.ru).forEach(auxiliaryImageObjectReplacer -> auxiliaryImageObjectReplacer.prologue(this.rw));
                for (Object iterator2 : this.rn.rf.rU.values()) {
                    this.a(object3, iterator2, true);
                }
                this.rq.a((Object object, Object object2) -> this.a(object, object2, true));
                Stream.of(this.ru).forEach(auxiliaryImageObjectReplacer -> auxiliaryImageObjectReplacer.epilogue(this.rw));
                this.rq.a((Object object, Object object2) -> VMError.guarantee((boolean)this.rt.containsKey(object2), (String)"No additional objects may become reachable after the epilogue"));
                assert (this.rq.ch());
                this.a(object3, this.rn, false);
                this.rq.a((Object object, Object object2) -> this.a(object, object2, false));
                assert (this.rq.ch());
                Object object5 = HeapImpl.usesImageHeapChunks() ? new ChunkedImageHeapLayouter(this.rn.rg, this.rp.rawValue(), 0) : new LinearImageHeapLayouter(this.rn.rg, this.rp.rawValue(), 0);
                this.rx = new c();
                Iterator<Object> n3 = this.rt.keySet().iterator();
                while (n3.hasNext()) {
                    object4 = n3.next();
                    if (g.isInPrimaryImageHeap(object4)) {
                        n3.remove();
                        continue;
                    }
                    assert (object4 != rl && object4 != rm) : "should not be discovered as objects";
                    assert (!this.rv.containsKey(object4)) : "must not contain replaced objects";
                    ClassInitializationInfo l2 = KnownIntrinsics.readHub((Object)object4).getClassInitializationInfo();
                    if (l2 != ClassInitializationInfo.NO_INITIALIZER_INFO_SINGLETON && l2 != ClassInitializationInfo.INITIALIZED_INFO_SINGLETON) {
                        assert (l2 != ClassInitializationInfo.FAILED_INFO_SINGLETON) : "should not be possible to allocate instances";
                        throw new UnsupportedFeatureException("Objects of classes which are initialized at runtime currently cannot be persisted: " + String.valueOf(object4.getClass()));
                    }
                    this.rx.a((ImageHeapLayouter)object5, object4);
                }
                int n4 = NumUtil.roundUp((int)com.oracle.svm.enterprise.core.auximage.b.bU(), (int)this.ro);
                object4 = object5.layout((ImageHeap)this.rx, this.ro);
                long l2 = object4.getImageHeapSize();
                this.rz = NumUtil.safeToInt((long)((long)n4 + l2));
                this.ry = new byte[this.rz];
                try (PinnedObject pinnedObject = PinnedObject.create((Object)this.ry);){
                    Pointer pointer = (Pointer)pinnedObject.addressOfArrayElement(0);
                    this.rA = pointer.add(n4);
                    UnsignedWord unsignedWord = (UnsignedWord)WordFactory.zero();
                    for (ImageHeapObject n42 : this.rx.getObjects()) {
                        this.a(n42);
                        if (n42.getObject() != this.rn) continue;
                        unsignedWord = WordFactory.unsigned((long)n42.getOffset());
                    }
                    VMError.guarantee((boolean)unsignedWord.notEqual(0));
                    ByteBuffer byteBuffer = CTypeConversion.asByteBuffer((PointerBase)this.rA, (int)NumUtil.safeToInt((long)l2));
                    object5.writeMetadata(byteBuffer, 0L);
                    this.rA = (Pointer)WordFactory.nullPointer();
                    int n5 = NumUtil.roundUp((int)g.a(byteBuffer), (int)this.ro);
                    assert ((long)n5 <= l2);
                    this.rz = n4 + n5;
                    assert (this.rz <= this.ry.length);
                    int n6 = com.oracle.svm.enterprise.core.auximage.b.a(pointer, n4, n5, l2);
                    AuxiliaryImageHeader auxiliaryImageHeader = (AuxiliaryImageHeader)pointer.add(n6);
                    auxiliaryImageHeader.setPrimaryImageId(AuxiliaryImageLoader.getPrimaryImageId());
                    auxiliaryImageHeader.setImageHeapToAuxImageHeapOffset(this.rp);
                    auxiliaryImageHeader.setImageHeapToOriginObjectOffset(unsignedWord);
                }
            }
            finally {
                h.a(object3, this.rt, n2);
            }
        }

        private m h(Object object) {
            if (object instanceof FillerObject) {
                return this.rr;
            }
            return this.rs.getOrDefault(object, this.rr);
        }

        private void a(Object object, Object object2, boolean bl2) {
            assert (object2 != null && object2 != rm && object2 != rl);
            if (this.rt.containsKey(object2)) {
                assert (!this.rv.containsKey(object2));
                return;
            }
            Object object3 = this.rv.get(object2);
            if (object3 == rm) {
                if (com.oracle.svm.enterprise.core.auximage.g$a.c(object, object2)) {
                    return;
                }
                try {
                    com.oracle.svm.enterprise.core.auximage.g$a.i(object2);
                }
                catch (UnsupportedFeatureException unsupportedFeatureException) {
                    throw this.a(object, unsupportedFeatureException);
                }
                throw VMError.shouldNotReachHere((String)"must be a disallowed object");
            }
            if (object3 != null) {
                if (object3 != rl && !this.rt.containsKey(object2)) {
                    this.a(object, object3, false);
                }
                return;
            }
            object3 = object2;
            if (bl2) {
                for (AuxiliaryImageObjectReplacer auxiliaryImageObjectReplacer : this.ru) {
                    if ((object3 = auxiliaryImageObjectReplacer.replace(object3, this.rw)) != null) continue;
                    object3 = rl;
                    break;
                }
            }
            try {
                com.oracle.svm.enterprise.core.auximage.g$a.i(object3);
            }
            catch (UnsupportedFeatureException unsupportedFeatureException) {
                if (com.oracle.svm.enterprise.core.auximage.g$a.c(object, object3)) {
                    object3 = rm;
                }
                throw this.a(object, unsupportedFeatureException);
            }
            this.b(object2, object3);
            if (object3 == rl || object3 == rm) {
                return;
            }
            this.rt.putIfAbsent(object3, object);
            if (!g.isInPrimaryImageHeap(object3)) {
                this.rq.l(object3);
            }
        }

        private UnsupportedFeatureException a(Object object, UnsupportedFeatureException unsupportedFeatureException) {
            f f2 = this.rn;
            Object object2 = object;
            StringBuilder stringBuilder = new StringBuilder();
            while (object2 != null && object2 != f2) {
                stringBuilder.append(System.lineSeparator()).append("       <- ").append(object2.getClass().getName());
                if (object2 instanceof aj) {
                    stringBuilder.append(" root-name: ").append(((aj)object2).sn.getName());
                }
                object2 = this.rt.get(object2);
            }
            if (stringBuilder.length() > 0) {
                throw new UnsupportedFeatureException(String.format("%s%n    Path to root object: %s", unsupportedFeatureException.getMessage(), stringBuilder.toString()), (Throwable)unsupportedFeatureException);
            }
            throw unsupportedFeatureException;
        }

        private static void i(Object object2) throws UnsupportedFeatureException {
            DisallowedImageHeapObjects.check((Object)object2, (string, object, string2) -> {
                throw new UnsupportedFeatureException(string);
            });
            if (((PinnedObjectSupport)ImageSingletons.lookup(PinnedObjectSupport.class)).isPinned(object2)) {
                throw new UnsupportedFeatureException("Object is pinned, but persisting and loading would move it: " + String.valueOf(object2));
            }
            if (MonitorSupport.singleton().isLockedByAnyThread(object2)) {
                throw new UnsupportedFeatureException("Object is locked, so some state might be unsafe to persist: " + String.valueOf(object2));
            }
        }

        private void b(Object object, Object object2) {
            if (object2 != object) {
                com.oracle.svm.enterprise.core.auximage.g$a.i(object2);
                if (this.rv.containsKey(object2)) {
                    throw new IllegalArgumentException("Replacement object has itself been replaced before");
                }
                Object object3 = this.rv.putIfAbsent(object, object2);
                if (object3 != null) {
                    throw new IllegalArgumentException("Object has been replaced before");
                }
            }
        }

        private static boolean c(Object object, Object object2) {
            return object instanceof Reference && ReferenceInternals.getReferent((Reference)((Reference)object)) == object2;
        }

        private void a(ImageHeapObject imageHeapObject) {
            UnsignedWord unsignedWord = WordFactory.unsigned((long)imageHeapObject.getOffset()).subtract(this.rp);
            this.a(this.h(imageHeapObject.getObject()), imageHeapObject, unsignedWord, System.identityHashCode(imageHeapObject.getObject()));
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while inspecting an object.")
        private void a(m m2, ImageHeapObject imageHeapObject, UnsignedWord unsignedWord, int n2) {
            Object object = imageHeapObject.getObject();
            Pointer pointer = this.rA.add(unsignedWord);
            UnsignedWord unsignedWord2 = LayoutEncoding.getMomentarySizeFromObject((Object)object);
            JavaMemoryUtil.copy((Pointer)Word.objectToUntrackedPointer((Object)object), (Pointer)pointer, (UnsignedWord)unsignedWord2);
            DynamicHub dynamicHub = ObjectHeader.readDynamicHubFromObject((Object)object);
            Word word = Word.objectToUntrackedPointer((Object)dynamicHub).subtract((UnsignedWord)KnownIntrinsics.heapBase());
            ObjectHeader objectHeader = Heap.getHeap().getObjectHeader();
            long l2 = objectHeader.encodeAsImageHeapObjectHeader(imageHeapObject, word.rawValue());
            objectHeader.initializeHeaderOfNewObject(pointer, (Word)WordFactory.unsigned((long)l2));
            pointer.writeInt(LayoutEncoding.getOptionalIdentityHashOffset((Object)object), n2);
            this.rB.f(unsignedWord);
            m2.a(object, this.rB);
        }

        private void a(UnsignedWord unsignedWord, long l2) {
            switch (ConfigurationValues.getObjectLayout().getReferenceSize()) {
                case 4: {
                    this.rA.writeInt((WordBase)unsignedWord, NumUtil.safeToInt((long)l2));
                    break;
                }
                case 8: {
                    this.rA.writeLong((WordBase)unsignedWord, l2);
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
        }

        final class b
        implements AuxiliaryImageObjectReplacer.EpilogueAccess,
        com.oracle.svm.enterprise.core.auximage.g$b {
            b() {
            }

            @Override
            public void replaceLate(Object object, Object object2) {
                if (object == object2) {
                    return;
                }
                if (a.this.rv.containsValue(object)) {
                    throw new IllegalArgumentException("Object that has replaced another object cannot itself be replaced");
                }
                a.this.b(object, object2);
                Object object3 = a.this.rt.remove(object);
                boolean bl2 = object3 != null;
                boolean bl3 = a.this.rt.containsKey(object2);
                if (bl2 && !bl3) {
                    a.this.a(object3, object2, false);
                }
            }

            @Override
            public void b(Object object, Object object2, boolean bl2) {
                a.this.a(object2, object, bl2);
            }

            @Override
            public void a(Object object, m m2) {
                if (object instanceof FillerObject) {
                    throw new IllegalArgumentException("Cannot register walker for filler objects");
                }
                m m3 = a.this.rs.putIfAbsent(object, m2);
                if (m3 != null) {
                    throw new IllegalArgumentException("Custom walker has been registered before");
                }
            }
        }

        private final class a
        implements n {
            private UnsignedWord rC;

            private a() {
            }

            void f(UnsignedWord unsignedWord) {
                this.rC = unsignedWord;
            }

            @Override
            public boolean a(Object object, int n2, boolean bl2, Object object2) {
                return this.a(object, n2, bl2, object2, false);
            }

            @Override
            public boolean b(Object object, int n2, boolean bl2, Object object2) {
                return this.a(object, n2, bl2, object2, true);
            }

            @Override
            public boolean c(Object object, int n2, boolean bl2, Object object2) {
                return this.a(object, n2, bl2);
            }

            @Override
            public boolean d(Object object, int n2, boolean bl2, Object object2) {
                return this.a(object, n2, bl2);
            }

            private boolean a(Object object, int n2, boolean bl2, Object object2, boolean bl3) {
                if (object2 == null) {
                    if (!bl2) {
                        this.a(object, n2, bl2);
                    }
                    return true;
                }
                Object object3 = this.a(a.this.rv, object2, object2);
                if (object3 == rl) {
                    return this.a(object, n2, bl2);
                }
                if (object3 == rm) {
                    VMError.guarantee((boolean)bl3);
                    return this.a(object, n2, bl2);
                }
                if (!bl2 || object2 != object3 || !g.isInPrimaryImageHeap(object3)) {
                    assert (object2 == object3 || !(object instanceof ImageHeapInfo)) : "ImageHeapInfo range information must be final";
                    assert (bl2 || object.getClass() == StoredContinuation.class) : "Regular heap references must be compressed";
                    Object object4 = g.isInPrimaryImageHeap(object3) ? Word.objectToUntrackedPointer((Object)object3).subtract((UnsignedWord)KnownIntrinsics.heapBase()) : WordFactory.unsigned((long)a.this.rx.g(object3).getOffset());
                    UnsignedWord unsignedWord = object4.unsignedShiftRight(ReferenceAccess.singleton().getCompressEncoding().getShift());
                    a.this.a(this.rC.add(n2), unsignedWord.rawValue());
                }
                return true;
            }

            boolean a(Object object, int n2, boolean bl2) {
                assert (bl2 || object.getClass() == StoredContinuation.class) : "Regular heap references must be compressed";
                a.this.a(this.rC.add(n2), 0L);
                return true;
            }

            @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="This doesn't allocate except for assertions/exceptions which cause us to abort.")
            private <K, V> V a(Map<K, V> map, K k2, V v2) {
                V v3 = map.get(k2);
                return v3 != null ? v3 : v2;
            }
        }
    }

    static interface b {
        public void b(Object var1, Object var2, boolean var3);

        public void a(Object var1, m var2);
    }
}

