/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.AbstractCommittedMemoryProvider;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.al;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class EnterpriseAddressRangeCommittedMemoryProvider
extends AbstractCommittedMemoryProvider {
    private final c oB = (Boolean)SubstrateGCOptions.VerboseGC.getValue() != false ? new b() : new a();
    private final VMMutex oC = new VMMutex("freeList");
    private final UnsignedWord oD = HeapParameters.getLargeArrayThreshold();
    private FreeListNode oE;
    private long oF;
    private FreeListNode oG;
    private long oH;
    private UnsignedWord oI;
    private static final OutOfMemoryError oJ = new OutOfMemoryError("Could not allocate node for free list");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public EnterpriseAddressRangeCommittedMemoryProvider() {
    }

    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer wordPointer, CEntryPointCreateIsolateParameters cEntryPointCreateIsolateParameters) {
        Pointer pointer;
        WordPointer wordPointer2;
        UnsignedWord unsignedWord;
        int n2;
        UnsignedWord unsignedWord2 = ReferenceAccess.singleton().getAddressSpaceSize();
        CCharPointer cCharPointer = (CCharPointer)WordFactory.nullPointer();
        UnsignedWord unsignedWord3 = (UnsignedWord)WordFactory.zero();
        if (cEntryPointCreateIsolateParameters.isNonNull()) {
            if (cEntryPointCreateIsolateParameters.version() < 0 || cEntryPointCreateIsolateParameters.version() > 4) {
                return 10;
            }
            if (cEntryPointCreateIsolateParameters.version() >= 2) {
                cCharPointer = cEntryPointCreateIsolateParameters.auxiliaryImagePath();
                unsignedWord3 = cEntryPointCreateIsolateParameters.auxiliaryImageReservedSpaceSize();
            }
            if (cEntryPointCreateIsolateParameters.version() >= 1 && cEntryPointCreateIsolateParameters.reservedSpaceSize().notEqual(0)) {
                unsignedWord2 = UnsignedUtils.min((UnsignedWord)cEntryPointCreateIsolateParameters.reservedSpaceSize(), (UnsignedWord)ReferenceAccess.singleton().getAddressSpaceSize());
            }
        }
        if (unsignedWord3.equal((UnsignedWord)WordFactory.zero())) {
            unsignedWord3 = al.getReservedAuxiliaryImageBytes();
        }
        if ((n2 = this.a(unsignedWord2, unsignedWord = WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment()), cEntryPointCreateIsolateParameters, wordPointer2 = (WordPointer)StackValue.get(WordPointer.class))) != 0) {
            return n2;
        }
        Pointer pointer2 = (Pointer)wordPointer2.read();
        if (((Boolean)SubstrateOptions.SpawnIsolates.getValue()).booleanValue()) {
            WordPointer wordPointer3 = (WordPointer)StackValue.get(WordPointer.class);
            int n3 = ImageHeapProvider.get().initialize(pointer2, unsignedWord2, wordPointer, wordPointer3);
            if (n3 != 0) {
                this.a(pointer2, unsignedWord2);
                return n3;
            }
            CEntryPointSnippets.setHeapBase((PointerBase)Isolates.getHeapBase((Isolate)((Isolate)wordPointer.read())));
            pointer = (Pointer)wordPointer3.read();
            Pointer pointer3 = PointerUtils.roundUp((PointerBase)((PointerBase)wordPointer3.read()), (UnsignedWord)this.getGranularity());
            UnsignedWord unsignedWord4 = unsignedWord2.subtract((UnsignedWord)pointer3.subtract((UnsignedWord)pointer2));
            if (unsignedWord3.aboveThan(0)) {
                if (unsignedWord3.aboveThan(unsignedWord4)) {
                    this.a(pointer2, unsignedWord2);
                    return 17;
                }
                unsignedWord4 = unsignedWord3;
            }
            if (cCharPointer.isNonNull()) {
                WordPointer wordPointer4 = (WordPointer)StackValue.get(WordPointer.class);
                WordPointer wordPointer5 = (WordPointer)StackValue.get(WordPointer.class);
                n3 = AuxiliaryImageProvider.get().loadAuxiliaryImage(pointer3, unsignedWord4, cCharPointer, wordPointer4, wordPointer5);
                if (n3 != 0) {
                    this.a(pointer2, unsignedWord2);
                    return n3;
                }
                pointer = (Pointer)wordPointer5.read();
            }
            if (unsignedWord3.aboveThan(0)) {
                AuxiliaryImageLoader.setAuxImageReservedSpace(pointer3, unsignedWord3);
                pointer = pointer3.add(unsignedWord3);
            }
            pointer = PointerUtils.roundUp((PointerBase)pointer, (UnsignedWord)this.getGranularity());
        } else {
            int n4 = EnterpriseAddressRangeCommittedMemoryProvider.protectSingleIsolateImageHeap();
            if (n4 != 0) {
                return n4;
            }
            wordPointer.write((WordBase)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL);
            pointer = pointer2;
        }
        return EnterpriseAddressRangeCommittedMemoryProvider.a(unsignedWord2, pointer2, pointer);
    }

    @NeverInline(value="Ensure a newly looked up value of EnterpriseAddressRangeCommittedMemoryProvider is used now that the image heap is initialized")
    @Uninterruptible(reason="Called from uninterruptible code.")
    private static int a(UnsignedWord unsignedWord, Pointer pointer, Pointer pointer2) {
        EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider = EnterpriseAddressRangeCommittedMemoryProvider.bu();
        enterpriseAddressRangeCommittedMemoryProvider.oI = unsignedWord;
        Pointer pointer3 = pointer.add(unsignedWord).subtract((UnsignedWord)pointer2);
        enterpriseAddressRangeCommittedMemoryProvider.b(pointer2, (UnsignedWord)pointer3);
        return 0;
    }

    @Uninterruptible(reason="Still being initialized.")
    protected int a(UnsignedWord unsignedWord, UnsignedWord unsignedWord2, CEntryPointCreateIsolateParameters cEntryPointCreateIsolateParameters, WordPointer wordPointer) {
        Pointer pointer = (Boolean)al.GraalOS.getValue() != false ? com.oracle.svm.enterprise.core.b.singleton().a(unsignedWord, unsignedWord2) : VirtualMemoryProvider.get().reserve(unsignedWord, unsignedWord2, false);
        if (pointer.isNonNull()) {
            wordPointer.write((WordBase)pointer);
            return 0;
        }
        return 801;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void a(Pointer pointer, UnsignedWord unsignedWord) {
        VirtualMemoryProvider.get().free((PointerBase)pointer, unsignedWord);
    }

    @NeverInline(value="Prevent optimizations to force loading a new instance reference.")
    @Uninterruptible(reason="Called from uninterruptible code.")
    private static EnterpriseAddressRangeCommittedMemoryProvider bu() {
        return (EnterpriseAddressRangeCommittedMemoryProvider)CommittedMemoryProvider.get();
    }

    @Uninterruptible(reason="During setup, but the heap is safe to access.")
    private void b(Pointer pointer, UnsignedWord unsignedWord) {
        this.oG = EnterpriseAddressRangeCommittedMemoryProvider.c(pointer, unsignedWord);
        this.oH = 1L;
        this.oE = this.oG;
        this.oF = 1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static FreeListNode c(Pointer pointer, UnsignedWord unsignedWord) {
        FreeListNode freeListNode = (FreeListNode)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).calloc(SizeOf.unsigned(FreeListNode.class));
        if (freeListNode.isNull()) {
            throw oJ;
        }
        freeListNode.setStart(pointer);
        freeListNode.setSize(unsignedWord);
        return freeListNode;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(FreeListNode freeListNode) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)freeListNode);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean a(UnsignedWord unsignedWord) {
        return unsignedWord.aboveOrEqual(this.oD);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer b(FreeListNode freeListNode) {
        return freeListNode.getStart().add(freeListNode.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(FreeListNode freeListNode, Pointer pointer, Pointer pointer2) {
        assert (pointer.isNull() == pointer2.isNull());
        if (pointer.isNonNull()) {
            assert (pointer.belowThan((UnsignedWord)pointer2));
            Pointer pointer3 = EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode);
            if (pointer.belowThan((UnsignedWord)pointer3) && pointer2.aboveThan((UnsignedWord)freeListNode.getStart())) {
                Pointer pointer4;
                Pointer pointer5 = pointer.aboveThan((UnsignedWord)freeListNode.getStart()) ? pointer : freeListNode.getStart();
                Pointer pointer6 = pointer4 = pointer2.belowThan((UnsignedWord)pointer3) ? pointer2 : pointer3;
                assert (freeListNode.getCommittedStart().isNull() == freeListNode.getCommittedEnd().isNull());
                if (freeListNode.getCommittedStart().isNull() || pointer5.belowThan((UnsignedWord)freeListNode.getCommittedStart())) {
                    freeListNode.setCommittedStart(pointer5);
                }
                if (freeListNode.getCommittedEnd().isNull() || pointer4.aboveThan((UnsignedWord)freeListNode.getCommittedEnd())) {
                    freeListNode.setCommittedEnd(pointer4);
                }
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void c(FreeListNode freeListNode) {
        Pointer pointer = freeListNode.getCommittedStart();
        Pointer pointer2 = freeListNode.getCommittedEnd();
        if (pointer.isNonNull()) {
            freeListNode.setCommittedStart((Pointer)WordFactory.nullPointer());
            freeListNode.setCommittedEnd((Pointer)WordFactory.nullPointer());
            EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode, pointer, pointer2);
        }
    }

    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        PointerBase pointerBase = Isolates.getHeapBase((Isolate)CurrentIsolate.getIsolate());
        FreeListNode freeListNode = this.oG;
        while (freeListNode.isNonNull()) {
            FreeListNode freeListNode2 = freeListNode.getUnusedNext();
            EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode);
            freeListNode = freeListNode2;
        }
        return this.a(pointerBase);
    }

    @Uninterruptible(reason="Tear-down in progress.")
    protected int a(PointerBase pointerBase) {
        if (VirtualMemoryProvider.get().free(pointerBase, this.oI) != 0) {
            return 19;
        }
        return 0;
    }

    public Pointer allocateAlignedChunk(UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
        return this.b(unsignedWord, unsignedWord2);
    }

    public Pointer allocateUnalignedChunk(UnsignedWord unsignedWord) {
        return this.b(unsignedWord, WordFactory.unsigned((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    private Pointer b(UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
        Pointer pointer = (Pointer)WordFactory.nullPointer();
        Pointer pointer2 = (Pointer)WordFactory.nullPointer();
        UnsignedWord unsignedWord3 = (UnsignedWord)WordFactory.zero();
        this.oC.lockNoTransitionUnspecifiedOwner();
        try {
            UnsignedWord unsignedWord4;
            FreeListNode freeListNode = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode2 = (FreeListNode)WordFactory.nullPointer();
            UnsignedWord unsignedWord5 = WordFactory.unsigned((long)-1L);
            FreeListNode freeListNode3 = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode4 = this.oE;
            while (freeListNode4.isNonNull()) {
                unsignedWord4 = freeListNode4.getSize();
                if (unsignedWord4.aboveOrEqual(unsignedWord) && unsignedWord4.belowThan(unsignedWord5)) {
                    Pointer pointer3 = PointerUtils.roundUp((PointerBase)freeListNode4.getStart(), (UnsignedWord)unsignedWord2).subtract((UnsignedWord)freeListNode4.getStart());
                    if (unsignedWord4.subtract(unsignedWord).aboveOrEqual((UnsignedWord)pointer3)) {
                        freeListNode2 = freeListNode3;
                        freeListNode = freeListNode4;
                        unsignedWord5 = unsignedWord4;
                        if (unsignedWord4.equal(unsignedWord)) break;
                    }
                }
                freeListNode3 = freeListNode4;
                freeListNode4 = freeListNode4.getAllocNext();
            }
            if (freeListNode.isNull()) {
                freeListNode3 = (Pointer)WordFactory.nullPointer();
                return freeListNode3;
            }
            freeListNode3 = this.getGranularity();
            freeListNode4 = freeListNode.getStart();
            pointer = PointerUtils.roundUp((PointerBase)freeListNode4, (UnsignedWord)unsignedWord2);
            pointer2 = PointerUtils.roundDown((PointerBase)pointer, (UnsignedWord)freeListNode3);
            unsignedWord4 = PointerUtils.roundUp((PointerBase)pointer.add(unsignedWord), (UnsignedWord)freeListNode3);
            unsignedWord3 = unsignedWord4.subtract((UnsignedWord)pointer2);
            assert (pointer2.aboveOrEqual((UnsignedWord)freeListNode4) && unsignedWord4.belowOrEqual((UnsignedWord)freeListNode4.add(unsignedWord5)));
            int n2 = 3;
            Pointer pointer4 = VirtualMemoryProvider.get().commit((PointerBase)pointer2, unsignedWord3, 3);
            if (pointer4.isNull()) {
                Pointer pointer5 = (Pointer)WordFactory.nullPointer();
                return pointer5;
            }
            VMError.guarantee((boolean)pointer4.equal((UnsignedWord)pointer2), (String)"Must not be mapped anywhere else.");
            Pointer pointer6 = pointer2.subtract((UnsignedWord)freeListNode4);
            Pointer pointer7 = freeListNode4.add(unsignedWord5).subtract(unsignedWord4);
            if (this.a((UnsignedWord)pointer6)) {
                freeListNode.setSize((UnsignedWord)pointer6);
                if (pointer7.aboveThan(0)) {
                    FreeListNode freeListNode5 = EnterpriseAddressRangeCommittedMemoryProvider.c((Pointer)unsignedWord4, (UnsignedWord)pointer7);
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode5, freeListNode.getCommittedStart(), freeListNode.getCommittedEnd());
                    if (freeListNode.getUnusedNext().isNonNull()) {
                        freeListNode5.setUnusedNext(freeListNode.getUnusedNext());
                        freeListNode.getUnusedNext().setUnusedPrevious(freeListNode5);
                    }
                    freeListNode.setUnusedNext(freeListNode5);
                    freeListNode5.setUnusedPrevious(freeListNode);
                    ++this.oH;
                    if (this.a((UnsignedWord)pointer7)) {
                        freeListNode5.setAllocNext(freeListNode.getAllocNext());
                        freeListNode.setAllocNext(freeListNode5);
                        ++this.oF;
                    }
                }
                EnterpriseAddressRangeCommittedMemoryProvider.c(freeListNode);
            } else if (this.a((UnsignedWord)pointer7)) {
                freeListNode.setStart((Pointer)unsignedWord4);
                freeListNode.setSize((UnsignedWord)pointer7);
                if (pointer6.aboveThan(0)) {
                    FreeListNode freeListNode6 = EnterpriseAddressRangeCommittedMemoryProvider.c((Pointer)freeListNode4, (UnsignedWord)pointer6);
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode6, freeListNode.getCommittedStart(), freeListNode.getCommittedEnd());
                    freeListNode6.setUnusedPrevious(freeListNode.getUnusedPrevious());
                    freeListNode6.setUnusedNext(freeListNode);
                    if (freeListNode == this.oG) {
                        this.oG = freeListNode6;
                    } else {
                        freeListNode.getUnusedPrevious().setUnusedNext(freeListNode6);
                    }
                    freeListNode.setUnusedPrevious(freeListNode6);
                    ++this.oH;
                }
                EnterpriseAddressRangeCommittedMemoryProvider.c(freeListNode);
            } else {
                if (freeListNode == this.oE) {
                    this.oE = freeListNode.getAllocNext();
                } else {
                    freeListNode2.setAllocNext(freeListNode.getAllocNext());
                }
                freeListNode.setAllocNext((FreeListNode)WordFactory.nullPointer());
                --this.oF;
                if (pointer6.aboveThan(0) && pointer7.aboveThan(0)) {
                    freeListNode.setSize((UnsignedWord)pointer6);
                    FreeListNode freeListNode7 = EnterpriseAddressRangeCommittedMemoryProvider.c((Pointer)unsignedWord4, (UnsignedWord)pointer7);
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode7, freeListNode.getCommittedStart(), freeListNode.getCommittedEnd());
                    EnterpriseAddressRangeCommittedMemoryProvider.c(freeListNode);
                    freeListNode7.setUnusedPrevious(freeListNode);
                    if (freeListNode.getUnusedNext().isNonNull()) {
                        freeListNode7.setUnusedNext(freeListNode.getUnusedNext());
                        freeListNode.getUnusedNext().setUnusedPrevious(freeListNode7);
                    }
                    freeListNode.setUnusedNext(freeListNode7);
                    ++this.oH;
                } else if (pointer6.aboveThan(0)) {
                    freeListNode.setSize((UnsignedWord)pointer6);
                    EnterpriseAddressRangeCommittedMemoryProvider.c(freeListNode);
                } else if (pointer7.aboveThan(0)) {
                    freeListNode.setStart((Pointer)unsignedWord4);
                    freeListNode.setSize((UnsignedWord)pointer7);
                    EnterpriseAddressRangeCommittedMemoryProvider.c(freeListNode);
                } else {
                    if (freeListNode.getUnusedNext().isNonNull()) {
                        freeListNode.getUnusedNext().setUnusedPrevious(freeListNode.getUnusedPrevious());
                    }
                    if (freeListNode == this.oG) {
                        this.oG = freeListNode.getUnusedNext();
                    } else {
                        freeListNode.getUnusedPrevious().setUnusedNext(freeListNode.getUnusedNext());
                    }
                    --this.oH;
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode);
                    freeListNode = (FreeListNode)WordFactory.nullPointer();
                }
            }
        }
        finally {
            this.oC.unlockNoTransitionUnspecifiedOwner();
        }
        this.oB.b(unsignedWord3);
        return pointer;
    }

    public boolean areUnalignedChunksZeroed() {
        return Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase pointerBase, UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
        this.a(pointerBase, unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase pointerBase, UnsignedWord unsignedWord) {
        this.a(pointerBase, unsignedWord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    private void a(PointerBase pointerBase, UnsignedWord unsignedWord) {
        Pointer pointer;
        this.oC.lockNoTransition();
        try {
            FreeListNode freeListNode;
            FreeListNode freeListNode2;
            UnsignedWord unsignedWord2 = this.getGranularity();
            Pointer pointer2 = PointerUtils.roundDown((PointerBase)pointerBase, (UnsignedWord)unsignedWord2);
            FreeListNode freeListNode3 = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode4 = this.oE;
            while (freeListNode4.isNonNull() && freeListNode4.getStart().belowThan((UnsignedWord)pointer2)) {
                freeListNode3 = freeListNode4;
                freeListNode4 = freeListNode4.getAllocNext();
            }
            FreeListNode freeListNode5 = freeListNode3;
            FreeListNode freeListNode6 = freeListNode2 = freeListNode5.isNull() ? this.oG : freeListNode5.getUnusedNext();
            while (freeListNode2.isNonNull() && freeListNode2.getStart().belowThan((UnsignedWord)pointer2)) {
                freeListNode5 = freeListNode2;
                freeListNode2 = freeListNode2.getUnusedNext();
            }
            Pointer pointer3 = PointerUtils.roundUp((PointerBase)pointer2.add(unsignedWord), (UnsignedWord)unsignedWord2);
            pointer = pointer3.subtract((UnsignedWord)pointer2);
            assert (freeListNode5.isNull() || pointer2.aboveOrEqual((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode5)));
            assert (freeListNode2.isNull() || pointer2.add((UnsignedWord)pointer).belowOrEqual((UnsignedWord)freeListNode2.getStart()));
            if (freeListNode5.isNonNull() && EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode5).equal((UnsignedWord)pointer2)) {
                freeListNode5.setSize(freeListNode5.getSize().add((UnsignedWord)pointer));
                if (freeListNode2.isNonNull() && pointer3.equal((UnsignedWord)freeListNode2.getStart())) {
                    freeListNode5.setSize(freeListNode5.getSize().add(freeListNode2.getSize()));
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode5, freeListNode2.getCommittedStart(), freeListNode2.getCommittedEnd());
                    if (freeListNode2.getUnusedNext().isNonNull()) {
                        freeListNode2.getUnusedNext().setUnusedPrevious(freeListNode5);
                    }
                    freeListNode5.setUnusedNext(freeListNode2.getUnusedNext());
                    if (freeListNode4 == freeListNode2) {
                        if (freeListNode4 == this.oE) {
                            this.oE = freeListNode4.getAllocNext();
                        } else {
                            freeListNode3.setAllocNext(freeListNode4.getAllocNext());
                        }
                        freeListNode4 = freeListNode4.getAllocNext();
                        --this.oF;
                    }
                    --this.oH;
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode2);
                    freeListNode2 = (FreeListNode)WordFactory.nullPointer();
                }
                freeListNode = freeListNode5;
            } else if (freeListNode2.isNonNull() && pointer3.equal((UnsignedWord)freeListNode2.getStart())) {
                freeListNode2.setStart(pointer2);
                freeListNode2.setSize(freeListNode2.getSize().add((UnsignedWord)pointer));
                freeListNode = freeListNode2;
            } else {
                FreeListNode freeListNode7 = EnterpriseAddressRangeCommittedMemoryProvider.c(pointer2, (UnsignedWord)pointer);
                freeListNode7.setUnusedPrevious(freeListNode5);
                freeListNode7.setUnusedNext(freeListNode2);
                if (freeListNode2 == this.oG) {
                    this.oG = freeListNode7;
                } else {
                    freeListNode5.setUnusedNext(freeListNode7);
                }
                if (freeListNode2.isNonNull()) {
                    freeListNode2.setUnusedPrevious(freeListNode7);
                }
                ++this.oH;
                freeListNode = freeListNode7;
            }
            EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode, pointer2, pointer3);
            if (this.a(freeListNode.getSize()) && freeListNode != freeListNode3 && freeListNode != freeListNode4) {
                freeListNode.setAllocNext(freeListNode4);
                if (freeListNode4 == this.oE) {
                    this.oE = freeListNode;
                } else {
                    freeListNode3.setAllocNext(freeListNode);
                }
                ++this.oF;
            }
        }
        finally {
            this.oC.unlock();
        }
        this.oB.c((UnsignedWord)pointer);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in this code.")
    public void beforeGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
        this.oC.assertIsNotLocked("Must not be locked -- is mutator code holding the lock?");
        if (((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            this.bv();
        }
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in this code.")
    public void afterGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
        this.oC.assertIsNotLocked("Must not be locked");
        FreeListNode freeListNode = this.oG;
        while (freeListNode.isNonNull()) {
            Pointer pointer = freeListNode.getCommittedStart();
            if (pointer.isNonNull()) {
                assert (pointer.aboveOrEqual((UnsignedWord)freeListNode.getStart()) && freeListNode.getCommittedEnd().belowOrEqual((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)));
                Pointer pointer2 = freeListNode.getCommittedEnd().subtract((UnsignedWord)pointer);
                if (VirtualMemoryProvider.get().uncommit((PointerBase)pointer, (UnsignedWord)pointer2) != 0) {
                    Log.log().string("Uncommitting ").unsigned((WordBase)pointer2).string("B of unused memory at ").hex((WordBase)pointer).string("failed").newline();
                    VMError.shouldNotReachHere();
                }
                freeListNode.setCommittedStart((Pointer)WordFactory.nullPointer());
                freeListNode.setCommittedEnd((Pointer)WordFactory.nullPointer());
                this.oB.d((UnsignedWord)pointer2);
            }
            freeListNode = freeListNode.getUnusedNext();
        }
        if (((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            this.bv();
        }
        this.oB.bz();
    }

    private void bv() {
        FreeListNode freeListNode;
        int n2 = 0;
        FreeListNode freeListNode2 = (FreeListNode)WordFactory.nullPointer();
        FreeListNode freeListNode3 = this.oG;
        while (freeListNode3.isNonNull()) {
            VMError.guarantee((boolean)freeListNode3.getUnusedPrevious().equal((ComparableWord)freeListNode2), (String)"Unused list previous-next node linkage must be consistent");
            VMError.guarantee((freeListNode2.isNull() || freeListNode3.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode2)) ? 1 : 0) != 0, (String)"Unused blocks must not overlap");
            ++n2;
            freeListNode2 = freeListNode3;
            freeListNode3 = freeListNode3.getUnusedNext();
        }
        VMError.guarantee(((long)n2 == this.oH ? 1 : 0) != 0, (String)"Number of unused list nodes must match recorded count");
        int n3 = 0;
        if (freeListNode2.isNonNull()) {
            FreeListNode freeListNode4 = freeListNode2;
            ++n3;
            freeListNode = freeListNode4.getUnusedPrevious();
            while (freeListNode.isNonNull()) {
                VMError.guarantee((boolean)freeListNode.getUnusedNext().equal((ComparableWord)freeListNode4), (String)"Unused list previous-next node linkage must be consistent");
                VMError.guarantee((boolean)freeListNode4.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)), (String)"Unused blocks must not overlap");
                ++n3;
                freeListNode4 = freeListNode;
                freeListNode = freeListNode.getUnusedPrevious();
            }
            VMError.guarantee((freeListNode4 == this.oG ? 1 : 0) != 0, (String)"Unused list reverse iteration must terminate at list head");
        }
        VMError.guarantee((n2 == n3 ? 1 : 0) != 0, (String)"Number of unused list nodes must be the same for forward and reverse iteration");
        int n4 = 0;
        freeListNode = (FreeListNode)WordFactory.nullPointer();
        FreeListNode freeListNode5 = this.oE;
        while (freeListNode5.isNonNull()) {
            VMError.guarantee((freeListNode.isNull() || freeListNode5.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)) ? 1 : 0) != 0, (String)"Allocatable blocks must not overlap");
            VMError.guarantee((boolean)this.a(freeListNode5.getSize()), (String)"Allocatable blocks must satisfy minimum allocatable size");
            ++n4;
            freeListNode = freeListNode5;
            freeListNode5 = freeListNode5.getAllocNext();
        }
        VMError.guarantee((this.oE.isNull() || this.oG.equal((ComparableWord)this.oE) || EnterpriseAddressRangeCommittedMemoryProvider.b(this.oG).belowOrEqual((UnsignedWord)this.oE.getStart()) ? 1 : 0) != 0, (String)"First unused block must start before first allocatable block, or be allocatable itself");
        VMError.guarantee((n4 <= n2 ? 1 : 0) != 0, (String)"Allocation list must not be longer than unused list");
        VMError.guarantee(((long)n4 == this.oF ? 1 : 0) != 0, (String)"Number of allocation list nodes must match recorded count");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long bw() {
        return this.oF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long bx() {
        return this.oH;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord by() {
        return this.oI;
    }

    private final class b
    implements c {
        long oK;
        long oL;
        long oM;
        long oN;
        long oO;
        long oP;
        long oQ;
        long oR;

        private b() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        void update() {
            this.oK = EnterpriseAddressRangeCommittedMemoryProvider.this.bw() > this.oK ? EnterpriseAddressRangeCommittedMemoryProvider.this.bw() : this.oK;
            this.oL = EnterpriseAddressRangeCommittedMemoryProvider.this.bx() > this.oL ? EnterpriseAddressRangeCommittedMemoryProvider.this.bx() : this.oL;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void b(UnsignedWord unsignedWord) {
            ++this.oM;
            this.oN += unsignedWord.rawValue();
            this.update();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void c(UnsignedWord unsignedWord) {
            ++this.oO;
            this.oP += unsignedWord.rawValue();
            this.update();
        }

        @Override
        public void d(UnsignedWord unsignedWord) {
            ++this.oQ;
            this.oR += unsignedWord.rawValue();
            this.update();
        }

        @Override
        public void bz() {
            Log.log().string("EnterpriseAddressRangeCommittedMemoryProvider: ").unsigned(this.oM).string(" allocs for a total of ").unsigned(this.oN / 1024L).string("K and ").unsigned(this.oO).string(" frees for a total of ").unsigned(this.oP / 1024L).string("K and ").unsigned(this.oQ).string(" uncommits for a total of ").unsigned(this.oR / 1024L).string("K and ").string("an alloc list length of ").unsigned(EnterpriseAddressRangeCommittedMemoryProvider.this.bw()).string(" (longest was ").unsigned(this.oK).string(") and ").string("an unused list length of ").unsigned(EnterpriseAddressRangeCommittedMemoryProvider.this.bx()).string(" (longest was ").unsigned(this.oL).string(") ").newline();
        }
    }

    private static final class a
    implements c {
        private a() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void b(UnsignedWord unsignedWord) {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void c(UnsignedWord unsignedWord) {
        }

        @Override
        public void d(UnsignedWord unsignedWord) {
        }

        @Override
        public void bz() {
        }
    }

    private static interface c {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void b(UnsignedWord var1);

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void c(UnsignedWord var1);

        public void d(UnsignedWord var1);

        public void bz();
    }

    @RawStructure
    private static interface FreeListNode
    extends PointerBase {
        @RawField
        public Pointer getStart();

        @RawField
        public void setStart(Pointer var1);

        @RawField
        public UnsignedWord getSize();

        @RawField
        public void setSize(UnsignedWord var1);

        @RawField
        public Pointer getCommittedStart();

        @RawField
        public void setCommittedStart(Pointer var1);

        @RawField
        public Pointer getCommittedEnd();

        @RawField
        public void setCommittedEnd(Pointer var1);

        @RawField
        public FreeListNode getAllocNext();

        @RawField
        public void setAllocNext(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedPrevious();

        @RawField
        public void setUnusedPrevious(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedNext();

        @RawField
        public void setUnusedNext(FreeListNode var1);
    }
}

