/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.NodeInfo;
import ai.onnxruntime.OnnxModelMetadata;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtLoggingLevel;
import ai.onnxruntime.OrtUtil;
import ai.onnxruntime.providers.CoreMLFlags;
import ai.onnxruntime.providers.NNAPIFlags;
import ai.onnxruntime.providers.OrtCUDAProviderOptions;
import ai.onnxruntime.providers.OrtFlags;
import ai.onnxruntime.providers.OrtTensorRTProviderOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public class OrtSession
implements AutoCloseable {
    private final long nativeHandle;
    private final OrtAllocator allocator;
    private final long numInputs;
    private final Set<String> inputNames;
    private final long numOutputs;
    private final Set<String> outputNames;
    private OnnxModelMetadata metadata;
    private boolean closed = false;

    OrtSession(OrtEnvironment ortEnvironment, String string, OrtAllocator ortAllocator, SessionOptions sessionOptions) throws OrtException {
        this(OrtSession.createSession(OnnxRuntime.ortApiHandle, ortEnvironment.nativeHandle, string, sessionOptions.nativeHandle), ortAllocator);
    }

    OrtSession(OrtEnvironment ortEnvironment, byte[] byArray, OrtAllocator ortAllocator, SessionOptions sessionOptions) throws OrtException {
        this(OrtSession.createSession(OnnxRuntime.ortApiHandle, ortEnvironment.nativeHandle, byArray, sessionOptions.nativeHandle), ortAllocator);
    }

    private OrtSession(long l2, OrtAllocator ortAllocator) throws OrtException {
        this.nativeHandle = l2;
        this.allocator = ortAllocator;
        this.numInputs = this.getNumInputs(OnnxRuntime.ortApiHandle, l2);
        this.inputNames = new LinkedHashSet<String>(Arrays.asList(this.getInputNames(OnnxRuntime.ortApiHandle, l2, ortAllocator.handle)));
        this.numOutputs = this.getNumOutputs(OnnxRuntime.ortApiHandle, l2);
        this.outputNames = new LinkedHashSet<String>(Arrays.asList(this.getOutputNames(OnnxRuntime.ortApiHandle, l2, ortAllocator.handle)));
    }

    public long getNumInputs() {
        if (!this.closed) {
            return this.numInputs;
        }
        throw new IllegalStateException("Asking for inputs from a closed OrtSession.");
    }

    public long getNumOutputs() {
        if (!this.closed) {
            return this.numOutputs;
        }
        throw new IllegalStateException("Asking for outputs from a closed OrtSession.");
    }

    public Set<String> getInputNames() {
        if (!this.closed) {
            return this.inputNames;
        }
        throw new IllegalStateException("Asking for inputs from a closed OrtSession.");
    }

    public Set<String> getOutputNames() {
        if (!this.closed) {
            return this.outputNames;
        }
        throw new IllegalStateException("Asking for outputs from a closed OrtSession.");
    }

    public Map<String, NodeInfo> getInputInfo() throws OrtException {
        if (!this.closed) {
            return OrtSession.wrapInMap(this.getInputInfo(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle));
        }
        throw new IllegalStateException("Asking for inputs from a closed OrtSession.");
    }

    public Map<String, NodeInfo> getOutputInfo() throws OrtException {
        if (!this.closed) {
            return OrtSession.wrapInMap(this.getOutputInfo(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle));
        }
        throw new IllegalStateException("Asking for outputs from a closed OrtSession.");
    }

    public Result run(Map<String, OnnxTensor> map) throws OrtException {
        return this.run(map, this.outputNames);
    }

    public Result run(Map<String, OnnxTensor> map, RunOptions runOptions) throws OrtException {
        return this.run(map, this.outputNames, runOptions);
    }

    public Result run(Map<String, OnnxTensor> map, Set<String> set) throws OrtException {
        return this.run(map, set, null);
    }

    public Result run(Map<String, OnnxTensor> map, Set<String> set, RunOptions runOptions) throws OrtException {
        if (!this.closed) {
            if (map.isEmpty() || (long)map.size() > this.numInputs) {
                throw new OrtException("Unexpected number of inputs, expected [1," + this.numInputs + ") found " + map.size());
            }
            if (set.isEmpty() || (long)set.size() > this.numOutputs) {
                throw new OrtException("Unexpected number of requestedOutputs, expected [1," + this.numOutputs + ") found " + set.size());
            }
            String[] stringArray = new String[map.size()];
            long[] lArray = new long[map.size()];
            int n2 = 0;
            for (Map.Entry<String, OnnxTensor> entry : map.entrySet()) {
                if (this.inputNames.contains(entry.getKey())) {
                    stringArray[n2] = (String)entry.getKey();
                    lArray[n2] = ((OnnxTensor)entry.getValue()).getNativeHandle();
                    ++n2;
                    continue;
                }
                throw new OrtException("Unknown input name " + (String)entry.getKey() + ", expected one of " + this.inputNames.toString());
            }
            String[] stringArray2 = new String[set.size()];
            n2 = 0;
            for (String string : set) {
                if (this.outputNames.contains(string)) {
                    stringArray2[n2] = string;
                    ++n2;
                    continue;
                }
                throw new OrtException("Unknown output name " + string + ", expected one of " + this.outputNames.toString());
            }
            long l2 = runOptions == null ? 0L : runOptions.nativeHandle;
            OnnxValue[] onnxValueArray = this.run(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle, stringArray, lArray, stringArray.length, stringArray2, stringArray2.length, l2);
            return new Result(stringArray2, onnxValueArray);
        }
        throw new IllegalStateException("Trying to score a closed OrtSession.");
    }

    public OnnxModelMetadata getMetadata() throws OrtException {
        if (this.metadata == null) {
            this.metadata = this.constructMetadata(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle);
        }
        return this.metadata;
    }

    public long getProfilingStartTimeInNs() throws OrtException {
        return this.getProfilingStartTimeInNs(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    public String endProfiling() throws OrtException {
        return this.endProfiling(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle);
    }

    public String toString() {
        return "OrtSession(numInputs=" + this.numInputs + ",numOutputs=" + this.numOutputs + ")";
    }

    @Override
    public void close() throws OrtException {
        if (this.closed) {
            throw new IllegalStateException("Trying to close an already closed OrtSession.");
        }
        this.closeSession(OnnxRuntime.ortApiHandle, this.nativeHandle);
        this.closed = true;
    }

    private static Map<String, NodeInfo> wrapInMap(NodeInfo[] nodeInfoArray) {
        LinkedHashMap<String, NodeInfo> linkedHashMap = new LinkedHashMap<String, NodeInfo>(OrtUtil.capacityFromSize(nodeInfoArray.length));
        for (NodeInfo nodeInfo : nodeInfoArray) {
            linkedHashMap.put(nodeInfo.getName(), nodeInfo);
        }
        return linkedHashMap;
    }

    private static native long createSession(long var0, long var2, String var4, long var5) throws OrtException;

    private static native long createSession(long var0, long var2, byte[] var4, long var5) throws OrtException;

    private native long getNumInputs(long var1, long var3) throws OrtException;

    private native String[] getInputNames(long var1, long var3, long var5) throws OrtException;

    private native NodeInfo[] getInputInfo(long var1, long var3, long var5) throws OrtException;

    private native long getNumOutputs(long var1, long var3) throws OrtException;

    private native String[] getOutputNames(long var1, long var3, long var5) throws OrtException;

    private native NodeInfo[] getOutputInfo(long var1, long var3, long var5) throws OrtException;

    private native OnnxValue[] run(long var1, long var3, long var5, String[] var7, long[] var8, long var9, String[] var11, long var12, long var14) throws OrtException;

    private native long getProfilingStartTimeInNs(long var1, long var3) throws OrtException;

    private native String endProfiling(long var1, long var3, long var5) throws OrtException;

    private native void closeSession(long var1, long var3) throws OrtException;

    private native OnnxModelMetadata constructMetadata(long var1, long var3, long var5) throws OrtException;

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load onnx-runtime library", iOException);
        }
    }

    public static class Result
    implements AutoCloseable,
    Iterable<Map.Entry<String, OnnxValue>> {
        private static final Logger logger = Logger.getLogger(Result.class.getName());
        private final Map<String, OnnxValue> map;
        private final List<OnnxValue> list;
        private boolean closed;

        Result(String[] stringArray, OnnxValue[] onnxValueArray) {
            if (stringArray.length != onnxValueArray.length) {
                throw new IllegalArgumentException("Expected same number of names and values, found names.length = " + stringArray.length + ", values.length = " + onnxValueArray.length);
            }
            this.map = new LinkedHashMap<String, OnnxValue>(OrtUtil.capacityFromSize(stringArray.length));
            this.list = new ArrayList<OnnxValue>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.map.put(stringArray[i2], onnxValueArray[i2]);
                this.list.add(onnxValueArray[i2]);
            }
            this.closed = false;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                for (OnnxValue onnxValue : this.map.values()) {
                    onnxValue.close();
                }
            } else {
                logger.warning("Closing an already closed Result");
            }
        }

        @Override
        public Iterator<Map.Entry<String, OnnxValue>> iterator() {
            if (!this.closed) {
                return this.map.entrySet().iterator();
            }
            throw new IllegalStateException("Result is closed");
        }

        public OnnxValue get(int n2) {
            if (!this.closed) {
                return this.list.get(n2);
            }
            throw new IllegalStateException("Result is closed");
        }

        public int size() {
            return this.map.size();
        }

        public Optional<OnnxValue> get(String string) {
            if (!this.closed) {
                OnnxValue onnxValue = this.map.get(string);
                if (onnxValue != null) {
                    return Optional.of(onnxValue);
                }
                return Optional.empty();
            }
            throw new IllegalStateException("Result is closed");
        }
    }

    public static class RunOptions
    implements AutoCloseable {
        private final long nativeHandle = RunOptions.createRunOptions(OnnxRuntime.ortApiHandle);
        private boolean closed = false;

        public void setLogLevel(OrtLoggingLevel ortLoggingLevel) throws OrtException {
            this.checkClosed();
            this.setLogLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, ortLoggingLevel.getValue());
        }

        public OrtLoggingLevel getLogLevel() throws OrtException {
            this.checkClosed();
            return OrtLoggingLevel.mapFromInt(this.getLogLevel(OnnxRuntime.ortApiHandle, this.nativeHandle));
        }

        public void setLogVerbosityLevel(int n2) throws OrtException {
            this.checkClosed();
            this.setLogVerbosityLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public int getLogVerbosityLevel() throws OrtException {
            this.checkClosed();
            return this.getLogVerbosityLevel(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void setRunTag(String string) throws OrtException {
            this.checkClosed();
            this.setRunTag(OnnxRuntime.ortApiHandle, this.nativeHandle, string);
        }

        public String getRunTag() throws OrtException {
            this.checkClosed();
            return this.getRunTag(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void setTerminate(boolean bl2) throws OrtException {
            this.checkClosed();
            this.setTerminate(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2);
        }

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Trying to use a closed RunOptions");
            }
        }

        @Override
        public void close() {
            if (this.closed) {
                throw new IllegalStateException("Trying to close an already closed RunOptions");
            }
            RunOptions.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        }

        private static native long createRunOptions(long var0) throws OrtException;

        private native void setLogLevel(long var1, long var3, int var5) throws OrtException;

        private native int getLogLevel(long var1, long var3) throws OrtException;

        private native void setLogVerbosityLevel(long var1, long var3, int var5) throws OrtException;

        private native int getLogVerbosityLevel(long var1, long var3) throws OrtException;

        private native void setRunTag(long var1, long var3, String var5) throws OrtException;

        private native String getRunTag(long var1, long var3) throws OrtException;

        private native void setTerminate(long var1, long var3, boolean var5) throws OrtException;

        private static native void close(long var0, long var2);
    }

    public static class SessionOptions
    implements AutoCloseable {
        private final long nativeHandle = this.createOptions(OnnxRuntime.ortApiHandle);
        private final List<Long> customLibraryHandles = new ArrayList<Long>();
        private final Map<String, String> configEntries = new LinkedHashMap<String, String>();
        private boolean closed = false;

        @Override
        public void close() {
            if (!this.closed) {
                if (this.customLibraryHandles.size() > 0) {
                    long[] lArray = new long[this.customLibraryHandles.size()];
                    for (int i2 = 0; i2 < this.customLibraryHandles.size(); ++i2) {
                        lArray[i2] = this.customLibraryHandles.get(i2);
                    }
                    this.closeCustomLibraries(lArray);
                }
            } else {
                throw new IllegalStateException("Trying to close a closed SessionOptions.");
            }
            this.closeOptions(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        }

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Trying to use a closed SessionOptions");
            }
        }

        public void setExecutionMode(ExecutionMode executionMode) throws OrtException {
            this.checkClosed();
            this.setExecutionMode(OnnxRuntime.ortApiHandle, this.nativeHandle, executionMode.getID());
        }

        public void setOptimizationLevel(OptLevel optLevel) throws OrtException {
            this.checkClosed();
            this.setOptimizationLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, optLevel.getID());
        }

        public void setInterOpNumThreads(int n2) throws OrtException {
            this.checkClosed();
            this.setInterOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void setIntraOpNumThreads(int n2) throws OrtException {
            this.checkClosed();
            this.setIntraOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void setOptimizedModelFilePath(String string) throws OrtException {
            this.checkClosed();
            this.setOptimizationModelFilePath(OnnxRuntime.ortApiHandle, this.nativeHandle, string);
        }

        public void setLoggerId(String string) throws OrtException {
            this.checkClosed();
            this.setLoggerId(OnnxRuntime.ortApiHandle, this.nativeHandle, string);
        }

        public void enableProfiling(String string) throws OrtException {
            this.checkClosed();
            this.enableProfiling(OnnxRuntime.ortApiHandle, this.nativeHandle, string);
        }

        public void disableProfiling() throws OrtException {
            this.checkClosed();
            this.disableProfiling(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void setMemoryPatternOptimization(boolean bl2) throws OrtException {
            this.checkClosed();
            this.setMemoryPatternOptimization(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2);
        }

        public void setCPUArenaAllocator(boolean bl2) throws OrtException {
            this.checkClosed();
            this.setCPUArenaAllocator(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2);
        }

        public void setSessionLogLevel(OrtLoggingLevel ortLoggingLevel) throws OrtException {
            this.checkClosed();
            this.setSessionLogLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, ortLoggingLevel.getValue());
        }

        public void setSessionLogVerbosityLevel(int n2) throws OrtException {
            this.checkClosed();
            this.setSessionLogVerbosityLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void registerCustomOpLibrary(String string) throws OrtException {
            this.checkClosed();
            long l2 = this.registerCustomOpLibrary(OnnxRuntime.ortApiHandle, this.nativeHandle, string);
            this.customLibraryHandles.add(l2);
        }

        public void setSymbolicDimensionValue(String string, long l2) throws OrtException {
            this.checkClosed();
            this.addFreeDimensionOverrideByName(OnnxRuntime.ortApiHandle, this.nativeHandle, string, l2);
        }

        public void disablePerSessionThreads() throws OrtException {
            this.checkClosed();
            this.disablePerSessionThreads(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void addConfigEntry(String string, String string2) throws OrtException {
            this.checkClosed();
            this.addConfigEntry(OnnxRuntime.ortApiHandle, this.nativeHandle, string, string2);
            this.configEntries.put(string, string2);
        }

        public Map<String, String> getConfigEntries() {
            this.checkClosed();
            return Collections.unmodifiableMap(this.configEntries);
        }

        public void addCUDA() throws OrtException {
            this.addCUDA(0);
        }

        public void addCUDA(int n2) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractCUDA()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find CUDA shared provider");
            }
            this.addCUDA(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void addCUDA(OrtCUDAProviderOptions ortCUDAProviderOptions) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractCUDA()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find CUDA shared provider");
            }
            this.addCUDAV2(OnnxRuntime.ortApiHandle, this.nativeHandle, ortCUDAProviderOptions.nativeHandle);
        }

        public void addROCM() throws OrtException {
            this.addROCM(0);
        }

        public void addROCM(int n2) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractROCM()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find ROCM shared provider");
            }
            this.addROCM(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void addCPU(boolean bl2) throws OrtException {
            this.checkClosed();
            this.addCPU(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2 ? 1 : 0);
        }

        public void addDnnl(boolean bl2) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractDNNL()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find DNNL shared provider");
            }
            this.addDnnl(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2 ? 1 : 0);
        }

        public void addOpenVINO(String string) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractOpenVINO()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find OpenVINO shared provider");
            }
            this.addOpenVINO(OnnxRuntime.ortApiHandle, this.nativeHandle, string);
        }

        public void addTensorrt(int n2) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractTensorRT()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find TensorRT shared provider");
            }
            this.addTensorrt(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void addTensorrt(OrtTensorRTProviderOptions ortTensorRTProviderOptions) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractTensorRT()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find TensorRT shared provider");
            }
            this.addTensorrtV2(OnnxRuntime.ortApiHandle, this.nativeHandle, ortTensorRTProviderOptions.nativeHandle);
        }

        public void addNnapi() throws OrtException {
            this.addNnapi(EnumSet.noneOf(NNAPIFlags.class));
        }

        public void addNnapi(EnumSet<NNAPIFlags> enumSet) throws OrtException {
            this.checkClosed();
            this.addNnapi(OnnxRuntime.ortApiHandle, this.nativeHandle, OrtFlags.aggregateToInt(enumSet));
        }

        public void addNuphar(boolean bl2, String string) throws OrtException {
            this.checkClosed();
            this.addNuphar(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2 ? 1 : 0, string);
        }

        public void addTvm(String string) throws OrtException {
            this.checkClosed();
            this.addTvm(OnnxRuntime.ortApiHandle, this.nativeHandle, string);
        }

        public void addDirectML(int n2) throws OrtException {
            this.checkClosed();
            this.addDirectML(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void addACL(boolean bl2) throws OrtException {
            this.checkClosed();
            this.addACL(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2 ? 1 : 0);
        }

        public void addArmNN(boolean bl2) throws OrtException {
            this.checkClosed();
            this.addArmNN(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2 ? 1 : 0);
        }

        public void addCoreML() throws OrtException {
            this.addCoreML(EnumSet.noneOf(CoreMLFlags.class));
        }

        public void addCoreML(EnumSet<CoreMLFlags> enumSet) throws OrtException {
            this.checkClosed();
            this.addCoreML(OnnxRuntime.ortApiHandle, this.nativeHandle, OrtFlags.aggregateToInt(enumSet));
        }

        private native void setExecutionMode(long var1, long var3, int var5) throws OrtException;

        private native void setOptimizationLevel(long var1, long var3, int var5) throws OrtException;

        private native void setInterOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setIntraOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setOptimizationModelFilePath(long var1, long var3, String var5) throws OrtException;

        private native long createOptions(long var1);

        private native void setLoggerId(long var1, long var3, String var5) throws OrtException;

        private native void enableProfiling(long var1, long var3, String var5) throws OrtException;

        private native void disableProfiling(long var1, long var3) throws OrtException;

        private native void setMemoryPatternOptimization(long var1, long var3, boolean var5) throws OrtException;

        private native void setCPUArenaAllocator(long var1, long var3, boolean var5) throws OrtException;

        private native void setSessionLogLevel(long var1, long var3, int var5) throws OrtException;

        private native void setSessionLogVerbosityLevel(long var1, long var3, int var5) throws OrtException;

        private native long registerCustomOpLibrary(long var1, long var3, String var5) throws OrtException;

        private native void closeCustomLibraries(long[] var1);

        private native void closeOptions(long var1, long var3);

        private native void addFreeDimensionOverrideByName(long var1, long var3, String var5, long var6) throws OrtException;

        private native void disablePerSessionThreads(long var1, long var3) throws OrtException;

        private native void addConfigEntry(long var1, long var3, String var5, String var6) throws OrtException;

        private native void addCPU(long var1, long var3, int var5) throws OrtException;

        private native void addCUDA(long var1, long var3, int var5) throws OrtException;

        private native void addCUDAV2(long var1, long var3, long var5) throws OrtException;

        private native void addROCM(long var1, long var3, int var5) throws OrtException;

        private native void addDnnl(long var1, long var3, int var5) throws OrtException;

        private native void addOpenVINO(long var1, long var3, String var5) throws OrtException;

        private native void addTensorrt(long var1, long var3, int var5) throws OrtException;

        private native void addTensorrtV2(long var1, long var3, long var5) throws OrtException;

        private native void addNnapi(long var1, long var3, int var5) throws OrtException;

        private native void addNuphar(long var1, long var3, int var5, String var6) throws OrtException;

        private native void addTvm(long var1, long var3, String var5) throws OrtException;

        private native void addDirectML(long var1, long var3, int var5) throws OrtException;

        private native void addACL(long var1, long var3, int var5) throws OrtException;

        private native void addArmNN(long var1, long var3, int var5) throws OrtException;

        private native void addCoreML(long var1, long var3, int var5) throws OrtException;

        public static enum ExecutionMode {
            SEQUENTIAL(0),
            PARALLEL(1);

            private final int id;

            private ExecutionMode(int n3) {
                this.id = n3;
            }

            public int getID() {
                return this.id;
            }
        }

        public static enum OptLevel {
            NO_OPT(0),
            BASIC_OPT(1),
            EXTENDED_OPT(2),
            ALL_OPT(99);

            private final int id;

            private OptLevel(int n3) {
                this.id = n3;
            }

            public int getID() {
                return this.id;
            }
        }
    }
}

