/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.processor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.graalvm.compiler.processor.AbstractProcessor;

public class StubPortProcessor
extends AbstractProcessor {
    static final String JDK_LATEST = "https://raw.githubusercontent.com/openjdk/jdk/master/";
    static final String JDK_LATEST_INFO = "https://api.github.com/repos/openjdk/jdk/git/matching-refs/heads/master";
    static final String JDK_COMMIT = "https://raw.githubusercontent.com/openjdk/jdk/";
    static final String STUB_PORT_CLASS_NAME = "org.graalvm.compiler.lir.StubPort";
    static final String STUB_PORTS_CLASS_NAME = "org.graalvm.compiler.lir.StubPorts";
    static final String SYNC_CHECK_ENV_VAR = "HOTSPOT_PORT_SYNC_CHECK";
    static final String HTTPS_PROXY_ENV_VAR = "HTTPS_PROXY";
    static final int SEARCH_RANGE = 200;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(STUB_PORT_CLASS_NAME, STUB_PORTS_CLASS_NAME);
    }

    private void compareDigest(MessageDigest md, AnnotationMirror annotationMirror, Element element, Proxy proxy) throws IOException {
        String sha1Latest;
        String path = StubPortProcessor.getAnnotationValue(annotationMirror, "path", String.class);
        int lineStart = StubPortProcessor.getAnnotationValue(annotationMirror, "lineStart", Integer.class);
        int lineEnd = StubPortProcessor.getAnnotationValue(annotationMirror, "lineEnd", Integer.class);
        String commit = StubPortProcessor.getAnnotationValue(annotationMirror, "commit", String.class);
        String sha1 = StubPortProcessor.getAnnotationValue(annotationMirror, "sha1", String.class);
        String urlHumanSuffix = path + "#L" + lineStart + "-L" + lineEnd;
        String url = JDK_LATEST + path;
        try {
            sha1Latest = StubPortProcessor.digest(proxy, md, url, lineStart, lineEnd);
        }
        catch (FileNotFoundException e) {
            this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Sha1 digest of https://github.com/openjdk/jdk/blob/%s/%s (ported by %s) does not match : File not found in the latest commit.", commit, urlHumanSuffix, element.toString()));
            return;
        }
        if (!sha1.equals(sha1Latest)) {
            String urlOld = JDK_COMMIT + commit + "/" + path;
            String sha1Old = StubPortProcessor.digest(proxy, md, urlOld, lineStart, lineEnd);
            String extraMessage = "";
            if (sha1.equals(sha1Old)) {
                int idx = StubPortProcessor.find(proxy, urlOld, url, lineStart, lineEnd);
                if (idx != -1) {
                    extraMessage = String.format("It may be simply shifted. Try:\n@StubPort(path      = \"%s\",\nlineStart = %d,\nlineEnd   = %d,\ncommit    = \"%s\",\nsha1      = \"%s\")\n", path, idx, idx + (lineEnd - lineStart), StubPortProcessor.fetchLatestCommit(proxy), sha1);
                }
            } else {
                extraMessage = String.format("New StubPort? Then:\n@StubPort(path      = \"%s\",\nlineStart = %d,\nlineEnd   = %d,\ncommit    = \"%s\",\nsha1      = \"%s\")\n", path, lineStart, lineEnd, StubPortProcessor.fetchLatestCommit(proxy), sha1Latest);
            }
            this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Sha1 digest of https://github.com/openjdk/jdk/blob/%s/%s (ported by %s) does not match https://github.com/openjdk/jdk/blob/master/%s : expected %s but was %s. %s", commit, urlHumanSuffix, element.toString(), urlHumanSuffix, sha1, sha1Latest, extraMessage));
        }
    }

    private static String digest(Proxy proxy, MessageDigest md, String url, int lineStart, int lineEnd) throws IOException {
        URLConnection connection = new URL(url).openConnection(proxy);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            in.lines().skip(lineStart).limit(lineEnd - lineStart).map(String::getBytes).forEach(md::update);
        }
        return String.format("%040x", new BigInteger(1, md.digest()));
    }

    private static int find(Proxy proxy, String oldUrl, String newUrl, int lineStart, int lineEnd) throws IOException {
        URLConnection oldUrlConnection = new URL(oldUrl).openConnection(proxy);
        URLConnection newUrlConnection = new URL(newUrl).openConnection(proxy);
        try (BufferedReader oldUrlIn = new BufferedReader(new InputStreamReader(oldUrlConnection.getInputStream()));
             BufferedReader newUrlIn = new BufferedReader(new InputStreamReader(newUrlConnection.getInputStream()));){
            String oldSnippet = oldUrlIn.lines().skip(lineStart).limit(lineEnd - lineStart).collect(Collectors.joining("\n"));
            int newLineStart = Math.max(0, lineStart - 200);
            int newLineEnd = lineEnd + 200;
            String newFullFile = newUrlIn.lines().skip(newLineStart).limit(newLineEnd - newLineStart).collect(Collectors.joining("\n"));
            int idx = newFullFile.indexOf(oldSnippet);
            if (idx != -1) {
                int n = newLineStart + newFullFile.substring(0, idx).split("\n").length;
                return n;
            }
        }
        return -1;
    }

    private static String fetchLatestCommit(Proxy proxy) throws IOException {
        URLConnection connection = new URL(JDK_LATEST_INFO).openConnection(proxy);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String result = in.lines().collect(Collectors.joining());
            int idx = result.indexOf("commits/");
            if (idx != -1) {
                String string = result.substring(idx + 8, idx + 48);
                return string;
            }
        }
        return "UNKNOWN";
    }

    @Override
    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (Boolean.parseBoolean(System.getenv(SYNC_CHECK_ENV_VAR)) && !roundEnv.processingOver()) {
            try {
                System.setProperty("https.protocols", "TLSv1.2");
                TypeElement tStubPort = this.getTypeElement(STUB_PORT_CLASS_NAME);
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                Proxy proxy = Proxy.NO_PROXY;
                String proxyEnv = System.getenv(HTTPS_PROXY_ENV_VAR);
                if (proxyEnv != null) {
                    URI proxyURI = new URI(System.getenv(HTTPS_PROXY_ENV_VAR));
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURI.getHost(), proxyURI.getPort()));
                }
                for (Element element : roundEnv.getElementsAnnotatedWith(tStubPort)) {
                    this.compareDigest(md, this.getAnnotation(element, tStubPort.asType()), element, proxy);
                }
                TypeElement tStubPorts = this.getTypeElement(STUB_PORTS_CLASS_NAME);
                for (Element element : roundEnv.getElementsAnnotatedWith(tStubPorts)) {
                    AnnotationMirror stubPorts = this.getAnnotation(element, tStubPorts.asType());
                    for (AnnotationMirror stubPort : StubPortProcessor.getAnnotationValueList(stubPorts, "value", AnnotationMirror.class)) {
                        this.compareDigest(md, stubPort, element, proxy);
                    }
                }
            }
            catch (IOException | URISyntaxException | NoSuchAlgorithmException e) {
                this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString());
            }
        }
        return false;
    }
}

