/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.agentscript.impl.AbstractContextObject;
import com.oracle.truffle.tools.agentscript.impl.CurrentScopeView;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import com.oracle.truffle.tools.agentscript.impl.InsightHookNode;
import com.oracle.truffle.tools.agentscript.impl.LocationObject;
import com.oracle.truffle.tools.agentscript.impl.NullObject;
import com.oracle.truffle.tools.agentscript.impl.VariablesObject;

@ExportLibrary(value=InteropLibrary.class)
final class EventContextObject
extends AbstractContextObject {
    private final EventContext context;

    EventContextObject(EventContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException wrap(Object target, int arity, InteropException ex) {
        IllegalStateException ill = new IllegalStateException("Cannot invoke " + String.valueOf(target) + " with " + arity + " arguments: " + ex.getMessage());
        ill.initCause(ex);
        return ill;
    }

    static RuntimeException rethrow(RuntimeException ex, InteropLibrary interopLib) {
        if (interopLib.isException((Object)ex)) {
            throw ex;
        }
        throw ex;
    }

    @ExportMessage
    static boolean hasMembers(EventContextObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(EventContextObject obj, boolean includeInternal) {
        return MEMBERS;
    }

    @Override
    @ExportMessage
    Object readMember(String member) throws UnknownIdentifierException {
        return super.readMember(member);
    }

    @ExportMessage
    static boolean isMemberReadable(EventContextObject obj, String member) {
        return MEMBERS.contains(member);
    }

    @ExportMessage
    static Object invokeMember(EventContextObject obj, String member, Object[] args) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
        if ("returnNow".equals(member)) {
            throw InsightHookNode.returnNow(args);
        }
        if ("returnValue".equals(member)) {
            if (args.length == 0 || !(args[0] instanceof VariablesObject)) {
                return NullObject.nullCheck(null);
            }
            VariablesObject vars = (VariablesObject)args[0];
            return vars.getReturnValue();
        }
        if ("iterateFrames".equals(member)) {
            return EventContextObject.iterateFrames(args, obj);
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object iterateFrames(Object[] args, EventContextObject obj) throws ArityException, UnsupportedTypeException {
        Object callback;
        if (args.length == 0) {
            throw ArityException.create((int)0, (int)0, (int)args.length);
        }
        NodeLibrary lib = NodeLibrary.getUncached();
        InteropLibrary iop = InteropLibrary.getUncached();
        if (!iop.isExecutable(callback = args[0])) {
            Object displayCallback = iop.toDisplayString(callback, false);
            throw UnsupportedTypeException.create((Object[])new Object[]{callback}, (String)("Cannot execute " + String.valueOf(displayCallback)));
        }
        Object retValue = Truffle.getRuntime().iterateFrames(frameInstance -> {
            Node n = frameInstance.getCallNode();
            if (n == null || n.getRootNode() == null || n.getRootNode().isInternal()) {
                return null;
            }
            LocationObject location = new LocationObject(n);
            SourceSection ss = location.getInstrumentedSourceSection();
            if (ss == null || ss.getSource().isInternal()) {
                return null;
            }
            Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE);
            Node instrumentableNode = EventContextObject.findInstrumentableParent(n);
            if (instrumentableNode != null && lib.hasScope((Object)instrumentableNode, frame)) {
                try {
                    CurrentScopeView frameVars = new CurrentScopeView(lib.getScope((Object)instrumentableNode, frame, false));
                    Object ret = iop.execute(callback, new Object[]{location, frameVars});
                    return iop.isNull(ret) ? null : ret;
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException ex) {
                    throw InsightException.raise((Exception)ex);
                }
            }
            return null;
        });
        return NullObject.nullCheck(retValue);
    }

    @ExportMessage
    static boolean isMemberInvocable(EventContextObject obj, String member) {
        return "returnNow".equals(member) || "returnValue".equals(member) || "iterateFrames".equals(member);
    }

    @Override
    Node getInstrumentedNode() {
        return this.context.getInstrumentedNode();
    }

    @Override
    SourceSection getInstrumentedSourceSection() {
        return this.context.getInstrumentedSourceSection();
    }

    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        return this.toStringImpl();
    }

    public String toString() {
        return this.toStringImpl();
    }

    @CompilerDirectives.TruffleBoundary
    private String toStringImpl() {
        SourceSection ss = this.getInstrumentedSourceSection();
        Node n = this.getInstrumentedNode();
        if (ss == null || n == null) {
            return super.toString();
        }
        return n.getRootNode().getName() + " (" + ss.getSource().getName() + ":" + ss.getStartLine() + ":" + ss.getStartColumn() + ")";
    }

    static Node findInstrumentableParent(Node node) {
        for (Node p = node; p != null; p = p.getParent()) {
            Node n = p;
            if (n instanceof InstrumentableNode.WrapperNode) {
                n = ((InstrumentableNode.WrapperNode)n).getDelegateNode();
            }
            if (!(n instanceof InstrumentableNode) || !((InstrumentableNode)n).isInstrumentable()) continue;
            return n;
        }
        return null;
    }
}

