/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.graalvm.options.OptionValues;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.types.TextDocumentContentChangeEvent;
import org.graalvm.tools.lsp.server.utils.SourcePredicateBuilder;
import org.graalvm.tools.lsp.server.utils.SourceSectionReference;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;

public final class SourceUtils {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    private SourceUtils() {
        assert (false);
    }

    public static boolean isLineValid(int zeroBasedLine, Source source) {
        return zeroBasedLine >= 0 && (zeroBasedLine < source.getLineCount() || zeroBasedLine == source.getLineCount() && SourceUtils.endsWithNewline(source) || zeroBasedLine == 0 && source.getLineCount() == 0);
    }

    public static boolean isColumnValid(int line, int column, Source source) {
        return column <= source.getLineLength(SourceUtils.zeroBasedLineToOneBasedLine(line, source));
    }

    public static int zeroBasedLineToOneBasedLine(int line, Source source) {
        int lc = source.getLineCount();
        if (lc <= line) {
            return Math.max(1, lc);
        }
        return line + 1;
    }

    public static int zeroBasedColumnToOneBasedColumn(int zeroBasedLine, int oneBasedLine, int zeroBasedColumn, Source source) {
        if (zeroBasedLine >= oneBasedLine) {
            return source.getLineLength(oneBasedLine) + 1;
        }
        int lc = source.getLineLength(oneBasedLine);
        if (lc < zeroBasedColumn && zeroBasedColumn > 0) {
            return Math.max(1, lc);
        }
        return zeroBasedColumn + 1;
    }

    private static boolean endsWithNewline(Source source) {
        String text = source.getCharacters().toString();
        boolean isNewlineEnd = !text.isEmpty() && text.charAt(text.length() - 1) == '\n';
        return isNewlineEnd;
    }

    public static Range sourceSectionToRange(SourceSection section) {
        if (section == null) {
            return Range.create(0, 0, (Integer)0, (Integer)0);
        }
        int endColumn = section.getEndColumn();
        if (section.getCharacters().toString().endsWith("\n")) {
            --endColumn;
        }
        return Range.create(section.getStartLine() - 1, section.getStartColumn() - 1, (Integer)(section.getEndLine() - 1), (Integer)endColumn);
    }

    public static SourceSection findSourceLocation(TruffleInstrument.Env env, Object object, LanguageInfo defaultLanguageInfo) {
        LanguageInfo languageInfo;
        if (INTEROP.hasLanguage(object)) {
            try {
                languageInfo = env.getLanguageInfo(INTEROP.getLanguage(object));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
        } else {
            languageInfo = defaultLanguageInfo;
        }
        Object view = env.getLanguageView(languageInfo, object);
        if (INTEROP.hasSourceLocation(view)) {
            try {
                return INTEROP.getSourceLocation(view);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public static SourceFix removeLastTextInsertion(TextDocumentSurrogate surrogate, int originalCharacter, TruffleLogger logger) {
        TextDocumentContentChangeEvent lastChange = surrogate.getLastChange();
        if (lastChange == null) {
            return null;
        }
        Range range = lastChange.getRange();
        TextDocumentContentChangeEvent replacementEvent = TextDocumentContentChangeEvent.create("").setRange(Range.create(range.getStart(), Position.create(range.getEnd().getLine(), range.getEnd().getCharacter() + lastChange.getText().length()))).setRangeLength(lastChange.getText().length());
        String codeBeforeLastChange = SourceUtils.applyTextDocumentChanges(Arrays.asList(replacementEvent), surrogate.getSource(), surrogate, logger);
        int characterIdx = originalCharacter - (originalCharacter - range.getStart().getCharacter());
        return new SourceFix(codeBeforeLastChange, lastChange.getText(), characterIdx);
    }

    public static String applyTextDocumentChanges(List<? extends TextDocumentContentChangeEvent> list, Source source, TextDocumentSurrogate surrogate, TruffleLogger logger) {
        Source currentSource = null;
        String text = source.getCharacters().toString();
        StringBuilder sb = new StringBuilder(text);
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : list) {
            currentSource = currentSource == null ? source : Source.newBuilder((String)currentSource.getLanguage(), (CharSequence)sb, (String)currentSource.getName()).cached(false).build();
            Range range = textDocumentContentChangeEvent.getRange();
            if (range == null) {
                sb.setLength(0);
                sb.append(textDocumentContentChangeEvent.getText());
                continue;
            }
            Position start = range.getStart();
            Position end = range.getEnd();
            int startLine = start.getLine() + 1;
            int endLine = end.getLine() + 1;
            int replaceBegin = currentSource.getLineStartOffset(startLine) + start.getCharacter();
            int replaceEnd = currentSource.getLineStartOffset(endLine) + end.getCharacter();
            sb.replace(replaceBegin, replaceEnd, textDocumentContentChangeEvent.getText());
            if (surrogate == null || !surrogate.hasCoverageData()) continue;
            SourceUtils.updateCoverageData(surrogate, currentSource, textDocumentContentChangeEvent.getText(), range, replaceBegin, replaceEnd, logger);
        }
        return sb.toString();
    }

    private static void updateCoverageData(TextDocumentSurrogate surrogate, Source source, String newText, Range range, int replaceBegin, int replaceEnd, TruffleLogger logger) {
        Source newSourceSnippet = Source.newBuilder((String)"dummyLanguage", (CharSequence)newText, (String)"dummyCoverage").cached(false).build();
        int linesNewText = newSourceSnippet.getLineCount() + (newText.endsWith("\n") ? 1 : 0) + (newText.isEmpty() ? 1 : 0);
        Source oldSourceSnippet = source.subSource(replaceBegin, replaceEnd - replaceBegin);
        int liensOldText = oldSourceSnippet.getLineCount() + (oldSourceSnippet.getCharacters().toString().endsWith("\n") ? 1 : 0) + (oldSourceSnippet.getLength() == 0 ? 1 : 0);
        int newLineModification = linesNewText - liensOldText;
        logger.log(Level.FINEST, "newLineModification: {0}", (Object)newLineModification);
        if (newLineModification != 0) {
            List<SourceSectionReference> sections = surrogate.getCoverageLocations();
            sections.stream().filter(section -> section.includes(range)).forEach(section -> {
                SourceSectionReference migratedSection = new SourceSectionReference((SourceSectionReference)section);
                migratedSection.setEndLine(migratedSection.getEndLine() + newLineModification);
                surrogate.replace((SourceSectionReference)section, migratedSection);
                logger.log(Level.FINEST, "Included - Old: {0} Fixed: {1}", new Object[]{section, migratedSection});
            });
            sections.stream().filter(section -> section.behind(range)).forEach(section -> {
                SourceSectionReference migratedSection = new SourceSectionReference((SourceSectionReference)section);
                migratedSection.setStartLine(migratedSection.getStartLine() + newLineModification);
                migratedSection.setEndLine(migratedSection.getEndLine() + newLineModification);
                surrogate.replace((SourceSectionReference)section, migratedSection);
                logger.log(Level.FINEST, "Behind   - Old: {0} Fixed: {1}", new Object[]{section, migratedSection});
            });
        }
    }

    public static Range getRangeFrom(Exception te, InteropLibrary interopLib) {
        SourceSection sourceLocation;
        Range range = Range.create(0, 0, (Integer)0, (Integer)0);
        try {
            sourceLocation = interopLib.hasSourceLocation((Object)te) ? interopLib.getSourceLocation((Object)te) : null;
        }
        catch (UnsupportedMessageException um) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)um);
        }
        if (sourceLocation != null && sourceLocation.isAvailable()) {
            range = SourceUtils.sourceSectionToRange(sourceLocation);
        }
        return range;
    }

    public static int convertLineAndColumnToOffset(Source source, int oneBasedLineNumber, int column) {
        int offset = source.getLineStartOffset(oneBasedLineNumber);
        if (column > 0) {
            offset += column - 1;
        }
        return offset;
    }

    public static URI getOrFixFileUri(Source source) {
        if (source.getURI().getScheme().equals("file")) {
            return source.getURI();
        }
        if (source.getURI().getScheme().equals("truffle")) {
            Path path = Paths.get(source.getName(), new String[0]);
            return path.toUri();
        }
        throw new IllegalStateException("Source has an URI with unknown schema: " + String.valueOf(source.getURI()));
    }

    public static boolean isValidSourceSection(SourceSection sourceSection, OptionValues options) {
        SourceSectionFilter.SourcePredicate predicate = SourcePredicateBuilder.newBuilder().excludeInternal(options).build();
        return sourceSection != null && sourceSection.isAvailable() && predicate.test(sourceSection.getSource());
    }

    public static final class SourceFix {
        public final String text;
        public final String removedCharacters;
        public final int characterIdx;

        public SourceFix(String text, String removedChracters, int characterIdx) {
            this.text = text;
            this.removedCharacters = removedChracters;
            this.characterIdx = characterIdx;
        }
    }
}

