/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

public final class EvaluationResult {
    private final Object result;
    private final boolean error;
    private final boolean evaluationDone;
    private final boolean unknownEcutionTarget;

    private EvaluationResult(Object result, boolean error, boolean evaluationDone, boolean unknownEcutionTarget) {
        this.result = result;
        this.error = error;
        this.evaluationDone = evaluationDone;
        this.unknownEcutionTarget = unknownEcutionTarget;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isEvaluationDone() {
        return this.evaluationDone;
    }

    public boolean isUnknownEcutionTarget() {
        return this.unknownEcutionTarget;
    }

    public static EvaluationResult createError(Object e) {
        return new EvaluationResult(e, true, true, false);
    }

    public static EvaluationResult createResult(Object result) {
        return new EvaluationResult(result, false, true, false);
    }

    public static EvaluationResult createEvaluationSectionNotReached() {
        return new EvaluationResult(null, false, false, false);
    }

    public static EvaluationResult createUnknownExecutionTarget() {
        return new EvaluationResult(null, false, false, true);
    }
}

