/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;

public class TextDocumentContentChangeEvent
extends JSONBase {
    TextDocumentContentChangeEvent(JSONObject jsonData) {
        super(jsonData);
    }

    public Range getRange() {
        return this.jsonData.has("range") ? new Range(this.jsonData.optJSONObject("range")) : null;
    }

    public TextDocumentContentChangeEvent setRange(Range range) {
        this.jsonData.putOpt("range", range != null ? range.jsonData : null);
        return this;
    }

    @Deprecated
    public Integer getRangeLength() {
        return this.jsonData.has("rangeLength") ? Integer.valueOf(this.jsonData.getInt("rangeLength")) : null;
    }

    public TextDocumentContentChangeEvent setRangeLength(Integer rangeLength) {
        this.jsonData.putOpt("rangeLength", rangeLength);
        return this;
    }

    public String getText() {
        return this.jsonData.getString("text");
    }

    public TextDocumentContentChangeEvent setText(String text) {
        this.jsonData.put("text", text);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextDocumentContentChangeEvent other = (TextDocumentContentChangeEvent)obj;
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        if (!Objects.equals(this.getRangeLength(), other.getRangeLength())) {
            return false;
        }
        return Objects.equals(this.getText(), other.getText());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getRange());
        if (this.getRangeLength() != null) {
            hash = 97 * hash + Integer.hashCode(this.getRangeLength());
        }
        hash = 97 * hash + Objects.hashCode(this.getText());
        return hash;
    }

    public static TextDocumentContentChangeEvent create(String text) {
        JSONObject json = new JSONObject();
        json.put("text", text);
        return new TextDocumentContentChangeEvent(json);
    }
}

