/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.DocumentFilter;
import org.graalvm.tools.lsp.server.types.SelectionRangeOptions;

public class SelectionRangeRegistrationOptions
extends SelectionRangeOptions {
    SelectionRangeRegistrationOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public List<Object> getDocumentSelector() {
        JSONArray json = this.jsonData.optJSONArray("documentSelector");
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            Object obj = json.get(i);
            if (obj instanceof JSONObject) {
                list.add(new DocumentFilter((JSONObject)obj));
            }
            list.add(obj);
        }
        return Collections.unmodifiableList(list);
    }

    public SelectionRangeRegistrationOptions setDocumentSelector(List<Object> documentSelector) {
        if (documentSelector != null) {
            JSONArray json = new JSONArray();
            for (Object object : documentSelector) {
                if (object instanceof DocumentFilter) {
                    json.put(((DocumentFilter)object).jsonData);
                    continue;
                }
                json.put(object);
            }
            this.jsonData.put("documentSelector", json);
        } else {
            this.jsonData.put("documentSelector", JSONObject.NULL);
        }
        return this;
    }

    public String getId() {
        return this.jsonData.optString("id", null);
    }

    public SelectionRangeRegistrationOptions setId(String id) {
        this.jsonData.putOpt("id", id);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionRangeRegistrationOptions other = (SelectionRangeRegistrationOptions)obj;
        if (!Objects.equals(this.getDocumentSelector(), other.getDocumentSelector())) {
            return false;
        }
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneProgress(), other.getWorkDoneProgress());
    }

    @Override
    public int hashCode() {
        int hash = 2;
        if (this.getDocumentSelector() != null) {
            hash = 71 * hash + Objects.hashCode(this.getDocumentSelector());
        }
        if (this.getId() != null) {
            hash = 71 * hash + Objects.hashCode(this.getId());
        }
        if (this.getWorkDoneProgress() != null) {
            hash = 71 * hash + Boolean.hashCode(this.getWorkDoneProgress());
        }
        return hash;
    }

    public static SelectionRangeRegistrationOptions create(List<Object> documentSelector) {
        JSONObject json = new JSONObject();
        if (documentSelector != null) {
            JSONArray documentSelectorJsonArr = new JSONArray();
            for (Object object : documentSelector) {
                if (object instanceof DocumentFilter) {
                    documentSelectorJsonArr.put(((DocumentFilter)object).jsonData);
                    continue;
                }
                documentSelectorJsonArr.put(object);
            }
            json.put("documentSelector", documentSelectorJsonArr);
        } else {
            json.put("documentSelector", JSONObject.NULL);
        }
        return new SelectionRangeRegistrationOptions(json);
    }
}

