/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import java.util.HashMap;
import java.util.Map;

public enum ResourceOperationKind {
    Create("create"),
    Rename("rename"),
    Delete("delete");

    private final String stringValue;
    private static final Map<String, ResourceOperationKind> lookup;

    private ResourceOperationKind(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static ResourceOperationKind get(String stringValue) {
        return lookup.get(stringValue);
    }

    static {
        lookup = new HashMap<String, ResourceOperationKind>();
        for (ResourceOperationKind value : ResourceOperationKind.values()) {
            lookup.put(value.getStringValue(), value);
        }
    }
}

