/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MessageType;

public class LogMessageParams
extends JSONBase {
    LogMessageParams(JSONObject jsonData) {
        super(jsonData);
    }

    public MessageType getType() {
        return MessageType.get(this.jsonData.getInt("type"));
    }

    public LogMessageParams setType(MessageType type) {
        this.jsonData.put("type", type.getIntValue());
        return this;
    }

    public String getMessage() {
        return this.jsonData.getString("message");
    }

    public LogMessageParams setMessage(String message) {
        this.jsonData.put("message", message);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogMessageParams other = (LogMessageParams)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        return Objects.equals(this.getMessage(), other.getMessage());
    }

    public int hashCode() {
        int hash = 2;
        hash = 43 * hash + Objects.hashCode((Object)this.getType());
        hash = 43 * hash + Objects.hashCode(this.getMessage());
        return hash;
    }

    public static LogMessageParams create(MessageType type, String message) {
        JSONObject json = new JSONObject();
        json.put("type", type.getIntValue());
        json.put("message", message);
        return new LogMessageParams(json);
    }
}

