/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;

public class Location
extends JSONBase {
    Location(JSONObject jsonData) {
        super(jsonData);
    }

    public String getUri() {
        return this.jsonData.getString("uri");
    }

    public Location setUri(String uri) {
        this.jsonData.put("uri", uri);
        return this;
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public Location setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (!Objects.equals(this.getUri(), other.getUri())) {
            return false;
        }
        return Objects.equals(this.getRange(), other.getRange());
    }

    public int hashCode() {
        int hash = 2;
        hash = 43 * hash + Objects.hashCode(this.getUri());
        hash = 43 * hash + Objects.hashCode(this.getRange());
        return hash;
    }

    public static Location create(String uri, Range range) {
        JSONObject json = new JSONObject();
        json.put("uri", uri);
        json.put("range", range.jsonData);
        return new Location(json);
    }
}

