/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.TextDocumentPositionParams;

public class ImplementationParams
extends TextDocumentPositionParams {
    ImplementationParams(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getWorkDoneToken() {
        return this.jsonData.opt("workDoneToken");
    }

    public ImplementationParams setWorkDoneToken(Object workDoneToken) {
        this.jsonData.putOpt("workDoneToken", workDoneToken);
        return this;
    }

    public Object getPartialResultToken() {
        return this.jsonData.opt("partialResultToken");
    }

    public ImplementationParams setPartialResultToken(Object partialResultToken) {
        this.jsonData.putOpt("partialResultToken", partialResultToken);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImplementationParams other = (ImplementationParams)obj;
        if (!Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken())) {
            return false;
        }
        if (!Objects.equals(this.getPartialResultToken(), other.getPartialResultToken())) {
            return false;
        }
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return Objects.equals(this.getPosition(), other.getPosition());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getWorkDoneToken() != null) {
            hash = 19 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        if (this.getPartialResultToken() != null) {
            hash = 19 * hash + Objects.hashCode(this.getPartialResultToken());
        }
        hash = 19 * hash + Objects.hashCode(this.getTextDocument());
        hash = 19 * hash + Objects.hashCode(this.getPosition());
        return hash;
    }

    public static ImplementationParams create(TextDocumentIdentifier textDocument, Position position) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("position", position.jsonData);
        return new ImplementationParams(json);
    }
}

