/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressOptions;

public class ExecuteCommandOptions
extends WorkDoneProgressOptions {
    ExecuteCommandOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public List<String> getCommands() {
        JSONArray json = this.jsonData.getJSONArray("commands");
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public ExecuteCommandOptions setCommands(List<String> commands) {
        JSONArray json = new JSONArray();
        for (String string : commands) {
            json.put(string);
        }
        this.jsonData.put("commands", json);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecuteCommandOptions other = (ExecuteCommandOptions)obj;
        if (!Objects.equals(this.getCommands(), other.getCommands())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneProgress(), other.getWorkDoneProgress());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.getCommands());
        if (this.getWorkDoneProgress() != null) {
            hash = 41 * hash + Boolean.hashCode(this.getWorkDoneProgress());
        }
        return hash;
    }

    public static ExecuteCommandOptions create(List<String> commands) {
        JSONObject json = new JSONObject();
        JSONArray commandsJsonArr = new JSONArray();
        for (String string : commands) {
            commandsJsonArr.put(string);
        }
        json.put("commands", commandsJsonArr);
        return new ExecuteCommandOptions(json);
    }
}

