/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import java.util.HashMap;
import java.util.Map;

public enum DiagnosticSeverity {
    Error(1),
    Warning(2),
    Information(3),
    Hint(4);

    private final int intValue;
    private static final Map<Integer, DiagnosticSeverity> lookup;

    private DiagnosticSeverity(int intValue) {
        this.intValue = intValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static DiagnosticSeverity get(Integer intValue) {
        return lookup.get(intValue);
    }

    static {
        lookup = new HashMap<Integer, DiagnosticSeverity>();
        for (DiagnosticSeverity value : DiagnosticSeverity.values()) {
            lookup.put(value.getIntValue(), value);
        }
    }
}

