/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Location;

public class DiagnosticRelatedInformation
extends JSONBase {
    DiagnosticRelatedInformation(JSONObject jsonData) {
        super(jsonData);
    }

    public Location getLocation() {
        return new Location(this.jsonData.getJSONObject("location"));
    }

    public DiagnosticRelatedInformation setLocation(Location location) {
        this.jsonData.put("location", location.jsonData);
        return this;
    }

    public String getMessage() {
        return this.jsonData.getString("message");
    }

    public DiagnosticRelatedInformation setMessage(String message) {
        this.jsonData.put("message", message);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagnosticRelatedInformation other = (DiagnosticRelatedInformation)obj;
        if (!Objects.equals(this.getLocation(), other.getLocation())) {
            return false;
        }
        return Objects.equals(this.getMessage(), other.getMessage());
    }

    public int hashCode() {
        int hash = 2;
        hash = 59 * hash + Objects.hashCode(this.getLocation());
        hash = 59 * hash + Objects.hashCode(this.getMessage());
        return hash;
    }

    public static DiagnosticRelatedInformation create(Location location, String message) {
        JSONObject json = new JSONObject();
        json.put("location", location.jsonData);
        json.put("message", message);
        return new DiagnosticRelatedInformation(json);
    }
}

