/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CompletionItemKind;
import org.graalvm.tools.lsp.server.types.CompletionItemTag;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkupKind;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;

public class CompletionClientCapabilities
extends JSONBase {
    CompletionClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDynamicRegistration() {
        return this.jsonData.has("dynamicRegistration") ? Boolean.valueOf(this.jsonData.getBoolean("dynamicRegistration")) : null;
    }

    public CompletionClientCapabilities setDynamicRegistration(Boolean dynamicRegistration) {
        this.jsonData.putOpt("dynamicRegistration", dynamicRegistration);
        return this;
    }

    public CompletionItemCapabilities getCompletionItem() {
        return this.jsonData.has("completionItem") ? new CompletionItemCapabilities(this.jsonData.optJSONObject("completionItem")) : null;
    }

    public CompletionClientCapabilities setCompletionItem(CompletionItemCapabilities completionItem) {
        this.jsonData.putOpt("completionItem", completionItem != null ? completionItem.jsonData : null);
        return this;
    }

    public CompletionItemKindCapabilities getCompletionItemKind() {
        return this.jsonData.has("completionItemKind") ? new CompletionItemKindCapabilities(this.jsonData.optJSONObject("completionItemKind")) : null;
    }

    public CompletionClientCapabilities setCompletionItemKind(CompletionItemKindCapabilities completionItemKind) {
        this.jsonData.putOpt("completionItemKind", completionItemKind != null ? completionItemKind.jsonData : null);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getContextSupport() {
        return this.jsonData.has("contextSupport") ? Boolean.valueOf(this.jsonData.getBoolean("contextSupport")) : null;
    }

    public CompletionClientCapabilities setContextSupport(Boolean contextSupport) {
        this.jsonData.putOpt("contextSupport", contextSupport);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionClientCapabilities other = (CompletionClientCapabilities)obj;
        if (!Objects.equals(this.getDynamicRegistration(), other.getDynamicRegistration())) {
            return false;
        }
        if (!Objects.equals(this.getCompletionItem(), other.getCompletionItem())) {
            return false;
        }
        if (!Objects.equals(this.getCompletionItemKind(), other.getCompletionItemKind())) {
            return false;
        }
        return Objects.equals(this.getContextSupport(), other.getContextSupport());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getDynamicRegistration() != null) {
            hash = 47 * hash + Boolean.hashCode(this.getDynamicRegistration());
        }
        if (this.getCompletionItem() != null) {
            hash = 47 * hash + Objects.hashCode(this.getCompletionItem());
        }
        if (this.getCompletionItemKind() != null) {
            hash = 47 * hash + Objects.hashCode(this.getCompletionItemKind());
        }
        if (this.getContextSupport() != null) {
            hash = 47 * hash + Boolean.hashCode(this.getContextSupport());
        }
        return hash;
    }

    public static CompletionClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new CompletionClientCapabilities(json);
    }

    public static class CompletionItemCapabilities
    extends JSONBase {
        CompletionItemCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getSnippetSupport() {
            return this.jsonData.has("snippetSupport") ? Boolean.valueOf(this.jsonData.getBoolean("snippetSupport")) : null;
        }

        public CompletionItemCapabilities setSnippetSupport(Boolean snippetSupport) {
            this.jsonData.putOpt("snippetSupport", snippetSupport);
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getCommitCharactersSupport() {
            return this.jsonData.has("commitCharactersSupport") ? Boolean.valueOf(this.jsonData.getBoolean("commitCharactersSupport")) : null;
        }

        public CompletionItemCapabilities setCommitCharactersSupport(Boolean commitCharactersSupport) {
            this.jsonData.putOpt("commitCharactersSupport", commitCharactersSupport);
            return this;
        }

        public List<MarkupKind> getDocumentationFormat() {
            JSONArray json = this.jsonData.optJSONArray("documentationFormat");
            if (json == null) {
                return null;
            }
            ArrayList<MarkupKind> list = new ArrayList<MarkupKind>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(MarkupKind.get(json.getString(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public CompletionItemCapabilities setDocumentationFormat(List<MarkupKind> documentationFormat) {
            if (documentationFormat != null) {
                JSONArray json = new JSONArray();
                for (MarkupKind markupKind : documentationFormat) {
                    json.put(markupKind.getStringValue());
                }
                this.jsonData.put("documentationFormat", json);
            }
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getDeprecatedSupport() {
            return this.jsonData.has("deprecatedSupport") ? Boolean.valueOf(this.jsonData.getBoolean("deprecatedSupport")) : null;
        }

        public CompletionItemCapabilities setDeprecatedSupport(Boolean deprecatedSupport) {
            this.jsonData.putOpt("deprecatedSupport", deprecatedSupport);
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getPreselectSupport() {
            return this.jsonData.has("preselectSupport") ? Boolean.valueOf(this.jsonData.getBoolean("preselectSupport")) : null;
        }

        public CompletionItemCapabilities setPreselectSupport(Boolean preselectSupport) {
            this.jsonData.putOpt("preselectSupport", preselectSupport);
            return this;
        }

        public TagSupportCapabilities getTagSupport() {
            return this.jsonData.has("tagSupport") ? new TagSupportCapabilities(this.jsonData.optJSONObject("tagSupport")) : null;
        }

        public CompletionItemCapabilities setTagSupport(TagSupportCapabilities tagSupport) {
            this.jsonData.putOpt("tagSupport", tagSupport != null ? tagSupport.jsonData : null);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompletionItemCapabilities other = (CompletionItemCapabilities)obj;
            if (!Objects.equals(this.getSnippetSupport(), other.getSnippetSupport())) {
                return false;
            }
            if (!Objects.equals(this.getCommitCharactersSupport(), other.getCommitCharactersSupport())) {
                return false;
            }
            if (!Objects.equals(this.getDocumentationFormat(), other.getDocumentationFormat())) {
                return false;
            }
            if (!Objects.equals(this.getDeprecatedSupport(), other.getDeprecatedSupport())) {
                return false;
            }
            if (!Objects.equals(this.getPreselectSupport(), other.getPreselectSupport())) {
                return false;
            }
            return Objects.equals(this.getTagSupport(), other.getTagSupport());
        }

        public int hashCode() {
            int hash = 7;
            if (this.getSnippetSupport() != null) {
                hash = 71 * hash + Boolean.hashCode(this.getSnippetSupport());
            }
            if (this.getCommitCharactersSupport() != null) {
                hash = 71 * hash + Boolean.hashCode(this.getCommitCharactersSupport());
            }
            if (this.getDocumentationFormat() != null) {
                hash = 71 * hash + Objects.hashCode(this.getDocumentationFormat());
            }
            if (this.getDeprecatedSupport() != null) {
                hash = 71 * hash + Boolean.hashCode(this.getDeprecatedSupport());
            }
            if (this.getPreselectSupport() != null) {
                hash = 71 * hash + Boolean.hashCode(this.getPreselectSupport());
            }
            if (this.getTagSupport() != null) {
                hash = 71 * hash + Objects.hashCode(this.getTagSupport());
            }
            return hash;
        }

        public static class TagSupportCapabilities
        extends JSONBase {
            TagSupportCapabilities(JSONObject jsonData) {
                super(jsonData);
            }

            public List<CompletionItemTag> getValueSet() {
                JSONArray json = this.jsonData.getJSONArray("valueSet");
                ArrayList<CompletionItemTag> list = new ArrayList<CompletionItemTag>(json.length());
                for (int i = 0; i < json.length(); ++i) {
                    list.add(CompletionItemTag.get(json.getInt(i)));
                }
                return Collections.unmodifiableList(list);
            }

            public TagSupportCapabilities setValueSet(List<CompletionItemTag> valueSet) {
                JSONArray json = new JSONArray();
                for (CompletionItemTag completionItemTag : valueSet) {
                    json.put(completionItemTag.getIntValue());
                }
                this.jsonData.put("valueSet", json);
                return this;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TagSupportCapabilities other = (TagSupportCapabilities)obj;
                return Objects.equals(this.getValueSet(), other.getValueSet());
            }

            public int hashCode() {
                int hash = 7;
                hash = 43 * hash + Objects.hashCode(this.getValueSet());
                return hash;
            }
        }
    }

    public static class CompletionItemKindCapabilities
    extends JSONBase {
        CompletionItemKindCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        public List<CompletionItemKind> getValueSet() {
            JSONArray json = this.jsonData.optJSONArray("valueSet");
            if (json == null) {
                return null;
            }
            ArrayList<CompletionItemKind> list = new ArrayList<CompletionItemKind>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(CompletionItemKind.get(json.getInt(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public CompletionItemKindCapabilities setValueSet(List<CompletionItemKind> valueSet) {
            if (valueSet != null) {
                JSONArray json = new JSONArray();
                for (CompletionItemKind completionItemKind : valueSet) {
                    json.put(completionItemKind.getIntValue());
                }
                this.jsonData.put("valueSet", json);
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompletionItemKindCapabilities other = (CompletionItemKindCapabilities)obj;
            return Objects.equals(this.getValueSet(), other.getValueSet());
        }

        public int hashCode() {
            int hash = 7;
            if (this.getValueSet() != null) {
                hash = 53 * hash + Objects.hashCode(this.getValueSet());
            }
            return hash;
        }
    }
}

