/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Color;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressParams;

public class ColorPresentationParams
extends WorkDoneProgressParams {
    ColorPresentationParams(JSONObject jsonData) {
        super(jsonData);
    }

    public TextDocumentIdentifier getTextDocument() {
        return new TextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public ColorPresentationParams setTextDocument(TextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public Color getColor() {
        return new Color(this.jsonData.getJSONObject("color"));
    }

    public ColorPresentationParams setColor(Color color) {
        this.jsonData.put("color", color.jsonData);
        return this;
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public ColorPresentationParams setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public Object getPartialResultToken() {
        return this.jsonData.opt("partialResultToken");
    }

    public ColorPresentationParams setPartialResultToken(Object partialResultToken) {
        this.jsonData.putOpt("partialResultToken", partialResultToken);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorPresentationParams other = (ColorPresentationParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        if (!Objects.equals(this.getColor(), other.getColor())) {
            return false;
        }
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        if (!Objects.equals(this.getPartialResultToken(), other.getPartialResultToken())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getTextDocument());
        hash = 97 * hash + Objects.hashCode(this.getColor());
        hash = 97 * hash + Objects.hashCode(this.getRange());
        if (this.getPartialResultToken() != null) {
            hash = 97 * hash + Objects.hashCode(this.getPartialResultToken());
        }
        if (this.getWorkDoneToken() != null) {
            hash = 97 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        return hash;
    }

    public static ColorPresentationParams create(TextDocumentIdentifier textDocument, Color color, Range range) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("color", color.jsonData);
        json.put("range", range.jsonData);
        return new ColorPresentationParams(json);
    }
}

