/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CodeActionKind;
import org.graalvm.tools.lsp.server.types.Command;
import org.graalvm.tools.lsp.server.types.Diagnostic;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.WorkspaceEdit;

public class CodeAction
extends JSONBase {
    CodeAction(JSONObject jsonData) {
        super(jsonData);
    }

    public String getTitle() {
        return this.jsonData.getString("title");
    }

    public CodeAction setTitle(String title) {
        this.jsonData.put("title", title);
        return this;
    }

    public CodeActionKind getKind() {
        return CodeActionKind.get(this.jsonData.optString("kind", null));
    }

    public CodeAction setKind(CodeActionKind kind) {
        this.jsonData.putOpt("kind", kind != null ? kind.getStringValue() : null);
        return this;
    }

    public List<Diagnostic> getDiagnostics() {
        JSONArray json = this.jsonData.optJSONArray("diagnostics");
        if (json == null) {
            return null;
        }
        ArrayList<Diagnostic> list = new ArrayList<Diagnostic>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Diagnostic(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public CodeAction setDiagnostics(List<Diagnostic> diagnostics) {
        if (diagnostics != null) {
            JSONArray json = new JSONArray();
            for (Diagnostic diagnostic : diagnostics) {
                json.put(diagnostic.jsonData);
            }
            this.jsonData.put("diagnostics", json);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getIsPreferred() {
        return this.jsonData.has("isPreferred") ? Boolean.valueOf(this.jsonData.getBoolean("isPreferred")) : null;
    }

    public CodeAction setIsPreferred(Boolean isPreferred) {
        this.jsonData.putOpt("isPreferred", isPreferred);
        return this;
    }

    public WorkspaceEdit getEdit() {
        return this.jsonData.has("edit") ? new WorkspaceEdit(this.jsonData.optJSONObject("edit")) : null;
    }

    public CodeAction setEdit(WorkspaceEdit edit) {
        this.jsonData.putOpt("edit", edit != null ? edit.jsonData : null);
        return this;
    }

    public Command getCommand() {
        return this.jsonData.has("command") ? new Command(this.jsonData.optJSONObject("command")) : null;
    }

    public CodeAction setCommand(Command command) {
        this.jsonData.putOpt("command", command != null ? command.jsonData : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeAction other = (CodeAction)obj;
        if (!Objects.equals(this.getTitle(), other.getTitle())) {
            return false;
        }
        if (this.getKind() != other.getKind()) {
            return false;
        }
        if (!Objects.equals(this.getDiagnostics(), other.getDiagnostics())) {
            return false;
        }
        if (!Objects.equals(this.getIsPreferred(), other.getIsPreferred())) {
            return false;
        }
        if (!Objects.equals(this.getEdit(), other.getEdit())) {
            return false;
        }
        return Objects.equals(this.getCommand(), other.getCommand());
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + Objects.hashCode(this.getTitle());
        if (this.getKind() != null) {
            hash = 11 * hash + Objects.hashCode((Object)this.getKind());
        }
        if (this.getDiagnostics() != null) {
            hash = 11 * hash + Objects.hashCode(this.getDiagnostics());
        }
        if (this.getIsPreferred() != null) {
            hash = 11 * hash + Boolean.hashCode(this.getIsPreferred());
        }
        if (this.getEdit() != null) {
            hash = 11 * hash + Objects.hashCode(this.getEdit());
        }
        if (this.getCommand() != null) {
            hash = 11 * hash + Objects.hashCode(this.getCommand());
        }
        return hash;
    }

    public static CodeAction create(String title, Command command, CodeActionKind kind) {
        JSONObject json = new JSONObject();
        json.put("title", title);
        json.putOpt("kind", kind != null ? kind.getStringValue() : null);
        json.putOpt("command", command != null ? command.jsonData : null);
        return new CodeAction(json);
    }

    public static CodeAction create(String title, WorkspaceEdit edit, CodeActionKind kind) {
        JSONObject json = new JSONObject();
        json.put("title", title);
        json.putOpt("kind", kind != null ? kind.getStringValue() : null);
        json.putOpt("edit", edit != null ? edit.jsonData : null);
        return new CodeAction(json);
    }

    public static CodeAction create(String title, Object commandOrEdit, CodeActionKind kind) {
        JSONObject json = new JSONObject();
        json.put("title", title);
        json.putOpt("kind", kind != null ? kind.getStringValue() : null);
        if (commandOrEdit instanceof WorkspaceEdit) {
            json.put("edit", ((WorkspaceEdit)commandOrEdit).jsonData);
        } else if (commandOrEdit instanceof Command) {
            json.put("command", ((Command)commandOrEdit).jsonData);
        }
        return new CodeAction(json);
    }
}

