/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.graalvm.tools.api.lsp.LSPLibrary;
import org.graalvm.tools.lsp.exceptions.DiagnosticsNotification;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.LanguageTriggerCharacters;
import org.graalvm.tools.lsp.server.request.AbstractRequestHandler;
import org.graalvm.tools.lsp.server.request.SourceCodeEvaluator;
import org.graalvm.tools.lsp.server.types.CompletionContext;
import org.graalvm.tools.lsp.server.types.CompletionItem;
import org.graalvm.tools.lsp.server.types.CompletionItemKind;
import org.graalvm.tools.lsp.server.types.CompletionList;
import org.graalvm.tools.lsp.server.types.CompletionTriggerKind;
import org.graalvm.tools.lsp.server.types.Diagnostic;
import org.graalvm.tools.lsp.server.types.DiagnosticSeverity;
import org.graalvm.tools.lsp.server.types.MarkupContent;
import org.graalvm.tools.lsp.server.types.MarkupKind;
import org.graalvm.tools.lsp.server.utils.CoverageData;
import org.graalvm.tools.lsp.server.utils.EvaluationResult;
import org.graalvm.tools.lsp.server.utils.NearestNode;
import org.graalvm.tools.lsp.server.utils.NearestSectionsFinder;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.SourceWrapper;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class CompletionRequestHandler
extends AbstractRequestHandler {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private static final LSPLibrary LSP_INTEROP = (LSPLibrary)LSPLibrary.getFactory().getUncached();
    public final CompletionList emptyList = CompletionList.create(Collections.emptyList(), false);
    private static final int SORTING_PRIORITY_LOCALS = 1;
    private static final int SORTING_PRIORITY_GLOBALS = 2;
    private final SourceCodeEvaluator sourceCodeEvaluator;
    private final LanguageTriggerCharacters languageCompletionTriggerCharacters;

    public CompletionRequestHandler(TruffleInstrument.Env envMain, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor executor, SourceCodeEvaluator sourceCodeEvaluator, LanguageTriggerCharacters completionTriggerCharacters) {
        super(envMain, env, surrogateMap, executor);
        this.sourceCodeEvaluator = sourceCodeEvaluator;
        this.languageCompletionTriggerCharacters = completionTriggerCharacters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionList completionWithEnteredContext(URI uri, int line, int column, CompletionContext completionContext) throws DiagnosticsNotification {
        this.logger.log(Level.FINER, "Start finding completions for {0}:{1}:{2}", new Object[]{uri, line, column});
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        if (surrogate == null) {
            this.logger.info("Completion requested in an unknown document: " + String.valueOf(uri));
            return this.emptyList;
        }
        Source source = surrogate.getSource();
        if (!SourceUtils.isLineValid(line, source) || !SourceUtils.isColumnValid(line, column, source)) {
            this.logger.fine("line or column is out of range, line=" + line + ", column=" + column);
            return this.emptyList;
        }
        List<String> completionTriggerCharacters = this.languageCompletionTriggerCharacters.getTriggerCharacters(surrogate.getLanguageId());
        CompletionKind completionKind = CompletionRequestHandler.getCompletionKind(source, SourceUtils.zeroBasedLineToOneBasedLine(line, source), column, completionTriggerCharacters, completionContext);
        if (surrogate.isSourceCodeReadyForCodeCompletion()) {
            return this.createCompletions(surrogate, line, column, completionKind);
        }
        SourceUtils.SourceFix sourceFix = SourceUtils.removeLastTextInsertion(surrogate, column, this.logger);
        if (sourceFix == null) {
            this.logger.fine("Unable to fix unparsable source code. No completion possible.");
            return this.emptyList;
        }
        TextDocumentSurrogate fixedSurrogate = surrogate.copy();
        fixedSurrogate.setEditorText(sourceFix.text);
        SourceWrapper sourceWrapper = fixedSurrogate.prepareParsing();
        CallTarget callTarget = null;
        try {
            callTarget = this.env.parse(sourceWrapper.getSource(), new String[0]);
            fixedSurrogate.notifyParsingDone(callTarget);
        }
        catch (Exception e) {
            try {
                this.err.println("Parsing a fixed source caused an exception: " + e.getClass().getSimpleName() + " > " + e.getLocalizedMessage());
                CompletionList completionList = this.emptyList;
                fixedSurrogate.notifyParsingDone(callTarget);
                return completionList;
            }
            catch (Throwable throwable) {
                fixedSurrogate.notifyParsingDone(callTarget);
                throw throwable;
            }
        }
        this.surrogateMap.put(uri, fixedSurrogate);
        try {
            CompletionList completionList = this.createCompletions(fixedSurrogate, line, sourceFix.characterIdx, CompletionRequestHandler.getCompletionKind(sourceFix.removedCharacters, completionTriggerCharacters));
            return completionList;
        }
        finally {
            this.surrogateMap.put(uri, surrogate);
        }
    }

    private CompletionList createCompletions(TextDocumentSurrogate surrogate, int line, int column, CompletionKind completionKind) throws DiagnosticsNotification {
        ArrayList<CompletionItem> completions = new ArrayList<CompletionItem>();
        if (completionKind == CompletionKind.GLOBALS_AND_LOCALS) {
            this.fillCompletionsWithGlobalsAndLocals(line, surrogate, column, completions);
        } else if (completionKind == CompletionKind.OBJECT_PROPERTY) {
            this.fillCompletionsWithObjectProperties(surrogate, line, column, completions);
        }
        return CompletionList.create(completions, false);
    }

    private void fillCompletionsWithGlobalsAndLocals(int line, TextDocumentSurrogate surrogate, int column, List<CompletionItem> completions) {
        Node nearestNode = this.findNearestNode(surrogate.getSourceWrapper(), line, column);
        if (nearestNode == null) {
            this.fillCompletionsWithGlobals(surrogate, completions);
            return;
        }
        if (!surrogate.hasCoverageData()) {
            this.fillCompletionsWithLocals(surrogate, nearestNode, completions, null);
            this.fillCompletionsWithGlobals(surrogate, completions);
            return;
        }
        List<CoverageData> coverages = surrogate.getCoverageData(nearestNode.getSourceSection());
        if (coverages == null || coverages.isEmpty()) {
            coverages = SourceCodeEvaluator.findCoverageDataBeforeNode(surrogate, nearestNode);
        }
        if (coverages != null && !coverages.isEmpty()) {
            CoverageData coverageData = coverages.get(coverages.size() - 1);
            MaterializedFrame frame = coverageData.getFrame();
            this.fillCompletionsWithLocals(surrogate, nearestNode, completions, frame);
            this.fillCompletionsWithLocals(surrogate, nearestNode, completions, null);
            this.fillCompletionsWithGlobals(surrogate, completions);
        } else {
            this.fillCompletionsWithGlobals(surrogate, completions);
            this.fillCompletionsWithLocals(surrogate, nearestNode, completions, null);
        }
    }

    private Node findNearestNode(SourceWrapper sourceWrapper, int line, int column) {
        NearestNode nearestNodeHolder = NearestSectionsFinder.findNearestNode(sourceWrapper.getSource(), line, column, this.env, this.logger);
        return nearestNodeHolder.getNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillCompletionsWithObjectProperties(TextDocumentSurrogate surrogate, int line, int column, List<CompletionItem> completions) throws DiagnosticsNotification {
        SourceWrapper sourceWrapper = surrogate.getSourceWrapper();
        Source source = sourceWrapper.getSource();
        NearestNode nearestNodeHolder = NearestSectionsFinder.findExprNodeBeforePos(source, line, column, this.env);
        Node nearestNode = nearestNodeHolder.getNode();
        if (nearestNode != null) {
            Future<EvaluationResult> future = this.contextAwareExecutor.executeWithNestedContext(() -> this.sourceCodeEvaluator.tryDifferentEvalStrategies(surrogate, nearestNode), true);
            EvaluationResult evalResult = this.getFutureResultOrHandleExceptions(future);
            if (evalResult == null || !evalResult.isEvaluationDone()) throw DiagnosticsNotification.create(surrogate.getUri(), Diagnostic.create(SourceUtils.sourceSectionToRange(nearestNode.getSourceSection()), "No type information available for this source section.", DiagnosticSeverity.Information, null, "Graal", null));
            if (!evalResult.isError()) {
                this.fillCompletionsFromTruffleObject(completions, surrogate.getLanguageInfo(), evalResult.getResult());
                return;
            }
            Object result = evalResult.getResult();
            if (result != null && INTEROP.isException(result)) {
                try {
                    SourceSection sourceLocation = INTEROP.hasSourceLocation(result) ? INTEROP.getSourceLocation(result) : null;
                    String exceptionMessage = INTEROP.hasExceptionMessage(result) ? INTEROP.asString(INTEROP.getExceptionMessage(result)) : null;
                    throw DiagnosticsNotification.create(surrogate.getUri(), Diagnostic.create(SourceUtils.sourceSectionToRange(sourceLocation), "An error occurred during execution: " + exceptionMessage, DiagnosticSeverity.Warning, null, "Graal", null));
                }
                catch (UnsupportedMessageException um) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)um);
                }
            }
            ((Exception)evalResult.getResult()).printStackTrace(this.err);
            return;
        }
        this.logger.fine("No object property completion possible. Caret is not directly at the end of a source section. Line: " + line + ", column: " + column);
    }

    private static boolean isObjectPropertyCompletionCharacter(String text, List<String> completionTriggerCharacters) {
        return completionTriggerCharacters.contains(text);
    }

    private static CompletionKind getCompletionKind(String text, List<String> completionTriggerCharacters) {
        return CompletionRequestHandler.isObjectPropertyCompletionCharacter(text, completionTriggerCharacters) ? CompletionKind.OBJECT_PROPERTY : CompletionKind.GLOBALS_AND_LOCALS;
    }

    public static CompletionKind getCompletionKind(Source source, int oneBasedLineNumber, int column, List<String> completionTriggerCharacters, CompletionContext completionContext) {
        if (completionContext != null && completionContext.getTriggerKind() == CompletionTriggerKind.TriggerCharacter && completionContext.getTriggerCharacter() != null) {
            if (CompletionRequestHandler.isObjectPropertyCompletionCharacter(completionContext.getTriggerCharacter(), completionTriggerCharacters)) {
                return CompletionKind.OBJECT_PROPERTY;
            }
            return CompletionKind.UNKOWN;
        }
        int lineStartOffset = source.getLineStartOffset(oneBasedLineNumber);
        if (lineStartOffset + column == 0) {
            return CompletionKind.GLOBALS_AND_LOCALS;
        }
        String text = source.getCharacters().toString();
        char charAtOffset = text.charAt(lineStartOffset + column - 1);
        return CompletionRequestHandler.getCompletionKind(String.valueOf(charAtOffset), completionTriggerCharacters);
    }

    private void fillCompletionsWithLocals(TextDocumentSurrogate surrogate, Node nearestNode, List<CompletionItem> completions, MaterializedFrame frame) {
        NodeLibrary nodeLibrary = NodeLibrary.getUncached((Object)nearestNode);
        if (nodeLibrary.hasScope((Object)nearestNode, (Frame)frame)) {
            try {
                Object scope = nodeLibrary.getScope((Object)nearestNode, (Frame)frame, true);
                this.fillCompletionsWithScopesValues(surrogate, completions, scope, CompletionItemKind.Variable, 1);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    private void fillCompletionsWithGlobals(TextDocumentSurrogate surrogate, List<CompletionItem> completions) {
        Object scope = this.env.getScope(surrogate.getLanguageInfo());
        if (scope != null) {
            this.fillCompletionsWithScopesValues(surrogate, completions, scope, null, 2);
        }
    }

    private void fillCompletionsWithScopesValues(TextDocumentSurrogate surrogate, List<CompletionItem> completions, Object scopeOriginal, CompletionItemKind completionItemKindDefault, int displayPriority) {
        LanguageInfo langInfo = surrogate.getLanguageInfo();
        String[] existingCompletions = (String[])completions.stream().map(item -> item.getLabel()).toArray(String[]::new);
        HashSet<String> completionKeys = new HashSet<String>(Arrays.asList(existingCompletions));
        int scopeCounter = 0;
        Object scope = scopeOriginal;
        while (scope != null) {
            long size;
            Object keys;
            Object scopeParent;
            block14: {
                scopeParent = null;
                if (INTEROP.hasScopeParent(scope)) {
                    try {
                        scopeParent = INTEROP.getScopeParent(scope);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                }
                ++scopeCounter;
                try {
                    keys = INTEROP.getMembers(scope, false);
                    size = INTEROP.getArraySize(keys);
                    if (scopeParent == null) break block14;
                    size -= INTEROP.getArraySize(INTEROP.getMembers(scopeParent, false));
                }
                catch (Exception ex) {
                    this.logger.log(Level.INFO, ex.getLocalizedMessage(), (Throwable)ex);
                    break;
                }
            }
            for (long i = 0L; i < size; ++i) {
                Object object;
                String key;
                try {
                    key = INTEROP.asString(INTEROP.readArrayElement(keys, i));
                    if (completionKeys.contains(key)) continue;
                    completionKeys.add(key);
                    object = INTEROP.readMember(scope, key);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    this.logger.log(Level.CONFIG, scope.toString(), t);
                    continue;
                }
                CompletionItem completion = CompletionItem.create(key);
                completion.setSortText(CompletionRequestHandler.format("%s%d.%04d.%s", "+", displayPriority, scopeCounter, key));
                if (completionItemKindDefault != null) {
                    completion.setKind(completionItemKindDefault);
                } else {
                    completion.setKind(CompletionRequestHandler.findCompletionItemKind(object));
                }
                completion.setDetail(this.createCompletionDetail(object, langInfo));
                try {
                    completion.setDocumentation(this.createDocumentation(object, surrogate.getLanguageInfo(), "in " + INTEROP.asString(INTEROP.toDisplayString(scope))));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                completions.add(completion);
            }
            scope = scopeParent;
        }
    }

    private static CompletionItemKind findCompletionItemKind(Object object) {
        if (INTEROP.isInstantiable(object)) {
            return CompletionItemKind.Class;
        }
        if (INTEROP.isExecutable(object)) {
            return CompletionItemKind.Function;
        }
        return null;
    }

    protected boolean fillCompletionsFromTruffleObject(List<CompletionItem> completions, LanguageInfo langInfo, Object object) {
        long size;
        if (object == null) {
            return false;
        }
        Object metaObject = this.getMetaObject(langInfo, object);
        if (metaObject == null) {
            return false;
        }
        Object languageView = this.env.getLanguageView(langInfo, object);
        Object members = null;
        if (INTEROP.hasMembers(languageView)) {
            try {
                members = INTEROP.getMembers(languageView);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        if (members == null || !INTEROP.hasArrayElements(members)) {
            this.logger.fine("No completions found for object: " + String.valueOf(languageView));
            return false;
        }
        int counter = 0;
        try {
            size = INTEROP.getArraySize(members);
        }
        catch (UnsupportedMessageException ex) {
            size = 0L;
        }
        for (long i = 0L; i < size; ++i) {
            Object value;
            String key;
            try {
                key = INTEROP.readArrayElement(members, i).toString();
                value = INTEROP.isMemberReadable(languageView, key) ? INTEROP.readMember(languageView, key) : null;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                this.logger.log(Level.CONFIG, languageView.toString(), t);
                continue;
            }
            CompletionItem completion = CompletionItem.create(key);
            completion.setSortText(CompletionRequestHandler.format("%s%06d.%s", "+", ++counter, key));
            completion.setKind(CompletionItemKind.Property);
            completion.setDetail(this.createCompletionDetail(value, langInfo));
            try {
                completion.setDocumentation(this.createDocumentation(value, langInfo, "of " + String.valueOf(INTEROP.getMetaQualifiedName(metaObject))));
            }
            catch (UnsupportedMessageException e) {
                throw new AssertionError((Object)e);
            }
            completions.add(completion);
        }
        return counter > 0;
    }

    private Object createDocumentation(Object value, LanguageInfo langInfo, String scopeInformation) {
        Object documentation = this.getDocumentation(value, langInfo);
        if (documentation == null) {
            Object markupStr = CompletionRequestHandler.escapeMarkdown(scopeInformation);
            Object view = this.env.getLanguageView(langInfo, value);
            if (INTEROP.hasSourceLocation(view)) {
                SourceSection section;
                try {
                    section = INTEROP.getSourceLocation(view);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new AssertionError((Object)e);
                }
                String code = section.getCharacters().toString();
                if (!code.isEmpty()) {
                    markupStr = (String)markupStr + "\n\n```\n" + section.getCharacters().toString() + "\n```";
                }
            }
            documentation = MarkupContent.create(MarkupKind.Markdown, (String)markupStr);
        }
        return documentation;
    }

    static String escapeMarkdown(String original) {
        return original.replaceAll("__", "\\\\_\\\\_");
    }

    String createCompletionDetail(Object obj, LanguageInfo langInfo) {
        Object detailText = "";
        if (obj == null) {
            return detailText;
        }
        Object view = this.env.getLanguageView(langInfo, obj);
        if (INTEROP.isExecutable(view)) {
            String formattedSignature = this.getFormattedSignature(view, langInfo);
            detailText = formattedSignature != null ? formattedSignature : "";
        }
        Object metaObject = null;
        if (INTEROP.hasMetaObject(view)) {
            try {
                metaObject = INTEROP.getMetaObject(view);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError("Unexpected unsupported message.", e);
            }
        }
        if (metaObject != null) {
            if (!((String)detailText).isEmpty()) {
                detailText = (String)detailText + " ";
            }
            try {
                detailText = (String)detailText + INTEROP.asString(INTEROP.toDisplayString(metaObject));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError("Unexpected unsupported message.", e);
            }
        }
        return detailText;
    }

    public Object getDocumentation(Object value, LanguageInfo langInfo) {
        if (!(value instanceof TruffleObject) || INTEROP.isNull(value)) {
            return null;
        }
        try {
            Object docu = LSP_INTEROP.getDocumentation(value);
            if (docu instanceof String && !((String)docu).isEmpty()) {
                return docu;
            }
            if (docu instanceof TruffleObject) {
                Object v;
                Object kind;
                TruffleObject markup = (TruffleObject)docu;
                MarkupKind markupKind = null;
                String text = null;
                if (INTEROP.isMemberReadable((Object)markup, "kind") && (kind = INTEROP.readMember((Object)markup, "kind")) instanceof String) {
                    markupKind = MarkupKind.get((String)kind);
                }
                if (markupKind == null) {
                    markupKind = MarkupKind.PlainText;
                }
                if (INTEROP.isMemberReadable((Object)markup, "value") && (v = INTEROP.readMember((Object)markup, "value")) instanceof String) {
                    text = (String)v;
                }
                assert (text != null) : "No documentation value is provided from " + String.valueOf(docu);
                if (text != null) {
                    return MarkupContent.create(markupKind, text);
                }
                return MarkupContent.create(markupKind, this.languageToString(langInfo, docu));
            }
        }
        catch (UnsupportedMessageException docu) {
        }
        catch (InteropException e) {
            e.printStackTrace(this.err);
        }
        return null;
    }

    private String languageToString(LanguageInfo langInfo, Object value) {
        try {
            return INTEROP.asString(INTEROP.toDisplayString(this.env.getLanguageView(langInfo, value)));
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)e);
        }
    }

    public String getFormattedSignature(Object truffleObj, LanguageInfo langInfo) {
        try {
            Object signature = LSP_INTEROP.getSignature(truffleObj);
            return this.languageToString(langInfo, signature);
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            return null;
        }
    }

    private LanguageInfo getObjectLanguageInfo(LanguageInfo defaultInfo, Object object) {
        assert (object != null);
        if (INTEROP.hasLanguage(object)) {
            try {
                return this.env.getLanguageInfo(INTEROP.getLanguage(object));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
        }
        return defaultInfo;
    }

    private Object getMetaObject(LanguageInfo defaultInfo, Object object) {
        LanguageInfo langInfo = this.getObjectLanguageInfo(defaultInfo, object);
        Object view = this.env.getLanguageView(langInfo, object);
        if (INTEROP.hasMetaObject(view)) {
            try {
                return INTEROP.getMetaObject(view);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError("Unexpected unsupported message.", e);
            }
        }
        return null;
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    private static enum CompletionKind {
        UNKOWN,
        OBJECT_PROPERTY,
        GLOBALS_AND_LOCALS;

    }
}

