/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.instrument;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.tools.lsp.instrument.LSPInstrument;

@GeneratedBy(value=LSPInstrument.class)
final class LSPInstrumentOptionDescriptors
implements TruffleOptionDescriptors {
    LSPInstrumentOptionDescriptors() {
    }

    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "lsp": {
                return OptionDescriptor.newBuilder(LSPInstrument.Lsp, (String)"lsp").deprecated(false).help("Start the Language Server on [[host:]port].").usageSyntax("[[<host>:]<port>]").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "lsp.Delegates": {
                return OptionDescriptor.newBuilder(LSPInstrument.Delegates, (String)"lsp.Delegates").deprecated(false).help("Delegate language servers (default: no language server).").usageSyntax("[languageId@][[host:]port],...").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "lsp.DeveloperMode": {
                return OptionDescriptor.newBuilder(LSPInstrument.DeveloperMode, (String)"lsp.DeveloperMode").deprecated(false).help("Enable features for language developers, e.g. hovering code snippets shows AST related information like the node class or tags.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "lsp.Internal": {
                return OptionDescriptor.newBuilder(LSPInstrument.Internal, (String)"lsp.Internal").deprecated(false).help("Include internal sources in goto-definition, references and symbols search.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "lsp.SocketBacklogSize": {
                return OptionDescriptor.newBuilder(LSPInstrument.SocketBacklogSize, (String)"lsp.SocketBacklogSize").deprecated(false).help("Requested maximum length of the Socket queue of incoming connections.").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
        }
        return null;
    }

    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert (this.get(optionName) != null) : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(LSPInstrument.Lsp, (String)"lsp").deprecated(false).help("Start the Language Server on [[host:]port].").usageSyntax("[[<host>:]<port>]").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(LSPInstrument.Delegates, (String)"lsp.Delegates").deprecated(false).help("Delegate language servers (default: no language server).").usageSyntax("[languageId@][[host:]port],...").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(LSPInstrument.DeveloperMode, (String)"lsp.DeveloperMode").deprecated(false).help("Enable features for language developers, e.g. hovering code snippets shows AST related information like the node class or tags.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(LSPInstrument.Internal, (String)"lsp.Internal").deprecated(false).help("Include internal sources in goto-definition, references and symbols search.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(LSPInstrument.SocketBacklogSize, (String)"lsp.SocketBacklogSize").deprecated(false).help("Requested maximum length of the Socket queue of incoming connections.").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build()).iterator();
    }
}

