/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.hosted.annotation.CustomSubstitutionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.Pair;

public class CustomSubstitution<T extends CustomSubstitutionType<?, ?>>
extends SubstitutionProcessor {
    protected final MetaAccessProvider metaAccess;
    protected final Map<ResolvedJavaType, T> typeSubstitutions;

    public CustomSubstitution(MetaAccessProvider metaAccess) {
        this.metaAccess = metaAccess;
        this.typeSubstitutions = new HashMap<ResolvedJavaType, T>();
    }

    protected T getSubstitutionType(ResolvedJavaType original) {
        return (T)((CustomSubstitutionType)this.typeSubstitutions.get(original));
    }

    protected static String canonicalMethodName(ResolvedJavaMethod method) {
        String result = method.getName();
        while (result.endsWith("*")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected static List<Pair<String, ResolvedJavaType>> findAttributes(ResolvedJavaType annotationType) {
        ArrayList<Pair<String, ResolvedJavaType>> attributes = new ArrayList<Pair<String, ResolvedJavaType>>();
        for (ResolvedJavaMethod method : annotationType.getDeclaredMethods()) {
            String methodName = CustomSubstitution.canonicalMethodName(method);
            if (methodName.equals("equals") || methodName.equals("hashCode") || methodName.equals("toString") || methodName.equals("annotationType") || methodName.equals("proxyClassLookup")) continue;
            ResolvedJavaType returnType = (ResolvedJavaType)method.getSignature().getReturnType(null);
            attributes.add((Pair<String, ResolvedJavaType>)Pair.create((Object)methodName, (Object)returnType));
        }
        Collections.sort(attributes, Comparator.comparing(Pair::getLeft));
        return attributes;
    }

    protected static ResolvedJavaMethod findMethod(ResolvedJavaType declaringType, String name, ResolvedJavaType ... argumentTypes) {
        ResolvedJavaMethod result = null;
        block0: for (ResolvedJavaMethod method : declaringType.getDeclaredMethods()) {
            if (!CustomSubstitution.canonicalMethodName(method).equals(name) || method.getSignature().getParameterCount(false) != argumentTypes.length) continue;
            Signature sig = method.getSignature();
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (!sig.getParameterType(i, null).resolve(null).isAssignableFrom(argumentTypes[i])) continue block0;
            }
            assert (result == null) : "more than one matching method found";
            result = method;
        }
        assert (result != null) : "no matching method found";
        return result;
    }

    protected static ResolvedJavaField findField(ResolvedJavaType declaringType, String name) {
        ResolvedJavaField result = null;
        for (ResolvedJavaField field : declaringType.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            assert (result == null) : "more than one matching field found";
            result = field;
        }
        assert (result != null) : "no matching field found";
        return result;
    }
}

