/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

public final class NativeImageSystemClassLoader
extends SecureClassLoader {
    public final ClassLoader defaultSystemClassLoader;
    final NativeImageSystemIOWrappers systemIOWrappers;
    private volatile ClassLoader nativeImageClassLoader = null;
    private Set<ClassLoader> disallowedClassLoaders = Collections.newSetFromMap(new WeakHashMap());
    private static final Method loadClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"loadClass", (Class[])new Class[]{String.class, Boolean.TYPE});
    private static final Method findResource = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"findResource", (Class[])new Class[]{String.class});
    private static final Method findResources = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"findResources", (Class[])new Class[]{String.class});
    private static final Method defineClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
    private static final Constructor<Enumeration<?>> compoundEnumerationConstructor;

    public NativeImageSystemClassLoader(ClassLoader defaultSystemClassLoader) {
        super(defaultSystemClassLoader);
        this.defaultSystemClassLoader = defaultSystemClassLoader;
        this.systemIOWrappers = new NativeImageSystemIOWrappers();
        this.systemIOWrappers.replaceSystemOutErr();
    }

    public static NativeImageSystemClassLoader singleton() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof NativeImageSystemClassLoader) {
            return (NativeImageSystemClassLoader)loader;
        }
        throw UserError.abort("NativeImageSystemClassLoader is not the default system class loader. This might create problems when using reflection during class initialization at build-time.To fix this error add -Djava.system.class.loader=%s", NativeImageSystemClassLoader.class.getCanonicalName());
    }

    public void setNativeImageClassLoader(ClassLoader nativeImageClassLoader) {
        if (nativeImageClassLoader == null && this.nativeImageClassLoader != null) {
            this.disallowedClassLoaders.add(this.nativeImageClassLoader);
        }
        this.nativeImageClassLoader = nativeImageClassLoader;
    }

    private boolean isNativeImageClassLoader(ClassLoader current, ClassLoader c) {
        ClassLoader loader = current;
        do {
            if (loader != c) continue;
            return true;
        } while ((loader = loader.getParent()) != this.defaultSystemClassLoader);
        return false;
    }

    public boolean isNativeImageClassLoader(ClassLoader c) {
        ClassLoader loader = this.nativeImageClassLoader;
        if (loader == null) {
            return false;
        }
        return this.isNativeImageClassLoader(this.nativeImageClassLoader, c);
    }

    public boolean isDisallowedClassLoader(ClassLoader c) {
        for (ClassLoader disallowedClassLoader : this.disallowedClassLoaders) {
            if (!this.isNativeImageClassLoader(disallowedClassLoader, c)) continue;
            return true;
        }
        return false;
    }

    private static Class<?> loadClass(List<ClassLoader> activeClassLoaders, String name, boolean resolve) throws ClassNotFoundException {
        ClassNotFoundException classNotFoundException = null;
        for (ClassLoader loader : activeClassLoaders) {
            try {
                return (Class)loadClass.invoke((Object)loader, name, resolve);
            }
            catch (Exception e) {
                if (e.getCause() instanceof ClassNotFoundException) {
                    classNotFoundException = (ClassNotFoundException)e.getCause();
                    continue;
                }
                String message = String.format("Can not load class: %s, with class loader: %s", name, loader);
                VMError.shouldNotReachHere(message, e);
            }
        }
        VMError.guarantee(classNotFoundException != null);
        throw classNotFoundException;
    }

    private static URL findResource(List<ClassLoader> activeClassLoaders, String name) {
        for (ClassLoader loader : activeClassLoaders) {
            try {
                Object url = findResource.invoke((Object)loader, name);
                if (url == null) continue;
                return (URL)url;
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                String message = String.format("Can not find resource: %s using class loader: %s", name, loader);
                VMError.shouldNotReachHere(message, e);
            }
        }
        return null;
    }

    private static Enumeration<URL> findResources(ClassLoader classLoader, String name) {
        try {
            return (Enumeration)findResources.invoke((Object)classLoader, name);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Can not find resources: %s using class loader: %s", name, classLoader);
            VMError.shouldNotReachHere(message, e);
            return null;
        }
    }

    static Class<?> defineClass(ClassLoader classLoader, String name, byte[] b, int offset, int length) {
        try {
            return (Class)defineClass.invoke((Object)classLoader, name, b, offset, length);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Cannot define class %s from byte[%d..%d] using class loader: %s", name, offset, offset + length, classLoader);
            VMError.shouldNotReachHere(message, e);
            return null;
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return NativeImageSystemClassLoader.loadClass(this.getActiveClassLoaders(), name, resolve);
    }

    @Override
    protected URL findResource(String name) {
        return NativeImageSystemClassLoader.findResource(this.getActiveClassLoaders(), name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ClassLoader activeClassLoaderParent;
        List<ClassLoader> activeClassLoaders = this.getActiveClassLoaders();
        assert (!activeClassLoaders.isEmpty() && activeClassLoaders.size() <= 2);
        ClassLoader activeClassLoader = activeClassLoaders.get(0);
        ClassLoader classLoader = activeClassLoaderParent = activeClassLoaders.size() > 1 ? activeClassLoaders.get(1) : null;
        if (activeClassLoaderParent != null) {
            return NativeImageSystemClassLoader.newCompoundEnumeration(NativeImageSystemClassLoader.findResources(activeClassLoaderParent, name), NativeImageSystemClassLoader.findResources(activeClassLoader, name));
        }
        return NativeImageSystemClassLoader.findResources(activeClassLoader, name);
    }

    private static <T> Enumeration<T> newCompoundEnumeration(Enumeration<?> ... enums) {
        try {
            return compoundEnumerationConstructor.newInstance(new Object[]{enums});
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere("Cannot instantiate CompoundEnumeration", e);
        }
    }

    public Class<?> forNameOrNull(String name, boolean initialize) {
        try {
            return Class.forName(name, initialize, this.getActiveClassLoaders().get(0));
        }
        catch (ClassNotFoundException | LinkageError ignored) {
            return null;
        }
    }

    public Class<?> predefineClass(String name, byte[] array, int offset, int length) {
        VMError.guarantee(name != null, "The class name must be specified");
        if (this.forNameOrNull(name, false) != null) {
            throw VMError.shouldNotReachHere("The class loader hierarchy already provides a class with the same name as the class submitted for predefinition: " + name);
        }
        return NativeImageSystemClassLoader.defineClass(this.getActiveClassLoaders().get(0), name, array, offset, length);
    }

    public String toString() {
        String clString = super.toString();
        return clString + " {delegate=" + String.valueOf(this.nativeImageClassLoader) + ", defaultSystemClassLoader=" + String.valueOf(this.defaultSystemClassLoader) + "}";
    }

    private List<ClassLoader> getActiveClassLoaders() {
        ClassLoader activeClassLoader = this.nativeImageClassLoader;
        if (activeClassLoader != null) {
            if (activeClassLoader instanceof URLClassLoader) {
                return List.of(activeClassLoader);
            }
            return List.of(activeClassLoader, activeClassLoader.getParent());
        }
        return List.of(this.defaultSystemClassLoader);
    }

    private void appendToClassPathForInstrumentation(String classPathEntry) {
        try {
            Method method = ReflectionUtil.lookupMethod(this.getParent().getClass(), (String)"appendToClassPathForInstrumentation", (Class[])new Class[]{String.class});
            method.invoke((Object)this.getParent(), classPathEntry);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Can not add jar: %s to class path. Due to %s", classPathEntry, e);
            VMError.shouldNotReachHere(message, e);
        }
    }

    static {
        String className = "java.lang.CompoundEnumeration";
        try {
            Class<?> compoundEnumerationClass = Class.forName(className);
            compoundEnumerationConstructor = ReflectionUtil.lookupConstructor(compoundEnumerationClass, (Class[])new Class[]{Enumeration[].class});
        }
        catch (ReflectionUtil.ReflectionUtilError | ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("Unable to get access to class " + className, e);
        }
    }
}

